/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3.remote;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.security.AccessControlContext;
import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import javax.security.sasl.SaslServerFactory;
import org.jboss.remoting3.RemotingOptions;
import org.jboss.remoting3.Version;
import org.jboss.remoting3.remote.ExternalSaslServerFactory;
import org.jboss.remoting3.remote.ProtocolUtils;
import org.jboss.remoting3.remote.RemoteAuthLogger;
import org.jboss.remoting3.remote.RemoteConnection;
import org.jboss.remoting3.remote.RemoteConnectionHandler;
import org.jboss.remoting3.remote.RemoteLogger;
import org.jboss.remoting3.remote.RemoteReadListener;
import org.jboss.remoting3.security.AuthorizingCallbackHandler;
import org.jboss.remoting3.security.InetAddressPrincipal;
import org.jboss.remoting3.security.ServerAuthenticationProvider;
import org.jboss.remoting3.security.UserInfo;
import org.jboss.remoting3.security.UserPrincipal;
import org.jboss.remoting3.spi.ConnectionHandler;
import org.jboss.remoting3.spi.ConnectionHandlerContext;
import org.jboss.remoting3.spi.ConnectionHandlerFactory;
import org.jboss.remoting3.spi.ConnectionProviderContext;
import org.xnio.Buffers;
import org.xnio.ChannelListener;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Pooled;
import org.xnio.Sequence;
import org.xnio.channels.Channels;
import org.xnio.channels.Configurable;
import org.xnio.channels.ConnectedMessageChannel;
import org.xnio.channels.SslChannel;
import org.xnio.sasl.SaslUtils;
import org.xnio.sasl.SaslWrapper;

final class ServerConnectionOpenListener
implements ChannelListener<ConnectedMessageChannel> {
    private final RemoteConnection connection;
    private final ConnectionProviderContext connectionProviderContext;
    private final ServerAuthenticationProvider serverAuthenticationProvider;
    private final OptionMap optionMap;
    private final AccessControlContext accessControlContext;
    private final AtomicInteger retryCount = new AtomicInteger(8);
    private final String serverName;

    ServerConnectionOpenListener(RemoteConnection connection, ConnectionProviderContext connectionProviderContext, ServerAuthenticationProvider serverAuthenticationProvider, OptionMap optionMap, AccessControlContext accessControlContext) {
        this.connection = connection;
        this.connectionProviderContext = connectionProviderContext;
        this.serverAuthenticationProvider = serverAuthenticationProvider;
        this.optionMap = optionMap;
        this.accessControlContext = accessControlContext;
        this.serverName = optionMap.contains(RemotingOptions.SERVER_NAME) ? (String)optionMap.get(RemotingOptions.SERVER_NAME) : ((InetSocketAddress)connection.getChannel().getLocalAddress(InetSocketAddress.class)).getHostName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvent(ConnectedMessageChannel channel) {
        Pooled<ByteBuffer> pooled = this.connection.allocate();
        boolean ok = false;
        try {
            ByteBuffer sendBuffer = (ByteBuffer)pooled.getResource();
            sendBuffer.put((byte)0);
            ProtocolUtils.writeString(sendBuffer, (byte)0, this.serverName);
            sendBuffer.flip();
            this.connection.setReadListener(new Initial(), true);
            this.connection.send(pooled);
            ok = true;
            return;
        }
        catch (BufferUnderflowException e) {
            this.connection.handleException(RemoteLogger.log.invalidMessage(this.connection));
            return;
        }
        catch (BufferOverflowException e) {
            this.connection.handleException(RemoteLogger.log.invalidMessage(this.connection));
            return;
        }
        finally {
            if (!ok) {
                pooled.free();
            }
        }
    }

    private void saslDispose(SaslServer saslServer) {
        if (saslServer != null) {
            try {
                saslServer.dispose();
            }
            catch (SaslException e) {
                RemoteLogger.server.trace("Failure disposing of SaslServer", e);
            }
        }
    }

    static /* synthetic */ ServerAuthenticationProvider access$300(ServerConnectionOpenListener x0) {
        return x0.serverAuthenticationProvider;
    }

    static /* synthetic */ AccessControlContext access$600(ServerConnectionOpenListener x0) {
        return x0.accessControlContext;
    }

    final class Authentication
    implements ChannelListener<ConnectedMessageChannel> {
        private final SaslServer saslServer;
        private final AuthorizingCallbackHandler authorizingCallbackHandler;
        private final String remoteEndpointName;
        private final int behavior;
        private final int maxInboundChannels;
        private final int maxOutboundChannels;

        Authentication(SaslServer saslServer, AuthorizingCallbackHandler authorizingCallbackHandler, String remoteEndpointName, int behavior, int maxInboundChannels, int maxOutboundChannels) {
            this.saslServer = saslServer;
            this.authorizingCallbackHandler = authorizingCallbackHandler;
            this.remoteEndpointName = remoteEndpointName;
            this.behavior = behavior;
            this.maxInboundChannels = maxInboundChannels;
            this.maxOutboundChannels = maxOutboundChannels;
        }

        /*
         * Exception decompiling
         */
        public void handleEvent(ConnectedMessageChannel channel) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 3[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    final class AuthStepRunnable
    implements Runnable {
        private final boolean isInitial;
        private final SaslServer saslServer;
        private final AuthorizingCallbackHandler authorizingCallbackHandler;
        private final Pooled<ByteBuffer> buffer;
        private final String remoteEndpointName;
        private final int behavior;
        private final int maxInboundChannels;
        private final int maxOutboundChannels;

        AuthStepRunnable(boolean isInitial, SaslServer saslServer, AuthorizingCallbackHandler authorizingCallbackHandler, Pooled<ByteBuffer> buffer, String remoteEndpointName, int behavior, int maxInboundChannels, int maxOutboundChannels) {
            this.isInitial = isInitial;
            this.saslServer = saslServer;
            this.authorizingCallbackHandler = authorizingCallbackHandler;
            this.buffer = buffer;
            this.remoteEndpointName = remoteEndpointName;
            this.behavior = behavior;
            this.maxInboundChannels = maxInboundChannels;
            this.maxOutboundChannels = maxOutboundChannels;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean ok = false;
            boolean close = false;
            try {
                block14: {
                    Pooled<ByteBuffer> pooled = ServerConnectionOpenListener.this.connection.allocate();
                    try {
                        ByteBuffer sendBuffer = (ByteBuffer)pooled.getResource();
                        int p = sendBuffer.position();
                        try {
                            sendBuffer.put((byte)5);
                            if (SaslUtils.evaluateResponse((SaslServer)this.saslServer, (ByteBuffer)sendBuffer, (ByteBuffer)((ByteBuffer)this.buffer.getResource()))) {
                                RemoteLogger.server.tracef("Server sending authentication complete", new Object[0]);
                                final Collection<Principal> principals = this.createPrincipals();
                                final UserInfo userInfo = this.authorizingCallbackHandler.createUserInfo(principals);
                                ServerConnectionOpenListener.this.connectionProviderContext.accept(new ConnectionHandlerFactory(){

                                    @Override
                                    public ConnectionHandler createInstance(ConnectionHandlerContext connectionContext) {
                                        Object qop = AuthStepRunnable.this.saslServer.getNegotiatedProperty("javax.security.sasl.qop");
                                        if (!AuthStepRunnable.this.isInitial && ("auth-int".equals(qop) || "auth-conf".equals(qop))) {
                                            ServerConnectionOpenListener.this.connection.setSaslWrapper(SaslWrapper.create((SaslServer)AuthStepRunnable.this.saslServer));
                                        }
                                        RemoteConnectionHandler connectionHandler = new RemoteConnectionHandler(connectionContext, ServerConnectionOpenListener.this.connection, principals, userInfo, AuthStepRunnable.this.maxInboundChannels, AuthStepRunnable.this.maxOutboundChannels, AuthStepRunnable.this.remoteEndpointName, AuthStepRunnable.this.behavior);
                                        ServerConnectionOpenListener.this.connection.getRemoteConnectionProvider().addConnectionHandler(connectionHandler);
                                        ServerConnectionOpenListener.this.connection.setReadListener(new RemoteReadListener(connectionHandler, ServerConnectionOpenListener.this.connection), false);
                                        return connectionHandler;
                                    }
                                });
                            } else {
                                RemoteLogger.server.tracef("Server sending authentication challenge", new Object[0]);
                                sendBuffer.put(p, (byte)3);
                                if (this.isInitial) {
                                    ServerConnectionOpenListener.this.connection.setReadListener(new Authentication(this.saslServer, this.authorizingCallbackHandler, this.remoteEndpointName, this.behavior, this.maxInboundChannels, this.maxOutboundChannels), false);
                                }
                            }
                        }
                        catch (Throwable e) {
                            RemoteLogger.server.tracef(e, "Server sending authentication rejected", new Object[0]);
                            sendBuffer.put(p, (byte)6);
                            ServerConnectionOpenListener.this.saslDispose(this.saslServer);
                            if (this.isInitial) {
                                if (ServerConnectionOpenListener.this.retryCount.decrementAndGet() <= 0) {
                                    close = true;
                                }
                            }
                            ServerConnectionOpenListener.this.connection.setReadListener(new Initial(), false);
                        }
                        sendBuffer.flip();
                        ServerConnectionOpenListener.this.connection.send(pooled, close);
                        ok = true;
                        ServerConnectionOpenListener.this.connection.getChannel().resumeReads();
                        if (ok) break block14;
                    }
                    catch (Throwable throwable) {
                        if (!ok) {
                            pooled.free();
                        }
                        throw throwable;
                    }
                    pooled.free();
                }
                return;
            }
            finally {
                this.buffer.free();
            }
        }

        private Collection<Principal> createPrincipals() {
            ConnectedMessageChannel channel;
            InetSocketAddress address;
            String authorizationId;
            SSLSession session;
            LinkedHashSet<Principal> principals = new LinkedHashSet<Principal>();
            SslChannel sslChannel = ServerConnectionOpenListener.this.connection.getSslChannel();
            if (sslChannel != null && (session = sslChannel.getSslSession()) != null) {
                try {
                    principals.add(session.getPeerPrincipal());
                }
                catch (SSLPeerUnverifiedException ignored) {
                    // empty catch block
                }
            }
            if ((authorizationId = this.saslServer.getAuthorizationID()) != null) {
                principals.add(new UserPrincipal(authorizationId));
            }
            if ((address = (InetSocketAddress)(channel = ServerConnectionOpenListener.this.connection.getChannel()).getPeerAddress(InetSocketAddress.class)) != null) {
                principals.add(new InetAddressPrincipal(address.getAddress()));
            }
            return Collections.unmodifiableCollection(principals);
        }
    }

    final class Initial
    implements ChannelListener<ConnectedMessageChannel> {
        private boolean starttls;
        private Map<String, ?> propertyMap;
        private Map<String, SaslServerFactory> allowedMechanisms;
        private int version = 1;
        private int channelsIn = 40;
        private int channelsOut = 40;
        private String remoteEndpointName;
        private int behavior = 2;

        Initial() {
        }

        void initialiseCapabilities() {
            SslChannel sslChannel = ServerConnectionOpenListener.this.connection.getSslChannel();
            boolean channelSecure = Channels.getOption((Configurable)ServerConnectionOpenListener.this.connection.getChannel(), (Option)Options.SECURE, (boolean)false);
            this.starttls = sslChannel != null && !channelSecure;
            LinkedHashMap<String, SaslServerFactory> foundMechanisms = new LinkedHashMap<String, SaslServerFactory>();
            Map propertyMap = SaslUtils.createPropertyMap((OptionMap)ServerConnectionOpenListener.this.optionMap, (boolean)channelSecure);
            Sequence saslMechs = (Sequence)ServerConnectionOpenListener.this.optionMap.get(Options.SASL_MECHANISMS);
            LinkedHashSet restrictions = saslMechs == null ? null : new LinkedHashSet(saslMechs);
            Sequence saslNoMechs = (Sequence)ServerConnectionOpenListener.this.optionMap.get(Options.SASL_DISALLOWED_MECHANISMS);
            HashSet disallowed = saslNoMechs == null ? Collections.emptySet() : new HashSet(saslNoMechs);
            Iterator factories = SaslUtils.getSaslServerFactories((ClassLoader)this.getClass().getClassLoader(), (boolean)true);
            try {
                if ((restrictions == null || restrictions.contains("EXTERNAL")) && !disallowed.contains("EXTERNAL")) {
                    SSLSession sslSession;
                    if (sslChannel != null && (sslSession = sslChannel.getSslSession()) != null) {
                        Principal principal = sslSession.getPeerPrincipal();
                        if (principal != null) {
                            foundMechanisms.put("EXTERNAL", new ExternalSaslServerFactory(principal));
                        } else {
                            RemoteLogger.server.trace("No EXTERNAL mechanism due to lack of peer principal");
                        }
                    } else {
                        RemoteLogger.server.trace("No EXTERNAL mechanism due to lack of SSL");
                    }
                } else {
                    RemoteLogger.server.trace("No EXTERNAL mechanism due to explicit exclusion");
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            while (factories.hasNext()) {
                SaslServerFactory factory = (SaslServerFactory)factories.next();
                RemoteLogger.server.tracef("Trying SASL server factory %s", factory);
                for (String mechName : factory.getMechanismNames(propertyMap)) {
                    if (restrictions != null && !restrictions.contains(mechName)) {
                        RemoteLogger.server.tracef("Excluding mechanism %s because it is not in the allowed list", mechName);
                        continue;
                    }
                    if (disallowed.contains(mechName)) {
                        RemoteLogger.server.tracef("Excluding mechanism %s because it is in the disallowed list", mechName);
                        continue;
                    }
                    if (foundMechanisms.containsKey(mechName)) {
                        RemoteLogger.server.tracef("Excluding repeated occurrence of mechanism %s", mechName);
                        continue;
                    }
                    RemoteLogger.server.tracef("Added mechanism %s", mechName);
                    foundMechanisms.put(mechName, factory);
                }
            }
            this.propertyMap = propertyMap;
            if (restrictions == null) {
                this.allowedMechanisms = foundMechanisms;
            } else {
                LinkedHashMap<String, SaslServerFactory> allowedMechanisms = new LinkedHashMap<String, SaslServerFactory>();
                for (String name : restrictions) {
                    if (!foundMechanisms.containsKey(name)) continue;
                    allowedMechanisms.put(name, (SaslServerFactory)foundMechanisms.get(name));
                }
                this.allowedMechanisms = allowedMechanisms;
            }
        }

        /*
         * Exception decompiling
         */
        public void handleEvent(ConnectedMessageChannel channel) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 3[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void rejectAuthentication(String mechName) {
            RemoteAuthLogger.authLog.rejectedInvalidMechanism(mechName);
            Pooled<ByteBuffer> pooled = ServerConnectionOpenListener.this.connection.allocate();
            boolean ok = false;
            try {
                ByteBuffer sendBuffer = (ByteBuffer)pooled.getResource();
                sendBuffer.put((byte)6);
                sendBuffer.flip();
                ServerConnectionOpenListener.this.connection.send(pooled);
                ok = true;
            }
            finally {
                if (!ok) {
                    pooled.free();
                }
            }
        }

        void handleClientCapabilities(ByteBuffer receiveBuffer) {
            boolean useDefaultChannels = true;
            int channelsIn = 40;
            int channelsOut = 40;
            block8: while (receiveBuffer.hasRemaining()) {
                byte type = receiveBuffer.get();
                int len = receiveBuffer.get() & 0xFF;
                ByteBuffer data = Buffers.slice((ByteBuffer)receiveBuffer, (int)len);
                switch (type) {
                    case 0: {
                        byte version = data.get();
                        RemoteLogger.server.tracef("Server received capability: version %d", version & 0xFF);
                        this.version = Math.min(1, version & 0xFF);
                        continue block8;
                    }
                    case 3: {
                        this.remoteEndpointName = Buffers.getModifiedUtf8((ByteBuffer)data);
                        RemoteLogger.server.tracef("Server received capability: remote endpoint name \"%s\"", this.remoteEndpointName);
                        continue block8;
                    }
                    case 4: {
                        this.behavior |= 1;
                        this.behavior &= 0xFFFFFFFD;
                        RemoteLogger.server.tracef("Server received capability: message close protocol supported", new Object[0]);
                        continue block8;
                    }
                    case 5: {
                        this.behavior &= 0xFFFFFFFD;
                        String remoteVersionString = Buffers.getModifiedUtf8((ByteBuffer)data);
                        RemoteLogger.server.tracef("Server received capability: remote version is \"%s\"", remoteVersionString);
                        continue block8;
                    }
                    case 6: {
                        useDefaultChannels = false;
                        channelsOut = ProtocolUtils.readIntData(data, len);
                        RemoteLogger.server.tracef("Server received capability: remote channels in is \"%d\"", channelsOut);
                        continue block8;
                    }
                    case 7: {
                        useDefaultChannels = false;
                        channelsIn = ProtocolUtils.readIntData(data, len);
                        RemoteLogger.server.tracef("Server received capability: remote channels out is \"%d\"", channelsIn);
                        continue block8;
                    }
                }
                RemoteLogger.server.tracef("Server received unknown capability %02x", type & 0xFF);
            }
            if (!useDefaultChannels) {
                this.channelsIn = channelsIn;
                this.channelsOut = channelsOut;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void sendCapabilities() {
            if (this.allowedMechanisms == null) {
                this.initialiseCapabilities();
            }
            Pooled<ByteBuffer> pooled = ServerConnectionOpenListener.this.connection.allocate();
            boolean ok = false;
            try {
                ByteBuffer sendBuffer = (ByteBuffer)pooled.getResource();
                sendBuffer.put((byte)1);
                ProtocolUtils.writeByte(sendBuffer, 0, this.version);
                String localEndpointName = ServerConnectionOpenListener.this.connectionProviderContext.getEndpoint().getName();
                if (localEndpointName != null) {
                    ProtocolUtils.writeString(sendBuffer, (byte)3, localEndpointName);
                }
                if (this.starttls) {
                    ProtocolUtils.writeEmpty(sendBuffer, 2);
                }
                for (String mechName : this.allowedMechanisms.keySet()) {
                    ProtocolUtils.writeString(sendBuffer, (byte)1, mechName);
                }
                ProtocolUtils.writeEmpty(sendBuffer, 4);
                ProtocolUtils.writeString(sendBuffer, (byte)5, Version.getVersionString());
                ProtocolUtils.writeInt(sendBuffer, 6, ServerConnectionOpenListener.this.optionMap.get(RemotingOptions.MAX_INBOUND_CHANNELS, 40));
                ProtocolUtils.writeInt(sendBuffer, 7, ServerConnectionOpenListener.this.optionMap.get(RemotingOptions.MAX_OUTBOUND_CHANNELS, 40));
                sendBuffer.flip();
                ServerConnectionOpenListener.this.connection.send(pooled);
                ok = true;
                return;
            }
            finally {
                if (!ok) {
                    pooled.free();
                }
            }
        }
    }
}

