/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3.remote;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.Serializable;
import java.net.SocketAddress;
import java.util.Arrays;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.jboss.remoting3.ChannelBusyException;
import org.jboss.remoting3.NotOpenException;
import org.jboss.remoting3.remote.RemoteConnection;
import org.jboss.remoting3.remote.RemoteLogger;

public class RemoteLogger_$logger
extends DelegatingBasicLogger
implements Serializable,
BasicLogger,
RemoteLogger {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = RemoteLogger_$logger.class.getName();
    private static final String channelBusy = "JBREM000207: Failed to send a message (channel is busy)";
    private static final String writeInterrupted = "JBREM000208: Write operation interrupted";
    private static final String channelNotOpen = "JBREM000206: Channel is not open";
    private static final String bufferUnderflowRaw = "JBREM000203: Message missing protocol byte";
    private static final String invalidWorker = "JBREM000211: Invalid XNIO worker; the worker must match the Remoting Endpoint worker";
    private static final String invalidMessage = "JBREM000201: Received invalid message on %s";
    private static final String duplicateMessageIdException = "Internal Error: received a message with a duplicate ID";
    private static final String unknownProtocolId = "Message with unknown protocol ID %d received";
    private static final String abruptClose = "JBREM000202: Abrupt close on %s";
    private static final String failedToAccept = "JBREM000205: Failed to accept a connection: %s";
    private static final String exceptionInUserHandler = "JBREM000209: An exception occurred in a message handler";
    private static final String duplicateMessageId = "JBREM000210: Internal Error: received a message with duplicate ID %d from %s";
    private static final String connectionError = "JBREM000200: Remote connection failed: %s";
    private static final String bufferUnderflow = "JBREM000204: Buffer underflow parsing message with protocol ID %02x";

    public RemoteLogger_$logger(Logger log) {
        super(log);
    }

    @Override
    public final ChannelBusyException channelBusy() {
        ChannelBusyException result = new ChannelBusyException(String.format(this.channelBusy$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String channelBusy$str() {
        return channelBusy;
    }

    @Override
    public final InterruptedIOException writeInterrupted() {
        InterruptedIOException result = new InterruptedIOException(String.format(this.writeInterrupted$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String writeInterrupted$str() {
        return writeInterrupted;
    }

    @Override
    public final NotOpenException channelNotOpen() {
        NotOpenException result = new NotOpenException(String.format(this.channelNotOpen$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String channelNotOpen$str() {
        return channelNotOpen;
    }

    @Override
    public final void bufferUnderflowRaw() {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.bufferUnderflowRaw$str(), new Object[0]);
    }

    protected String bufferUnderflowRaw$str() {
        return bufferUnderflowRaw;
    }

    @Override
    public final IllegalArgumentException invalidWorker() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.invalidWorker$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidWorker$str() {
        return invalidWorker;
    }

    @Override
    public final IOException invalidMessage(RemoteConnection connection) {
        IOException result = new IOException(String.format(this.invalidMessage$str(), connection));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidMessage$str() {
        return invalidMessage;
    }

    @Override
    public final IOException duplicateMessageIdException() {
        IOException result = new IOException(String.format(this.duplicateMessageIdException$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String duplicateMessageIdException$str() {
        return duplicateMessageIdException;
    }

    @Override
    public final void unknownProtocolId(int id) {
        this.log.logf(FQCN, Logger.Level.TRACE, null, this.unknownProtocolId$str(), (Object)id);
    }

    protected String unknownProtocolId$str() {
        return unknownProtocolId;
    }

    @Override
    public final IOException abruptClose(RemoteConnection connection) {
        IOException result = new IOException(String.format(this.abruptClose$str(), connection));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String abruptClose$str() {
        return abruptClose;
    }

    @Override
    public final void failedToAccept(IOException e) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.failedToAccept$str(), (Object)e);
    }

    protected String failedToAccept$str() {
        return failedToAccept;
    }

    @Override
    public final void exceptionInUserHandler(Throwable throwable) {
        this.log.logf(FQCN, Logger.Level.ERROR, throwable, this.exceptionInUserHandler$str(), new Object[0]);
    }

    protected String exceptionInUserHandler$str() {
        return exceptionInUserHandler;
    }

    @Override
    public final void duplicateMessageId(short messageId, SocketAddress peerAddress) {
        this.log.logf(FQCN, Logger.Level.FATAL, null, this.duplicateMessageId$str(), (Object)messageId, (Object)peerAddress);
    }

    protected String duplicateMessageId$str() {
        return duplicateMessageId;
    }

    @Override
    public final void connectionError(IOException cause) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.connectionError$str(), (Object)cause);
    }

    protected String connectionError$str() {
        return connectionError;
    }

    @Override
    public final void bufferUnderflow(int id) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.bufferUnderflow$str(), (Object)id);
    }

    protected String bufferUnderflow$str() {
        return bufferUnderflow;
    }
}

