/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3.remote;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.jboss.remoting3.MessageCancelledException;
import org.jboss.remoting3.MessageInputStream;
import org.jboss.remoting3.remote.IntIndexer;
import org.jboss.remoting3.remote.RemoteConnectionChannel;
import org.jboss.remoting3.remote.RemoteLogger;
import org.xnio.Pooled;
import org.xnio.streams.BufferPipeInputStream;

final class InboundMessage {
    final short messageId;
    final RemoteConnectionChannel channel;
    int inboundWindow;
    boolean streamClosed;
    boolean closeSent;
    boolean eofReceived;
    boolean cancelled;
    long remaining;
    static final IntIndexer<InboundMessage> INDEXER = new IntIndexer<InboundMessage>(){

        @Override
        public int getKey(InboundMessage argument) {
            return argument.messageId & 0xFFFF;
        }

        public boolean equals(InboundMessage argument, int index) {
            return (argument.messageId & 0xFFFF) == index;
        }
    };
    final BufferPipeInputStream inputStream = new BufferPipeInputStream(new BufferPipeInputStream.InputHandler(){

        public void acknowledge(Pooled<ByteBuffer> acked) throws IOException {
            InboundMessage.this.doAcknowledge((Pooled<ByteBuffer>)acked);
        }

        public void close() throws IOException {
            InboundMessage.this.doClose();
        }
    });
    final MessageInputStream messageInputStream = new MessageInputStream(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read() throws IOException {
            BufferPipeInputStream bufferPipeInputStream = InboundMessage.this.inputStream;
            synchronized (bufferPipeInputStream) {
                if (InboundMessage.this.cancelled) {
                    throw new MessageCancelledException();
                }
                return InboundMessage.this.inputStream.read();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(byte[] bytes, int offs, int length) throws IOException {
            BufferPipeInputStream bufferPipeInputStream = InboundMessage.this.inputStream;
            synchronized (bufferPipeInputStream) {
                if (InboundMessage.this.cancelled) {
                    throw new MessageCancelledException();
                }
                return InboundMessage.this.inputStream.read(bytes, offs, length);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long skip(long l) throws IOException {
            BufferPipeInputStream bufferPipeInputStream = InboundMessage.this.inputStream;
            synchronized (bufferPipeInputStream) {
                if (InboundMessage.this.cancelled) {
                    throw new MessageCancelledException();
                }
                return InboundMessage.this.inputStream.skip(l);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int available() throws IOException {
            BufferPipeInputStream bufferPipeInputStream = InboundMessage.this.inputStream;
            synchronized (bufferPipeInputStream) {
                if (InboundMessage.this.cancelled) {
                    throw new MessageCancelledException();
                }
                return InboundMessage.this.inputStream.available();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            BufferPipeInputStream bufferPipeInputStream = InboundMessage.this.inputStream;
            synchronized (bufferPipeInputStream) {
                if (InboundMessage.this.cancelled) {
                    throw new MessageCancelledException();
                }
                InboundMessage.this.inputStream.close();
            }
        }
    };

    InboundMessage(short messageId, RemoteConnectionChannel channel, int inboundWindow, long maxInboundMessageSize) {
        this.messageId = messageId;
        this.channel = channel;
        this.inboundWindow = inboundWindow;
        this.remaining = maxInboundMessageSize;
    }

    private void doClose() {
        assert (Thread.holdsLock(this.inputStream));
        if (this.streamClosed) {
            return;
        }
        this.streamClosed = true;
        this.doSendCloseMessage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSendCloseMessage() {
        assert (Thread.holdsLock(this.inputStream));
        if (this.closeSent || !this.channel.getConnectionHandler().isMessageClose()) {
            return;
        }
        Pooled<ByteBuffer> pooled = this.allocate((byte)50);
        boolean ok = false;
        try {
            ByteBuffer buffer = (ByteBuffer)pooled.getResource();
            buffer.flip();
            this.channel.getRemoteConnection().send(pooled);
            ok = true;
            this.closeSent = true;
        }
        finally {
            if (!ok) {
                pooled.free();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAcknowledge(Pooled<ByteBuffer> acked) {
        assert (Thread.holdsLock(this.inputStream));
        if (this.eofReceived) {
            return;
        }
        boolean badMsgSize = this.channel.getConnectionHandler().isFaultyMessageSize();
        int consumed = ((ByteBuffer)acked.getResource()).position();
        if (!badMsgSize) {
            consumed -= 8;
        }
        this.inboundWindow += consumed;
        Pooled<ByteBuffer> pooled = this.allocate((byte)49);
        boolean ok = false;
        try {
            ByteBuffer buffer = (ByteBuffer)pooled.getResource();
            buffer.putInt(consumed);
            buffer.flip();
            this.channel.getRemoteConnection().send(pooled);
            ok = true;
        }
        finally {
            if (!ok) {
                pooled.free();
            }
        }
    }

    Pooled<ByteBuffer> allocate(byte protoId) {
        Pooled<ByteBuffer> pooled = this.channel.allocate(protoId);
        ByteBuffer buffer = (ByteBuffer)pooled.getResource();
        buffer.putShort(this.messageId);
        return pooled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleIncoming(Pooled<ByteBuffer> pooledBuffer) {
        BufferPipeInputStream bufferPipeInputStream = this.inputStream;
        synchronized (bufferPipeInputStream) {
            boolean cancelled;
            ByteBuffer buffer = (ByteBuffer)pooledBuffer.getResource();
            int bufRemaining = buffer.remaining();
            if ((this.inboundWindow -= bufRemaining) < 0) {
                this.channel.getRemoteConnection().handleException(new IOException("Input overrun"));
            }
            buffer.position(buffer.position() - 1);
            byte flags = buffer.get();
            boolean eof = (flags & 1) != 0;
            boolean bl = cancelled = (flags & 4) != 0;
            if ((long)bufRemaining > this.remaining) {
                cancelled = true;
                this.doClose();
            }
            if (cancelled) {
                this.cancelled = true;
                this.inputStream.pushException((IOException)new MessageCancelledException());
            }
            if (this.streamClosed) {
                if (!eof && !this.closeSent) {
                    buffer.position(buffer.limit());
                    this.doAcknowledge(pooledBuffer);
                }
                pooledBuffer.free();
            } else if (!cancelled) {
                this.remaining -= (long)bufRemaining;
                this.inputStream.push(pooledBuffer);
            }
            if (eof) {
                this.eofReceived = true;
                if (!this.streamClosed) {
                    this.inputStream.pushEof();
                }
                this.channel.freeInboundMessage(this.messageId);
                this.doSendCloseMessage();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleDuplicate() {
        RemoteLogger.conn.duplicateMessageId(this.messageId, this.channel.getRemoteConnection().getChannel().getPeerAddress());
        BufferPipeInputStream bufferPipeInputStream = this.inputStream;
        synchronized (bufferPipeInputStream) {
            if (!this.streamClosed) {
                this.eofReceived = true;
                this.closeSent = true;
                this.cancelled = true;
                this.inputStream.pushException(RemoteLogger.conn.duplicateMessageIdException());
            }
        }
    }

    void dumpState(StringBuilder b) {
        b.append("            ").append(String.format("Inbound message ID %04x, window %d\n", this.messageId & 0xFFFF, this.inboundWindow));
        b.append("            ").append("* flags: ");
        if (this.cancelled) {
            b.append("cancelled ");
        }
        if (this.closeSent) {
            b.append("close-sent ");
        }
        if (this.streamClosed) {
            b.append("stream-closed ");
        }
        if (this.eofReceived) {
            b.append("eof-received ");
        }
        b.append('\n');
    }
}

