/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3;

final class ConnectionKey {
    private final String hostName;
    private final String protocol;
    private final int port;
    private final int hashCode;

    ConnectionKey(String hostName, String protocol, int port) {
        this.hostName = hostName;
        this.protocol = protocol;
        this.port = port;
        this.hashCode = (hostName.hashCode() * 17 + protocol.hashCode()) * 17 + port;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public int getPort() {
        return this.port;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        return obj instanceof ConnectionKey && this.equals((ConnectionKey)obj);
    }

    boolean equals(ConnectionKey other) {
        return other != null && this.hashCode == other.hashCode && this.hostName.equals(other.hostName) && this.protocol.equals(other.protocol);
    }

    public String toString() {
        return String.format("Connection key for \"%s:%s:%d\"", this.protocol, this.hostName, this.port);
    }
}

