/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3;

import java.io.IOException;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.jboss.remoting3.CloseHandler;
import org.jboss.remoting3.Connection;
import org.jboss.remoting3.EndpointImpl;
import org.xnio.FailedIoFuture;
import org.xnio.FutureResult;
import org.xnio.IoFuture;
import org.xnio.IoUtils;

class FutureConnection {
    private final EndpointImpl endpoint;
    private final URI uri;
    private final AtomicReference<FutureResult<Connection>> futureConnectionRef = new AtomicReference();
    private final boolean immediate;
    static final IoFuture.Notifier<Connection, FutureConnection> HANDLER = new IoFuture.HandlingNotifier<Connection, FutureConnection>(){

        public void handleCancelled(FutureConnection attachment) {
            attachment.futureConnectionRef.set(null);
            if (attachment.immediate) {
                attachment.reconnectAfterDelay();
            }
        }

        public void handleFailed(IOException exception, FutureConnection attachment) {
            attachment.futureConnectionRef.set(null);
            if (attachment.immediate) {
                attachment.reconnectAfterDelay();
            }
        }

        public void handleDone(Connection connection, final FutureConnection attachment) {
            connection.addCloseHandler(new CloseHandler<Connection>(){

                @Override
                public void handleClose(Connection closed, IOException exception) {
                    if (attachment.immediate) {
                        attachment.connect((FutureResult<Connection>)((FutureResult)attachment.futureConnectionRef.get()));
                    }
                }
            });
        }
    };

    FutureConnection(EndpointImpl endpoint, URI uri, boolean immediate) {
        this.endpoint = endpoint;
        this.uri = uri;
        this.immediate = immediate;
    }

    void reconnectAfterDelay() {
        this.endpoint.getXnioWorker().getIoThread().executeAfter(this::init, 30L, TimeUnit.SECONDS);
    }

    IoFuture<Connection> init() {
        return this.connect(null);
    }

    void splice(FutureResult<Connection> futureResult, IoFuture<Connection> realFuture) {
        futureResult.addCancelHandler(realFuture);
        realFuture.addNotifier(IoUtils.resultNotifier(), futureResult);
    }

    IoFuture<Connection> connect(FutureResult<Connection> orig) {
        FailedIoFuture realFuture;
        AtomicReference<FutureResult<Connection>> futureConnectionRef = this.futureConnectionRef;
        FutureResult<Connection> oldVal = futureConnectionRef.get();
        if (oldVal != orig) {
            return oldVal.getIoFuture();
        }
        FutureResult futureResult = new FutureResult();
        while (!futureConnectionRef.compareAndSet(oldVal, (FutureResult<Connection>)futureResult)) {
            oldVal = futureConnectionRef.get();
            if (oldVal == orig) continue;
            return oldVal.getIoFuture();
        }
        try {
            realFuture = this.endpoint.connect(this.uri);
        }
        catch (IOException e) {
            realFuture = new FailedIoFuture(e);
        }
        this.splice((FutureResult<Connection>)futureResult, (IoFuture<Connection>)realFuture);
        IoFuture ioFuture = futureResult.getIoFuture();
        ioFuture.addNotifier(HANDLER, (Object)this);
        return ioFuture;
    }

    public IoFuture<Connection> get() {
        return this.init();
    }

    boolean isConnected() {
        FutureResult<Connection> futureResult = this.futureConnectionRef.get();
        return futureResult != null && futureResult.getIoFuture().getStatus() == IoFuture.Status.DONE;
    }
}

