/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3.remote;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslClientFactory;
import javax.security.sasl.SaslException;
import org.jboss.remoting3.RemotingOptions;
import org.jboss.remoting3.Version;
import org.jboss.remoting3.remote.Protocol;
import org.jboss.remoting3.remote.ProtocolUtils;
import org.jboss.remoting3.remote.RemoteConnection;
import org.jboss.remoting3.remote.RemoteConnectionHandler;
import org.jboss.remoting3.remote.RemoteLogger;
import org.jboss.remoting3.remote.RemoteReadListener;
import org.jboss.remoting3.spi.ConnectionHandlerFactory;
import org.jboss.remoting3.spi.ConnectionProviderContext;
import org.wildfly.security.auth.client.AuthenticationConfiguration;
import org.wildfly.security.auth.client.AuthenticationContext;
import org.wildfly.security.auth.client.AuthenticationContextConfigurationClient;
import org.xnio.Buffers;
import org.xnio.ChannelListener;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Pooled;
import org.xnio.Sequence;
import org.xnio.channels.ConnectedMessageChannel;
import org.xnio.channels.SslChannel;
import org.xnio.channels.WrappedChannel;
import org.xnio.sasl.SaslUtils;
import org.xnio.sasl.SaslWrapper;

final class ClientConnectionOpenListener
implements ChannelListener<ConnectedMessageChannel> {
    private final URI uri;
    private final RemoteConnection connection;
    private final ConnectionProviderContext connectionProviderContext;
    private final AuthenticationContext authenticationContext;
    private final SaslClientFactory saslClientFactory;
    private final OptionMap optionMap;
    private final Map<String, String> failedMechs = new LinkedHashMap<String, String>();
    private final Set<String> allowedMechs;
    private final Set<String> disallowedMechs;
    static final AuthenticationContextConfigurationClient AUTH_CONFIGURATION_CLIENT = (AuthenticationContextConfigurationClient)AccessController.doPrivileged(AuthenticationContextConfigurationClient.ACTION);

    ClientConnectionOpenListener(URI uri, RemoteConnection connection, ConnectionProviderContext connectionProviderContext, AuthenticationContext authenticationContext, SaslClientFactory saslClientFactory, OptionMap optionMap) {
        this.uri = uri;
        this.connection = connection;
        this.connectionProviderContext = connectionProviderContext;
        this.authenticationContext = authenticationContext;
        this.saslClientFactory = saslClientFactory;
        this.optionMap = optionMap;
        Sequence allowedMechs = (Sequence)optionMap.get(Options.SASL_MECHANISMS);
        Sequence disallowedMechs = (Sequence)optionMap.get(Options.SASL_DISALLOWED_MECHANISMS);
        this.allowedMechs = allowedMechs == null ? null : new HashSet(allowedMechs);
        this.disallowedMechs = disallowedMechs == null ? Collections.emptySet() : new HashSet(disallowedMechs);
    }

    public void handleEvent(ConnectedMessageChannel channel) {
        this.connection.setReadListener(new Greeting(), true);
    }

    SaslException allMechanismsFailed() {
        StringBuilder b = new StringBuilder();
        b.append("Authentication failed: all available authentication mechanisms failed:");
        for (Map.Entry<String, String> entry : this.failedMechs.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            b.append("\n   ").append(key).append(": ").append(value);
        }
        return new SaslException(b.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendCapRequest(String remoteServerName) {
        RemoteLogger.client.trace("Client sending capabilities request");
        Pooled<ByteBuffer> pooledSendBuffer = this.connection.allocate();
        boolean ok = false;
        try {
            ByteBuffer sendBuffer = (ByteBuffer)pooledSendBuffer.getResource();
            sendBuffer.put((byte)1);
            ProtocolUtils.writeByte(sendBuffer, 0, 1);
            String localEndpointName = this.connectionProviderContext.getEndpoint().getName();
            if (localEndpointName != null) {
                ProtocolUtils.writeString(sendBuffer, (byte)3, localEndpointName);
            }
            ProtocolUtils.writeEmpty(sendBuffer, 4);
            ProtocolUtils.writeString(sendBuffer, (byte)5, Version.getVersionString());
            ProtocolUtils.writeInt(sendBuffer, 6, this.optionMap.get(RemotingOptions.MAX_INBOUND_CHANNELS, 40));
            ProtocolUtils.writeInt(sendBuffer, 7, this.optionMap.get(RemotingOptions.MAX_OUTBOUND_CHANNELS, 40));
            sendBuffer.flip();
            this.connection.setReadListener(new Capabilities(remoteServerName, this.uri), true);
            this.connection.send(pooledSendBuffer);
            ok = true;
            return;
        }
        finally {
            if (!ok) {
                pooledSendBuffer.free();
            }
        }
    }

    private void saslDispose(SaslClient saslClient) {
        if (saslClient != null) {
            try {
                saslClient.dispose();
            }
            catch (SaslException e) {
                RemoteLogger.client.trace("Failure disposing of SaslClient", e);
            }
        }
    }

    final class Authentication
    implements ChannelListener<ConnectedMessageChannel> {
        private final SaslClient saslClient;
        private final String serverName;
        private final String remoteEndpointName;
        private final int behavior;
        private final int maxInboundChannels;
        private final int maxOutboundChannels;

        Authentication(SaslClient saslClient, String serverName, String endpointName, int behavior, int maxInboundChannels, int maxOutboundChannels) {
            this.saslClient = saslClient;
            this.serverName = serverName;
            this.behavior = behavior;
            this.remoteEndpointName = endpointName;
            this.maxInboundChannels = maxInboundChannels;
            this.maxOutboundChannels = maxOutboundChannels;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleEvent(ConnectedMessageChannel channel) {
            Pooled<ByteBuffer> pooledBuffer = ClientConnectionOpenListener.this.connection.allocate();
            boolean free = true;
            try {
                int res;
                ByteBuffer buffer = (ByteBuffer)pooledBuffer.getResource();
                try {
                    res = channel.receive(buffer);
                }
                catch (IOException e) {
                    ClientConnectionOpenListener.this.connection.handleException(e);
                    ClientConnectionOpenListener.this.saslDispose(this.saslClient);
                    if (free) {
                        pooledBuffer.free();
                    }
                    return;
                }
                if (res == 0) {
                    return;
                }
                if (res == -1) {
                    ClientConnectionOpenListener.this.connection.handleException(RemoteLogger.client.abruptClose(ClientConnectionOpenListener.this.connection));
                    ClientConnectionOpenListener.this.saslDispose(this.saslClient);
                    return;
                }
                buffer.flip();
                byte msgType = buffer.get();
                switch (msgType) {
                    case -16: {
                        RemoteLogger.client.trace("Client received connection alive");
                        ClientConnectionOpenListener.this.connection.sendAliveResponse();
                        return;
                    }
                    case -15: {
                        RemoteLogger.client.trace("Client received connection alive ack");
                        return;
                    }
                    case -1: {
                        RemoteLogger.client.trace("Client received connection close request");
                        ClientConnectionOpenListener.this.connection.handlePreAuthCloseRequest();
                        ClientConnectionOpenListener.this.saslDispose(this.saslClient);
                        return;
                    }
                    case 3: {
                        RemoteLogger.client.trace("Client received authentication challenge");
                        channel.suspendReads();
                        ClientConnectionOpenListener.this.connection.getExecutor().execute(() -> {
                            try {
                                byte[] response;
                                boolean clientComplete = this.saslClient.isComplete();
                                if (clientComplete) {
                                    ClientConnectionOpenListener.this.connection.handleException(new SaslException("Received extra auth message after completion"));
                                    return;
                                }
                                byte[] challenge = Buffers.take((ByteBuffer)buffer, (int)buffer.remaining());
                                try {
                                    response = this.saslClient.evaluateChallenge(challenge);
                                }
                                catch (Throwable e) {
                                    String mechanismName = this.saslClient.getMechanismName();
                                    RemoteLogger.client.debugf("Client authentication failed for mechanism %s: %s", mechanismName, e);
                                    ClientConnectionOpenListener.this.failedMechs.put(mechanismName, e.toString());
                                    ClientConnectionOpenListener.this.saslDispose(this.saslClient);
                                    ClientConnectionOpenListener.this.sendCapRequest(this.serverName);
                                    pooledBuffer.free();
                                    return;
                                }
                                RemoteLogger.client.trace("Client sending authentication response");
                                Pooled<ByteBuffer> pooled = ClientConnectionOpenListener.this.connection.allocate();
                                boolean ok = false;
                                try {
                                    ByteBuffer sendBuffer = (ByteBuffer)pooled.getResource();
                                    sendBuffer.put((byte)4);
                                    sendBuffer.put(response);
                                    sendBuffer.flip();
                                    ClientConnectionOpenListener.this.connection.send(pooled);
                                    ok = true;
                                    channel.resumeReads();
                                }
                                finally {
                                    if (!ok) {
                                        pooled.free();
                                    }
                                }
                                return;
                            }
                            finally {
                                pooledBuffer.free();
                            }
                        });
                        free = false;
                        return;
                    }
                    case 5: {
                        RemoteLogger.client.trace("Client received authentication complete");
                        channel.suspendReads();
                        ClientConnectionOpenListener.this.connection.getExecutor().execute(() -> {
                            try {
                                Object qop;
                                block11: {
                                    boolean clientComplete = this.saslClient.isComplete();
                                    byte[] challenge = Buffers.take((ByteBuffer)buffer, (int)buffer.remaining());
                                    if (!clientComplete) {
                                        try {
                                            byte[] response = this.saslClient.evaluateChallenge(challenge);
                                            if (response != null && response.length > 0) {
                                                ClientConnectionOpenListener.this.connection.handleException(new SaslException("Received extra auth message after completion"));
                                                ClientConnectionOpenListener.this.saslDispose(this.saslClient);
                                                return;
                                            }
                                            if (this.saslClient.isComplete()) break block11;
                                            ClientConnectionOpenListener.this.connection.handleException(new SaslException("Client not complete after processing auth complete message"));
                                        }
                                        catch (Throwable e) {
                                            String mechanismName = this.saslClient.getMechanismName();
                                            RemoteLogger.client.debugf("Client authentication failed for mechanism %s: %s", mechanismName, e);
                                            ClientConnectionOpenListener.this.failedMechs.put(mechanismName, e.toString());
                                            ClientConnectionOpenListener.this.saslDispose(this.saslClient);
                                            ClientConnectionOpenListener.this.sendCapRequest(this.serverName);
                                            return;
                                        }
                                        ClientConnectionOpenListener.this.saslDispose(this.saslClient);
                                        return;
                                    }
                                }
                                if ("auth-int".equals(qop = this.saslClient.getNegotiatedProperty("javax.security.sasl.qop")) || "auth-conf".equals(qop)) {
                                    ClientConnectionOpenListener.this.connection.setSaslWrapper(SaslWrapper.create((SaslClient)this.saslClient));
                                }
                                ConnectionHandlerFactory connectionHandlerFactory = connectionContext -> {
                                    RemoteConnectionHandler connectionHandler = new RemoteConnectionHandler(connectionContext, ClientConnectionOpenListener.this.connection, this.maxInboundChannels, this.maxOutboundChannels, this.remoteEndpointName, this.behavior);
                                    ClientConnectionOpenListener.this.connection.setReadListener(new RemoteReadListener(connectionHandler, ClientConnectionOpenListener.this.connection), false);
                                    ClientConnectionOpenListener.this.connection.getRemoteConnectionProvider().addConnectionHandler(connectionHandler);
                                    return connectionHandler;
                                };
                                ClientConnectionOpenListener.this.connection.getResult().setResult((Object)connectionHandlerFactory);
                                channel.resumeReads();
                                return;
                            }
                            finally {
                                pooledBuffer.free();
                            }
                        });
                        free = false;
                        return;
                    }
                    case 6: {
                        String mechanismName = this.saslClient.getMechanismName();
                        RemoteLogger.client.debugf("Client received authentication rejected for mechanism %s", mechanismName);
                        ClientConnectionOpenListener.this.failedMechs.put(mechanismName, "Server rejected authentication");
                        ClientConnectionOpenListener.this.saslDispose(this.saslClient);
                        ClientConnectionOpenListener.this.sendCapRequest(this.serverName);
                        return;
                    }
                }
                RemoteLogger.client.unknownProtocolId(msgType);
                ClientConnectionOpenListener.this.connection.handleException(RemoteLogger.client.invalidMessage(ClientConnectionOpenListener.this.connection));
                ClientConnectionOpenListener.this.saslDispose(this.saslClient);
                return;
            }
            finally {
                if (free) {
                    pooledBuffer.free();
                }
            }
        }
    }

    final class StartTls
    implements ChannelListener<ConnectedMessageChannel> {
        private final String remoteServerName;

        StartTls(String remoteServerName) {
            this.remoteServerName = remoteServerName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleEvent(ConnectedMessageChannel channel) {
            Pooled<ByteBuffer> pooledReceiveBuffer = ClientConnectionOpenListener.this.connection.allocate();
            try {
                int res;
                ByteBuffer receiveBuffer = (ByteBuffer)pooledReceiveBuffer.getResource();
                try {
                    res = channel.receive(receiveBuffer);
                }
                catch (IOException e) {
                    ClientConnectionOpenListener.this.connection.handleException(e);
                    pooledReceiveBuffer.free();
                    return;
                }
                if (res == -1) {
                    ClientConnectionOpenListener.this.connection.handleException(RemoteLogger.client.abruptClose(ClientConnectionOpenListener.this.connection));
                    return;
                }
                if (res == 0) {
                    return;
                }
                RemoteLogger.client.tracef("Received %s", receiveBuffer);
                receiveBuffer.flip();
                byte msgType = receiveBuffer.get();
                switch (msgType) {
                    case -16: {
                        RemoteLogger.client.trace("Client received connection alive");
                        ClientConnectionOpenListener.this.connection.sendAliveResponse();
                        return;
                    }
                    case -15: {
                        RemoteLogger.client.trace("Client received connection alive ack");
                        return;
                    }
                    case -1: {
                        RemoteLogger.client.trace("Client received connection close request");
                        ClientConnectionOpenListener.this.connection.handlePreAuthCloseRequest();
                        return;
                    }
                    case 7: {
                        RemoteLogger.client.trace("Client received STARTTLS response");
                        Object c = channel;
                        while (true) {
                            if (c instanceof SslChannel) {
                                ClientConnectionOpenListener.this.connection.send(RemoteConnection.STARTTLS_SENTINEL);
                                ClientConnectionOpenListener.this.sendCapRequest(this.remoteServerName);
                                return;
                            }
                            if (!(c instanceof WrappedChannel)) break;
                            c = ((WrappedChannel)c).getChannel();
                        }
                        ClientConnectionOpenListener.this.connection.handleException(new IOException("Client starting STARTTLS but channel doesn't support SSL"));
                        return;
                    }
                }
                RemoteLogger.client.unknownProtocolId(msgType);
                ClientConnectionOpenListener.this.connection.handleException(RemoteLogger.client.invalidMessage(ClientConnectionOpenListener.this.connection));
                return;
            }
            catch (BufferOverflowException | BufferUnderflowException e) {
                ClientConnectionOpenListener.this.connection.handleException(RemoteLogger.client.invalidMessage(ClientConnectionOpenListener.this.connection));
                return;
            }
            finally {
                pooledReceiveBuffer.free();
            }
        }
    }

    final class Capabilities
    implements ChannelListener<ConnectedMessageChannel> {
        private final String remoteServerName;
        private final URI uri;

        Capabilities(String remoteServerName, URI uri) {
            this.remoteServerName = remoteServerName;
            this.uri = uri;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void handleEvent(ConnectedMessageChannel channel) {
            Pooled<ByteBuffer> pooledReceiveBuffer = ClientConnectionOpenListener.this.connection.allocate();
            try {
                int res;
                ByteBuffer receiveBuffer = (ByteBuffer)pooledReceiveBuffer.getResource();
                try {
                    res = channel.receive(receiveBuffer);
                }
                catch (IOException e) {
                    ClientConnectionOpenListener.this.connection.handleException(e);
                    pooledReceiveBuffer.free();
                    return;
                }
                if (res == -1) {
                    ClientConnectionOpenListener.this.connection.handleException(RemoteLogger.client.abruptClose(ClientConnectionOpenListener.this.connection));
                    return;
                }
                if (res == 0) {
                    return;
                }
                receiveBuffer.flip();
                boolean starttls = false;
                LinkedHashSet<String> serverSaslMechs = new LinkedHashSet<String>();
                byte msgType = receiveBuffer.get();
                switch (msgType) {
                    case -16: {
                        RemoteLogger.client.trace("Client received connection alive");
                        ClientConnectionOpenListener.this.connection.sendAliveResponse();
                        return;
                    }
                    case -15: {
                        RemoteLogger.client.trace("Client received connection alive ack");
                        return;
                    }
                    case -1: {
                        RemoteLogger.client.trace("Client received connection close request");
                        ClientConnectionOpenListener.this.connection.handlePreAuthCloseRequest();
                        return;
                    }
                    case 1: {
                        SaslClient saslClient;
                        RemoteLogger.client.trace("Client received capabilities response");
                        String remoteEndpointName = null;
                        int version = 1;
                        int behavior = 2;
                        boolean useDefaultChannels = true;
                        int channelsIn = 40;
                        int channelsOut = 40;
                        block39: while (receiveBuffer.hasRemaining()) {
                            byte type = receiveBuffer.get();
                            int len = receiveBuffer.get() & 0xFF;
                            ByteBuffer data = Buffers.slice((ByteBuffer)receiveBuffer, (int)len);
                            switch (type) {
                                case 0: {
                                    version = data.get() & 0xFF;
                                    RemoteLogger.client.tracef("Client received capability: version %d", version & 0xFF);
                                    continue block39;
                                }
                                case 1: {
                                    String mechName = Buffers.getModifiedUtf8((ByteBuffer)data);
                                    RemoteLogger.client.tracef("Client received capability: SASL mechanism %s", mechName);
                                    if (ClientConnectionOpenListener.this.failedMechs.containsKey(mechName) || ClientConnectionOpenListener.this.disallowedMechs.contains(mechName) || ClientConnectionOpenListener.this.allowedMechs != null && !ClientConnectionOpenListener.this.allowedMechs.contains(mechName)) continue block39;
                                    RemoteLogger.client.tracef("SASL mechanism %s added to allowed set", mechName);
                                    serverSaslMechs.add(mechName);
                                    continue block39;
                                }
                                case 2: {
                                    RemoteLogger.client.trace("Client received capability: STARTTLS");
                                    starttls = true;
                                    continue block39;
                                }
                                case 3: {
                                    remoteEndpointName = Buffers.getModifiedUtf8((ByteBuffer)data);
                                    RemoteLogger.client.tracef("Client received capability: remote endpoint name \"%s\"", remoteEndpointName);
                                    continue block39;
                                }
                                case 4: {
                                    behavior |= 1;
                                    behavior &= 0xFFFFFFFD;
                                    RemoteLogger.client.tracef("Client received capability: message close protocol supported", new Object[0]);
                                    continue block39;
                                }
                                case 5: {
                                    behavior &= 0xFFFFFFFD;
                                    String remoteVersionString = Buffers.getModifiedUtf8((ByteBuffer)data);
                                    RemoteLogger.client.tracef("Client received capability: remote version is \"%s\"", remoteVersionString);
                                    continue block39;
                                }
                                case 6: {
                                    useDefaultChannels = false;
                                    channelsOut = ProtocolUtils.readIntData(data, len);
                                    RemoteLogger.client.tracef("Client received capability: remote channels in is \"%d\"", channelsOut);
                                    continue block39;
                                }
                                case 7: {
                                    useDefaultChannels = false;
                                    channelsIn = ProtocolUtils.readIntData(data, len);
                                    RemoteLogger.client.tracef("Client received capability: remote channels out is \"%d\"", channelsIn);
                                    continue block39;
                                }
                            }
                            RemoteLogger.client.tracef("Client received unknown capability %02x", type & 0xFF);
                        }
                        if (useDefaultChannels) {
                            channelsIn = 40;
                            channelsOut = 40;
                        }
                        if (starttls && ClientConnectionOpenListener.this.optionMap.get(Options.SSL_STARTTLS, true)) {
                            Pooled<ByteBuffer> pooledSendBuffer = ClientConnectionOpenListener.this.connection.allocate();
                            boolean ok = false;
                            try {
                                ByteBuffer sendBuffer = (ByteBuffer)pooledSendBuffer.getResource();
                                sendBuffer.put((byte)7);
                                sendBuffer.flip();
                                ClientConnectionOpenListener.this.connection.setReadListener(new StartTls(this.remoteServerName), true);
                                ClientConnectionOpenListener.this.connection.send(pooledSendBuffer);
                                ok = true;
                                return;
                            }
                            finally {
                                if (!ok) {
                                    pooledSendBuffer.free();
                                }
                            }
                        }
                        if (serverSaslMechs.isEmpty()) break;
                        AuthenticationContextConfigurationClient configurationClient = AUTH_CONFIGURATION_CLIENT;
                        AuthenticationConfiguration configuration = configurationClient.getAuthenticationConfiguration(this.uri, ClientConnectionOpenListener.this.authenticationContext);
                        try {
                            saslClient = configurationClient.createSaslClient(this.uri, configuration, ClientConnectionOpenListener.this.saslClientFactory, serverSaslMechs);
                        }
                        catch (SaslException e) {
                            ClientConnectionOpenListener.this.connection.handleException(e);
                            pooledReceiveBuffer.free();
                            return;
                        }
                        if (saslClient == null) {
                            ClientConnectionOpenListener.this.connection.handleException(ClientConnectionOpenListener.this.allMechanismsFailed());
                            return;
                        }
                        String mechanismName = saslClient.getMechanismName();
                        RemoteLogger.client.tracef("Client initiating authentication using mechanism %s", mechanismName);
                        ClientConnectionOpenListener.this.connection.getChannel().suspendReads();
                        int negotiatedVersion = version;
                        SaslClient usedSaslClient = saslClient;
                        Authentication authentication = new Authentication(usedSaslClient, this.remoteServerName, remoteEndpointName, behavior, channelsIn, channelsOut);
                        ClientConnectionOpenListener.this.connection.getExecutor().execute(() -> {
                            byte[] response;
                            try {
                                response = usedSaslClient.hasInitialResponse() ? usedSaslClient.evaluateChallenge(SaslUtils.EMPTY_BYTES) : null;
                            }
                            catch (SaslException e) {
                                RemoteLogger.client.tracef("Client authentication failed: %s", e);
                                ClientConnectionOpenListener.this.saslDispose(usedSaslClient);
                                ClientConnectionOpenListener.this.failedMechs.put(mechanismName, e.toString());
                                ClientConnectionOpenListener.this.sendCapRequest(this.remoteServerName);
                                return;
                            }
                            Pooled<ByteBuffer> pooledSendBuffer = ClientConnectionOpenListener.this.connection.allocate();
                            boolean ok = false;
                            try {
                                ByteBuffer sendBuffer = (ByteBuffer)pooledSendBuffer.getResource();
                                sendBuffer.put((byte)2);
                                if (negotiatedVersion < 1) {
                                    sendBuffer.put(mechanismName.getBytes(Protocol.UTF_8));
                                } else {
                                    ProtocolUtils.writeString(sendBuffer, mechanismName);
                                    if (response != null) {
                                        sendBuffer.put(response);
                                    }
                                }
                                sendBuffer.flip();
                                ClientConnectionOpenListener.this.connection.send(pooledSendBuffer);
                                ok = true;
                                ClientConnectionOpenListener.this.connection.setReadListener(authentication, true);
                                return;
                            }
                            finally {
                                if (!ok) {
                                    pooledSendBuffer.free();
                                }
                            }
                        });
                        return;
                    }
                    default: {
                        RemoteLogger.client.unknownProtocolId(msgType);
                        ClientConnectionOpenListener.this.connection.handleException(RemoteLogger.client.invalidMessage(ClientConnectionOpenListener.this.connection));
                        return;
                    }
                }
            }
            catch (BufferOverflowException | BufferUnderflowException e) {
                ClientConnectionOpenListener.this.connection.handleException(RemoteLogger.client.invalidMessage(ClientConnectionOpenListener.this.connection));
                return;
            }
            if (ClientConnectionOpenListener.this.failedMechs.isEmpty()) {
                ClientConnectionOpenListener.this.connection.handleException(new SaslException("Authentication failed: the server presented no authentication mechanisms"));
                return;
            }
            ClientConnectionOpenListener.this.connection.handleException(ClientConnectionOpenListener.this.allMechanismsFailed());
            return;
            finally {
                pooledReceiveBuffer.free();
            }
        }
    }

    final class Greeting
    implements ChannelListener<ConnectedMessageChannel> {
        Greeting() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleEvent(ConnectedMessageChannel channel) {
            Pooled<ByteBuffer> pooledReceiveBuffer = ClientConnectionOpenListener.this.connection.allocate();
            try {
                int res;
                ByteBuffer receiveBuffer = (ByteBuffer)pooledReceiveBuffer.getResource();
                try {
                    res = channel.receive(receiveBuffer);
                }
                catch (IOException e) {
                    ClientConnectionOpenListener.this.connection.handleException(e);
                    pooledReceiveBuffer.free();
                    return;
                }
                if (res == -1) {
                    ClientConnectionOpenListener.this.connection.handleException(RemoteLogger.client.abruptClose(ClientConnectionOpenListener.this.connection));
                    return;
                }
                if (res == 0) {
                    return;
                }
                RemoteLogger.client.tracef("Received %s", receiveBuffer);
                receiveBuffer.flip();
                String remoteServerName = null;
                byte msgType = receiveBuffer.get();
                switch (msgType) {
                    case -16: {
                        RemoteLogger.client.trace("Client received connection alive");
                        ClientConnectionOpenListener.this.connection.sendAliveResponse();
                        return;
                    }
                    case -15: {
                        RemoteLogger.client.trace("Client received connection alive ack");
                        return;
                    }
                    case -1: {
                        RemoteLogger.client.trace("Client received connection close request");
                        ClientConnectionOpenListener.this.connection.handlePreAuthCloseRequest();
                        return;
                    }
                    case 0: {
                        RemoteLogger.client.trace("Client received greeting");
                        block23: while (receiveBuffer.hasRemaining()) {
                            byte type = receiveBuffer.get();
                            int len = receiveBuffer.get() & 0xFF;
                            ByteBuffer data = Buffers.slice((ByteBuffer)receiveBuffer, (int)len);
                            switch (type) {
                                case 0: {
                                    remoteServerName = Buffers.getModifiedUtf8((ByteBuffer)data);
                                    RemoteLogger.client.tracef("Client received server name: %s", remoteServerName);
                                    continue block23;
                                }
                            }
                            RemoteLogger.client.tracef("Client received unknown greeting message %02x", type & 0xFF);
                        }
                        if (remoteServerName == null) {
                            remoteServerName = ((InetSocketAddress)channel.getPeerAddress(InetSocketAddress.class)).getHostName();
                        }
                        ClientConnectionOpenListener.this.sendCapRequest(remoteServerName);
                        return;
                    }
                }
                RemoteLogger.client.unknownProtocolId(msgType);
                ClientConnectionOpenListener.this.connection.handleException(RemoteLogger.client.invalidMessage(ClientConnectionOpenListener.this.connection));
                return;
            }
            catch (BufferOverflowException | BufferUnderflowException e) {
                ClientConnectionOpenListener.this.connection.handleException(RemoteLogger.client.invalidMessage(ClientConnectionOpenListener.this.connection));
                return;
            }
            finally {
                pooledReceiveBuffer.free();
            }
        }
    }
}

