/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3.util;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.remoting3.AbstractDelegatingMessageOutputStream;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.MessageOutputStream;

public final class MessageTracker {
    private final Channel channel;
    private final int limit;
    private final AtomicInteger counter;

    public MessageTracker(Channel channel, int limit) {
        this.channel = channel;
        this.limit = limit;
        this.counter = new AtomicInteger(limit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageOutputStream openMessage() throws IOException, InterruptedException {
        int oldVal;
        do {
            if ((oldVal = this.counter.get()) != 0) continue;
            AtomicInteger atomicInteger = this.counter;
            synchronized (atomicInteger) {
                oldVal = this.counter.get();
                while (oldVal == 0) {
                    this.counter.wait();
                }
            }
        } while (!this.counter.compareAndSet(oldVal, oldVal - 1));
        return this.getMessageInstance(this.channel.writeMessage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageOutputStream openMessageUninterruptibly() throws IOException {
        boolean intr = false;
        try {
            Object object;
            int oldVal;
            do {
                if ((oldVal = this.counter.get()) != 0) continue;
                object = this.counter;
                synchronized (object) {
                    oldVal = this.counter.get();
                    while (oldVal == 0) {
                        try {
                            this.counter.wait();
                        }
                        catch (InterruptedException e) {
                            intr = true;
                        }
                    }
                }
            } while (!this.counter.compareAndSet(oldVal, oldVal - 1));
            object = this.getMessageInstance(this.channel.writeMessage());
            return object;
        }
        finally {
            if (intr) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private AbstractDelegatingMessageOutputStream getMessageInstance(MessageOutputStream delegate) {
        return new AbstractDelegatingMessageOutputStream(delegate){
            private final AtomicBoolean done;
            {
                this.done = new AtomicBoolean();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void close() throws IOException {
                if (this.done.compareAndSet(false, true)) {
                    try {
                        super.close();
                    }
                    finally {
                        int oldVal;
                        do {
                            oldVal = MessageTracker.this.counter.get();
                        } while (!MessageTracker.this.counter.compareAndSet(oldVal, oldVal + 1));
                        if (oldVal == MessageTracker.this.limit - 1) {
                            AtomicInteger atomicInteger = MessageTracker.this.counter;
                            synchronized (atomicInteger) {
                                MessageTracker.this.counter.notify();
                            }
                        }
                    }
                }
            }
        };
    }
}

