/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3;

import java.net.URI;
import java.util.Objects;
import javax.net.ssl.SSLContext;
import org.wildfly.security.auth.client.AuthenticationConfiguration;

final class ConnectionKey {
    private final URI destination;
    private final AuthenticationConfiguration connectConfiguration;
    private final SSLContext sslContext;
    private final int hashCode;

    ConnectionKey(URI destination, AuthenticationConfiguration connectConfiguration, SSLContext sslContext) {
        this.destination = destination;
        this.connectConfiguration = connectConfiguration;
        this.sslContext = sslContext;
        this.hashCode = Objects.hash(destination, connectConfiguration, sslContext);
    }

    URI getDestination() {
        return this.destination;
    }

    AuthenticationConfiguration getConnectConfiguration() {
        return this.connectConfiguration;
    }

    SSLContext getSslContext() {
        return this.sslContext;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        return obj instanceof ConnectionKey && this.equals((ConnectionKey)obj);
    }

    boolean equals(ConnectionKey other) {
        return this == other || other != null && this.hashCode == other.hashCode && this.destination.equals(other.destination) && this.connectConfiguration.equals(other.connectConfiguration) && Objects.equals(this.sslContext, other.sslContext);
    }

    public String toString() {
        return String.format("Connection key for \"%s\" connectConfig=%s ssl=%s", this.destination, this.connectConfiguration, this.sslContext);
    }
}

