/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3;

import java.io.IOException;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.List;
import org.jboss.remoting3.ConnectionProviderFactoryBuilder;
import org.jboss.remoting3.Endpoint;
import org.jboss.remoting3.EndpointImpl;
import org.jboss.remoting3.security.RemotingPermission;
import org.xnio.Xnio;
import org.xnio.XnioWorker;

public final class EndpointBuilder {
    private String endpointName;
    private XnioWorker xnioWorker;
    private List<ConnectionProviderFactoryBuilder> connectionProviderFactoryBuilders;
    private XnioWorker.Builder workerBuilder;

    EndpointBuilder() {
    }

    public EndpointBuilder setEndpointName(String endpointName) {
        this.endpointName = endpointName;
        return this;
    }

    public EndpointBuilder setXnioWorker(XnioWorker xnioWorker) {
        this.workerBuilder = null;
        this.xnioWorker = xnioWorker;
        return this;
    }

    public XnioWorker.Builder buildXnioWorker(Xnio xnio) {
        this.xnioWorker = null;
        this.workerBuilder = xnio.createWorkerBuilder();
        return this.workerBuilder;
    }

    public ConnectionProviderFactoryBuilder addProvider(String scheme) {
        ConnectionProviderFactoryBuilder builder = new ConnectionProviderFactoryBuilder(scheme);
        if (this.connectionProviderFactoryBuilders == null) {
            this.connectionProviderFactoryBuilders = new ArrayList<ConnectionProviderFactoryBuilder>();
            this.connectionProviderFactoryBuilders.add(builder);
        }
        return builder;
    }

    String getEndpointName() {
        return this.endpointName;
    }

    XnioWorker getXnioWorker() {
        return this.xnioWorker;
    }

    XnioWorker.Builder getWorkerBuilder() {
        return this.workerBuilder;
    }

    List<ConnectionProviderFactoryBuilder> getConnectionProviderFactoryBuilders() {
        return this.connectionProviderFactoryBuilders;
    }

    public Endpoint build() throws IOException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)((Object)RemotingPermission.CREATE_ENDPOINT));
        }
        try {
            return AccessController.doPrivileged(() -> EndpointImpl.construct(this));
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getException();
        }
    }
}

