/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.resteasy1119;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import org.jboss.resteasy.annotations.providers.multipart.MultipartForm;
import org.jboss.resteasy.annotations.providers.multipart.PartType;
import org.jboss.resteasy.annotations.providers.multipart.XopWithMultipartRelated;
import org.jboss.resteasy.plugins.providers.multipart.InputPart;
import org.jboss.resteasy.plugins.providers.multipart.MultipartFormDataInput;
import org.jboss.resteasy.plugins.providers.multipart.MultipartFormDataOutput;
import org.jboss.resteasy.plugins.providers.multipart.MultipartInput;
import org.jboss.resteasy.plugins.providers.multipart.MultipartOutput;
import org.jboss.resteasy.plugins.providers.multipart.MultipartRelatedInput;
import org.jboss.resteasy.plugins.providers.multipart.MultipartRelatedOutput;
import org.jboss.resteasy.resteasy1119.Customer;
import org.jboss.resteasy.resteasy1119.CustomerForm;
import org.jboss.resteasy.resteasy1119.Name;
import org.jboss.resteasy.resteasy1119.Xop;

@Path(value="")
public class TestResource {
    @GET
    @Produces(value={"multipart/mixed"})
    @Path(value="get/mixed")
    public MultipartOutput getMixed() {
        System.out.println("entering getMixed()");
        MultipartOutput output = new MultipartOutput();
        output.addPart((Object)new Customer("Bill"), MediaType.APPLICATION_XML_TYPE);
        output.addPart((Object)"Bob", MediaType.TEXT_PLAIN_TYPE);
        return output;
    }

    @GET
    @Produces(value={"multipart/form-data"})
    @MultipartForm
    @Path(value="get/form")
    public MultipartFormDataOutput getForm() {
        System.out.println("entering getForm()");
        MultipartFormDataOutput output = new MultipartFormDataOutput();
        output.addFormData("bill", (Object)new Customer("Bill"), MediaType.APPLICATION_XML_TYPE, "tmp1");
        output.addFormData("bob", (Object)"Bob", MediaType.TEXT_PLAIN_TYPE);
        return output;
    }

    @GET
    @Produces(value={"multipart/mixed"})
    @PartType(value="application/xml")
    @Path(value="get/list")
    public List<Customer> getList() {
        System.out.println("entering getList()");
        ArrayList<Customer> list = new ArrayList<Customer>();
        list.add(new Customer("Bill"));
        list.add(new Customer("Bob"));
        return list;
    }

    @GET
    @Produces(value={"multipart/form-data"})
    @PartType(value="application/xml")
    @Path(value="get/map")
    public Map<String, Customer> getMap() {
        System.out.println("entering getMap()");
        HashMap<String, Customer> map = new HashMap<String, Customer>();
        map.put("bill", new Customer("Bill"));
        map.put("bob", new Customer("Bob"));
        return map;
    }

    @GET
    @Produces(value={"multipart/related"})
    @Path(value="get/related")
    public MultipartRelatedOutput getRelated() {
        System.out.println("entering getRelated()");
        MultipartRelatedOutput output = new MultipartRelatedOutput();
        output.setStartInfo("text/html");
        output.addPart((Object)"Bill", new MediaType("image", "png"), "bill", "binary");
        output.addPart((Object)"Bob", new MediaType("image", "png"), "bob", "binary");
        return output;
    }

    @GET
    @Path(value="get/multipartform")
    @Produces(value={"multipart/form-data"})
    @MultipartForm
    public CustomerForm getMultipartForm() {
        CustomerForm form = new CustomerForm();
        form.setCustomer(new Customer("Bill"));
        return form;
    }

    @GET
    @Path(value="get/xop")
    @Produces(value={"multipart/related"})
    @XopWithMultipartRelated
    public Xop getXop() {
        return new Xop("goodbye world".getBytes());
    }

    @POST
    @Consumes(value={"multipart/mixed"})
    @Produces(value={"application/xml"})
    @Path(value="post/mixed")
    public List<Name> postMixed(MultipartInput input) throws IOException {
        System.out.println("entering getMixed()");
        List list = input.getParts();
        ArrayList<Name> names = new ArrayList<Name>();
        for (InputPart inputPart : list) {
            if (MediaType.APPLICATION_XML_TYPE.equals((Object)inputPart.getMediaType())) {
                names.add(new Name(((Customer)inputPart.getBody(Customer.class, null)).getName()));
                continue;
            }
            names.add(new Name((String)inputPart.getBody(String.class, null)));
        }
        return names;
    }

    @POST
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/xml"})
    @Path(value="post/form")
    public List<Name> postForm(MultipartFormDataInput input) throws IOException {
        System.out.println("entering postForm()");
        Map map = input.getFormDataMap();
        ArrayList<Name> names = new ArrayList<Name>();
        for (String key : map.keySet()) {
            InputPart inputPart = (InputPart)((List)map.get(key)).iterator().next();
            if (MediaType.APPLICATION_XML_TYPE.equals((Object)inputPart.getMediaType())) {
                names.add(new Name(((Customer)inputPart.getBody(Customer.class, null)).getName()));
                continue;
            }
            names.add(new Name((String)inputPart.getBody(String.class, null)));
        }
        return names;
    }

    @POST
    @Consumes(value={"multipart/mixed"})
    @Produces(value={"application/xml"})
    @Path(value="post/list")
    public List<Name> postList(List<Customer> customers) throws IOException {
        System.out.println("entering postList()");
        ArrayList<Name> names = new ArrayList<Name>();
        for (Customer customer : customers) {
            names.add(new Name(customer.getName()));
        }
        return names;
    }

    @POST
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/xml"})
    @Path(value="post/map")
    public List<Name> postMap(Map<String, Customer> customers) throws IOException {
        System.out.println("entering postMap()");
        ArrayList<Name> names = new ArrayList<Name>();
        for (String key : customers.keySet()) {
            Customer customer = customers.get(key);
            names.add(new Name(key + ":" + customer.getName()));
        }
        return names;
    }

    @POST
    @Consumes(value={"multipart/related"})
    @Produces(value={"application/xml"})
    @Path(value="post/related")
    public List<Name> postRelated(MultipartRelatedInput customers) throws IOException {
        System.out.println("entering postMap()");
        ArrayList<Name> names = new ArrayList<Name>();
        for (InputPart part : customers.getParts()) {
            String name = (String)part.getBody(String.class, null);
            names.add(new Name(name));
        }
        return names;
    }

    @POST
    @Consumes(value={"multipart/form-data"})
    @Path(value="post/multipartform")
    public String postMultipartForm(@MultipartForm CustomerForm form) throws IOException {
        System.out.println("entering postMultipartForm()");
        return form.getCustomer().getName();
    }

    @POST
    @Path(value="post/xop")
    @Consumes(value={"multipart/related"})
    public String postXop(@XopWithMultipartRelated Xop xop) {
        return new String(xop.getBytes());
    }
}

