/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.example.pubsub;

import java.net.URI;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.resteasy.example.pubsub.Subscriber;

@Path(value="/")
public class SubscriptionResource {
    protected ConcurrentHashMap<String, Subscriber> subscribers = new ConcurrentHashMap();
    protected Executor executor = Executors.newSingleThreadExecutor();

    @POST
    @Path(value="subscribers")
    public Response create(@Context UriInfo uriInfo, @FormParam(value="name") String name) {
        if (name == null) {
            throw new BadRequestException();
        }
        Subscriber subscriber = new Subscriber(10);
        this.subscribers.putIfAbsent(name, subscriber);
        return Response.created((URI)uriInfo.getRequestUriBuilder().path(name).build(new Object[0])).build();
    }

    @POST
    @Path(value="subscription")
    public void post(@Context HttpHeaders headers, byte[] content) {
        MediaType type = headers.getMediaType();
        this.executor.execute((Runnable)new /* Unavailable Anonymous Inner Class!! */);
    }

    @GET
    @Path(value="subscribers/{name}")
    public void longPoll(@PathParam(value="name") String name, @Suspended AsyncResponse response) {
        Subscriber subscriber = (Subscriber)this.subscribers.get(name);
        if (subscriber == null) {
            throw new NotFoundException();
        }
        this.executor.execute((Runnable)new /* Unavailable Anonymous Inner Class!! */);
    }
}

