/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.standardutils.dao;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Map;
import javax.sql.DataSource;
import se.unlogic.standardutils.dao.BeanResultSetPopulator;
import se.unlogic.standardutils.dao.TransactionAlreadyAbortedException;
import se.unlogic.standardutils.dao.TransactionAlreadyComittedException;
import se.unlogic.standardutils.dao.querys.ArrayListQuery;
import se.unlogic.standardutils.dao.querys.BooleanQuery;
import se.unlogic.standardutils.dao.querys.HashMapQuery;
import se.unlogic.standardutils.dao.querys.ObjectQuery;
import se.unlogic.standardutils.dao.querys.PreparedStatementQuery;
import se.unlogic.standardutils.dao.querys.UpdateQuery;
import se.unlogic.standardutils.db.DBUtils;

public class TransactionHandler {
    private final Connection connection;
    private ArrayList<PreparedStatementQuery> queryList;
    private boolean aborted;
    private boolean commited;

    public TransactionHandler(DataSource dataSource) throws SQLException {
        this.connection = dataSource.getConnection();
        this.connection.setAutoCommit(false);
    }

    public TransactionHandler(Connection connection) throws SQLException {
        this.connection = connection;
        connection.setAutoCommit(false);
    }

    public UpdateQuery getUpdateQuery(String sqlExpression) throws SQLException {
        this.checkStatus();
        UpdateQuery query = new UpdateQuery(this.connection, false, sqlExpression);
        this.checkQueryList();
        this.queryList.add(query);
        return query;
    }

    private synchronized void checkQueryList() {
        if (this.queryList == null) {
            this.queryList = new ArrayList();
        }
    }

    public BooleanQuery getBooleanQuery(String sql) throws SQLException {
        BooleanQuery query = new BooleanQuery(this.connection, false, sql);
        this.checkQueryList();
        this.queryList.add(query);
        return query;
    }

    public <T> ObjectQuery<T> getObjectQuery(String sql, BeanResultSetPopulator<T> populator) throws SQLException {
        ObjectQuery<T> query = new ObjectQuery<T>(this.connection, false, sql, populator);
        this.checkQueryList();
        this.queryList.add(query);
        return query;
    }

    public <T> ArrayListQuery<T> getArrayListQuery(String sql, BeanResultSetPopulator<T> populator) throws SQLException {
        ArrayListQuery<T> query = new ArrayListQuery<T>(this.connection, false, sql, populator);
        this.checkQueryList();
        this.queryList.add(query);
        return query;
    }

    public <K, V> HashMapQuery<K, V> getHashMapQuery(String sql, BeanResultSetPopulator<? extends Map.Entry<K, V>> populator) throws SQLException {
        HashMapQuery query = new HashMapQuery(this.connection, false, sql, populator);
        this.checkQueryList();
        this.queryList.add(query);
        return query;
    }

    public synchronized void commit() throws SQLException {
        this.checkStatus();
        try {
            this.connection.commit();
            this.commited = true;
        }
        finally {
            if (!this.commited) {
                this.abort();
            } else {
                this.closeConnection();
            }
        }
    }

    public synchronized int getQueryCount() {
        if (this.queryList == null) {
            return 0;
        }
        return this.queryList.size();
    }

    public synchronized void abort() {
        this.checkStatus();
        if (this.queryList != null) {
            for (PreparedStatementQuery query : this.queryList) {
                query.abort();
            }
        }
        if (this.connection != null) {
            try {
                this.connection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        this.closeConnection();
        this.aborted = true;
    }

    private void closeConnection() {
        DBUtils.closeConnection(this.connection);
    }

    private void checkStatus() {
        if (this.aborted) {
            throw new TransactionAlreadyAbortedException();
        }
        if (this.commited) {
            throw new TransactionAlreadyComittedException();
        }
    }

    protected void finalize() throws Throwable {
        if (!this.commited && !this.aborted) {
            this.abort();
        }
        super.finalize();
    }

    public boolean isClosed() {
        return this.commited || this.aborted;
    }

    public static void autoClose(TransactionHandler transactionHandler) {
        if (transactionHandler != null && !transactionHandler.isClosed()) {
            transactionHandler.abort();
        }
    }

    Connection getConnection() {
        return this.connection;
    }

    public boolean isAborted() {
        return this.aborted;
    }

    public boolean isCommited() {
        return this.commited;
    }
}

