/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.standardutils.image;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;

public class ImageUtils {
    public static final String JPG = "jpg";
    public static final String GIF = "gif";
    public static final String PNG = "png";
    public static final String BMP = "bmp";
    public static final String WBMP = "wbmp";

    public static BufferedImage getImageByResource(String url) {
        try {
            return ImageIO.read(ImageUtils.class.getResource(url));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static BufferedImage getImage(String url) {
        try {
            return ImageIO.read(new File(url));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean isReadable(String url) {
        File file = new File(url);
        return file.exists() && file.canRead();
    }

    public static BufferedImage getImage(InputStream inputStream) {
        try {
            return ImageIO.read(inputStream);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static BufferedImage scaleImage(BufferedImage image, double xFactor, double yFactor) {
        if (image != null) {
            return ImageUtils.scale(image, xFactor, yFactor);
        }
        return null;
    }

    public static BufferedImage scaleImage(BufferedImage image, int maxHeight, int maxWidth, int quality, int imageType) {
        if (image.getWidth() > maxWidth && image.getHeight() > maxHeight) {
            double aspectRatio = (double)image.getWidth() / (double)image.getHeight();
            if (aspectRatio >= 1.0) {
                return ImageUtils.scaleImageByWidth(image, maxWidth, quality, imageType);
            }
            return ImageUtils.scaleImageByHeight(image, maxHeight, quality, imageType);
        }
        if (image.getWidth() > maxWidth) {
            return ImageUtils.scaleImageByWidth(image, maxWidth, quality, imageType);
        }
        if (image.getHeight() > maxHeight) {
            return ImageUtils.scaleImageByHeight(image, maxHeight, quality, imageType);
        }
        if (image.getType() != imageType) {
            return ImageUtils.scale(image, image.getHeight(), image.getWidth(), quality, imageType);
        }
        return image;
    }

    public static BufferedImage scaleImageByWidth(BufferedImage image, int maxWidth, int quality, int imageType) {
        double scale = image.getWidth() > image.getHeight() ? (double)maxWidth / (double)image.getWidth() : (double)maxWidth / (double)image.getHeight();
        int scaledW = (int)(scale * (double)image.getWidth());
        int scaledH = (int)(scale * (double)image.getHeight());
        scaledW = ImageUtils.checkSize(scaledW);
        scaledH = ImageUtils.checkSize(scaledH);
        return ImageUtils.scale(image, scaledH, scaledW, quality, imageType);
    }

    private static int checkSize(int value) {
        if (value < 1) {
            return 1;
        }
        return value;
    }

    public static BufferedImage scaleImageByHeight(BufferedImage image, int maxHeight, int quality, int imageType) {
        double scale = image.getHeight() > image.getWidth() ? (double)maxHeight / (double)image.getHeight() : (double)maxHeight / (double)image.getWidth();
        int scaledW = (int)(scale * (double)image.getWidth());
        int scaledH = (int)(scale * (double)image.getHeight());
        scaledW = ImageUtils.checkSize(scaledW);
        scaledH = ImageUtils.checkSize(scaledH);
        return ImageUtils.scale(image, scaledH, scaledW, quality, imageType);
    }

    public static void writeImage(BufferedImage image, String url, String format) throws IOException, NullPointerException {
        if (!url.endsWith("." + format)) {
            url = url + "." + format;
        }
        File outputfile = new File(url);
        if (image != null) {
            ImageIO.write((RenderedImage)image, format, outputfile);
        }
    }

    private static BufferedImage scale(BufferedImage image, double xFactor, double yFactor) {
        AffineTransform scaleTransform = new AffineTransform();
        scaleTransform.scale(xFactor, yFactor);
        BufferedImage result = new BufferedImage((int)((double)image.getWidth() * xFactor), (int)((double)image.getHeight() * yFactor), 1);
        Graphics2D g2 = (Graphics2D)result.getGraphics();
        g2.setColor(Color.WHITE);
        g2.fillRect(0, 0, result.getWidth(), result.getHeight());
        g2.drawImage(image, scaleTransform, null);
        return result;
    }

    private static BufferedImage scale(BufferedImage image, int height, int width, int quality, int imageType) {
        BufferedImage result = new BufferedImage(width, height, imageType);
        Graphics2D g2 = (Graphics2D)result.getGraphics();
        g2.setColor(Color.WHITE);
        g2.fillRect(0, 0, width, height);
        Canvas canvas = new Canvas();
        Image tImage = image.getScaledInstance(width, height, quality);
        g2.drawImage(tImage, 0, 0, canvas);
        return result;
    }
}

