/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.grpc.protobuf;

import com.google.protobuf.DynamicMessage;
import com.google.protobuf.Message;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.jboss.logging.Logger;
import org.jboss.resteasy.grpc.protobuf.AssignFromJavabuf;
import org.jboss.resteasy.grpc.protobuf.AssignToJavabuf;
import org.jboss.resteasy.grpc.protobuf.TranslateFromJavabuf;
import org.jboss.resteasy.grpc.protobuf.TranslateToJavabuf;
import org.jboss.resteasy.grpc.servlet.HttpServletResponseImpl;

public class JavabufTranslatorGenerator {
    private static Logger logger = Logger.getLogger(JavabufTranslatorGenerator.class);
    private static Map<String, Class<?>> PRIMITIVE_WRAPPER_TYPES = new HashMap();
    private static Map<String, String> GET_METHODS = new HashMap<String, String>();

    public static void main(String[] args) {
        if (args.length != 2) {
            logger.info((Object)"need two args:");
            logger.info((Object)"  arg[0]: root directory");
            logger.info((Object)"  arg[1]: javabuf wrapper class name");
            return;
        }
        try {
            int index = args[1].lastIndexOf(46);
            String simpleName = index < 0 ? args[1] : args[1].substring(index + 1);
            String translatorClass = simpleName + "_JavabufTranslator";
            Class<?> wrapperClass = Class.forName(args[1] + "_proto", true, Thread.currentThread().getContextClassLoader());
            StringBuilder sb = new StringBuilder();
            JavabufTranslatorGenerator.classHeader(args, translatorClass, wrapperClass, sb);
            JavabufTranslatorGenerator.classBody(wrapperClass, sb);
            JavabufTranslatorGenerator.finishClass(sb);
            JavabufTranslatorGenerator.writeTranslatorClass(args, translatorClass, sb);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    private static void classHeader(String[] args, String translatorClass, Class<?> wrapperClass, StringBuilder sb) {
        sb.append("package ").append(wrapperClass.getPackage().getName()).append(";\n\n");
        JavabufTranslatorGenerator.imports(wrapperClass, sb);
        sb.append("public class ").append(translatorClass).append(" {\n");
    }

    private static void imports(Class<?> wrapperClass, StringBuilder sb) {
        Class<?>[] classes;
        sb.append("import java.lang.reflect.Field;\n").append("import java.util.ArrayList;\n").append("import java.util.HashMap;\n").append("import java.util.List;\n").append("import java.util.Map;\n").append("import com.google.protobuf.Descriptors;\n").append("import com.google.protobuf.Descriptors.Descriptor;\n").append("import com.google.protobuf.Descriptors.FieldDescriptor;\n").append("import com.google.protobuf.DynamicMessage;\n").append("import com.google.protobuf.Message;\n").append("import ").append(AssignFromJavabuf.class.getCanonicalName()).append(";\n").append("import ").append(AssignToJavabuf.class.getCanonicalName()).append(";\n").append("import ").append(TranslateFromJavabuf.class.getCanonicalName()).append(";\n").append("import ").append(TranslateToJavabuf.class.getCanonicalName()).append(";\n").append("import ").append(HttpServletResponseImpl.class.getCanonicalName()).append(";\n");
        for (Class<?> clazz : classes = wrapperClass.getClasses()) {
            if (clazz.isInterface()) continue;
            String simpleName = clazz.getSimpleName();
            if (PRIMITIVE_WRAPPER_TYPES.containsKey(simpleName)) {
                sb.append("import ").append(clazz.getName().replace("$", ".")).append(";\n");
                continue;
            }
            if ("GeneralEntityMessage".equals(simpleName) || "GeneralReturnMessage".equals(simpleName) || "ServletInfo".equals(simpleName) || "gNewCookie".equals(simpleName) || "gCookie".equals(simpleName) || "gHeader".equals(simpleName) || "FormMap".equals(simpleName) || "FormValues".equals(simpleName)) continue;
            sb.append("import ").append(JavabufTranslatorGenerator.originalClassName(clazz.getName())).append(";\n");
        }
        sb.append("\n");
    }

    private static void classBody(Class<?> wrapperClass, StringBuilder sb) throws Exception {
        Class<?>[] classes = wrapperClass.getClasses();
        JavabufTranslatorGenerator.privateVariables(sb);
        JavabufTranslatorGenerator.staticInit(classes, sb);
        JavabufTranslatorGenerator.publicMethods(sb);
        JavabufTranslatorGenerator.privateMethods(sb);
        for (Class<?> clazz : classes) {
            String simpleName;
            if (clazz.isInterface() || "GeneralEntityMessage".equals(simpleName = clazz.getSimpleName()) || "GeneralReturnMessage".equals(simpleName)) continue;
            JavabufTranslatorGenerator.createTranslator(clazz, sb);
        }
    }

    private static void staticInit(Class<?>[] classes, StringBuilder sb) {
        sb.append("   static {\n");
        for (Class<?> clazz : classes) {
            String simpleName;
            if (clazz.isInterface() || "gEmpty".equals(simpleName = clazz.getSimpleName()) || "GeneralEntityMessage".equals(simpleName) || "GeneralReturnMessage".equals(simpleName) || "ServletInfo".equals(simpleName) || "gNewCookie".equals(simpleName) || "gCookie".equals(simpleName) || "gHeader".equals(simpleName) || "FormMap".equals(simpleName) || "FormValues".equals(simpleName)) continue;
            int i = simpleName.lastIndexOf("___");
            String originalClassName = i >= 0 ? simpleName.substring(i + 3) : (PRIMITIVE_WRAPPER_TYPES.containsKey(simpleName) ? simpleName.substring(1) : simpleName);
            sb.append("      toJavabufMap.put(").append(originalClassName).append(".class, new ").append(simpleName).append("_ToJavabuf());\n");
            sb.append("      fromJavabufMap.put(").append("\"" + simpleName + "\"").append(", new ").append(simpleName).append("_FromJavabuf());\n");
        }
        sb.append("   }\n\n");
    }

    private static void publicMethods(StringBuilder sb) {
        sb.append("   public static boolean handlesToJavabuf(Class<?> clazz) {\n").append("      return clazz.isPrimitive() || toJavabufMap.containsKey(clazz);\n").append("   }\n\n").append("   public static boolean handlesFromJavabuf(Class<?> clazz) {\n").append("      return clazz.isPrimitive() || toJavabufMap.containsKey(clazz);\n").append("   }\n\n").append("   public static Message translateToJavabuf(Object o) {\n").append("      TranslateToJavabuf ttj = toJavabufMap.get(o.getClass());\n").append("      if (ttj == null) {\n").append("         throw new RuntimeException(o.getClass() + \" is not recognized\");\n").append("      }\n").append("      return ttj.assignToJavabuf(o);\n").append("   }\n\n").append("   public static Object translateFromJavabuf(Message message) {\n").append("      String s = null;\n").append("      try {\n").append("         s = message.getDescriptorForType().getFullName();\n").append("         s = s.substring(s.lastIndexOf(\".\") + 1);\n").append("         TranslateFromJavabuf tfj = fromJavabufMap.get(s);\n").append("         if (tfj == null) {\n").append("            throw new RuntimeException(message.getClass() + \" is not recognized\");\n").append("         }\n").append("         return tfj.assignFromJavabuf(message);\n").append("      } catch (Exception e) {\n").append("         throw new RuntimeException(e);\n").append("      }\n").append("   }\n\n");
    }

    private static void createTranslator(Class<?> clazz, StringBuilder sb) throws Exception {
        JavabufTranslatorGenerator.createTranslatorToJavabuf(clazz, sb);
        JavabufTranslatorGenerator.createTranslatorFromJavabuf(clazz, sb);
    }

    private static void privateVariables(StringBuilder sb) {
        sb.append("   private static Map<Class<?>, TranslateToJavabuf> toJavabufMap = new HashMap<Class<?>, TranslateToJavabuf>();\n");
        sb.append("   private static Map<String, TranslateFromJavabuf> fromJavabufMap = new HashMap<String, TranslateFromJavabuf>();\n\n");
    }

    private static void privateMethods(StringBuilder sb) {
        sb.append("   private static AssignToJavabuf toJavabuf(Class<?> javaClass, FieldDescriptor fd) {\n").append("      try {\n").append("         AssignToJavabuf assignToJavabuf = (obj, messageBuilder) -> {\n").append("            try {\n").append("               if (isSuperClass(fd.getName())) {\n").append("                  Message message = toJavabufMap.get(obj.getClass().getSuperclass()).assignToJavabuf(obj);\n").append("                  messageBuilder.setField(fd, message);\n").append("               } else {\n").append("                  final Field field = javaClass.getDeclaredField(fd.getName());\n").append("                  field.setAccessible(true);\n").append("                  if (!String.class.equals(field.getType()) && toJavabufMap.keySet().contains(field.getType())) {\n").append("                     Message message = toJavabufMap.get(field.getType()).assignToJavabuf(field.get(obj));\n").append("                     messageBuilder.setField(fd, message);\n").append("                  } else {\n").append("                     messageBuilder.setField(fd, field.get(obj));\n").append("                  }\n").append("               }\n").append("            } catch (Exception e) {\n").append("               //\n").append("            }\n").append("         };\n").append("         return assignToJavabuf;\n").append("      } catch (Exception e) {\n").append("         throw new RuntimeException(e);\n").append("      }\n").append("   }\n\n");
        sb.append("   private static AssignFromJavabuf fromJavabuf(Class<?> javaClass, FieldDescriptor fd) {\n").append("      try {\n").append("         AssignFromJavabuf assignFromJavabuf = (message, object) -> {\n").append("            try {\n").append("               if (isSuperClass(fd.getName())) {\n").append("                  String superClassName = javaClassToJavabufClass(javaClass.getSuperclass().getName());\n").append("                  TranslateFromJavabuf t = fromJavabufMap.get(superClassName);\n").append("                  FieldDescriptor sfd = getSuperField(message);\n").append("                  Message superMessage = (Message) message.getField(sfd);\n").append("                  t.assignExistingFromJavabuf(superMessage, object);\n").append("               } else {\n").append("                  final Field field = javaClass.getDeclaredField(fd.getName());\n").append("                  field.setAccessible(true);\n").append("                  if (Descriptors.FieldDescriptor.Type.MESSAGE.equals(fd.getType())\n").append("                      && fromJavabufMap.keySet().contains(fd.getMessageType().getName())) {\n").append("                     Message submessage = (Message) message.getField(fd);\n").append("                     Object obj = fromJavabufMap.get(fd.getMessageType().getName()).assignFromJavabuf(submessage);\n").append("                     field.set(object, obj);\n").append("                  } else {\n").append("                     Object ooo = message.getField(fd);\n").append("                     field.set(object, ooo);\n").append("                  }\n").append("               }\n").append("            } catch (Exception e) {\n").append("               throw new RuntimeException(e);\n").append("            }\n").append("         };\n").append("         return assignFromJavabuf;\n").append("      } catch (Exception e) {\n").append("         throw new RuntimeException(e);\n").append("      }\n").append("   }\n\n");
        sb.append("   private static String javaClassToJavabufClass(String javaClassName) {\n").append("      String javabufClassName = javaClassName.replace(\".\", \"_\");\n").append("      int i = javabufClassName.lastIndexOf(\"_\");\n").append("      javabufClassName = javabufClassName.substring(0, i) + \"___\" + javabufClassName.substring(i + 1);\n").append("      return javabufClassName;\n").append("   }\n\n");
        sb.append("   private static FieldDescriptor getSuperField(Message message) {\n").append("      Map<FieldDescriptor, Object> map = message.getAllFields();\n").append("      for (FieldDescriptor fd : map.keySet()) {\n").append("         if (fd.getName().endsWith(\"___super\")) {\n").append("            return fd;\n").append("         }\n").append("      }\n").append("      return null;\n").append("   }\n\n");
        sb.append("   private static Object messageToObject(Message message) throws ClassNotFoundException {\n").append("      String messageClassName = message.getClass().getName();\n").append("      int i = messageClassName.indexOf(\"___\");\n").append("      String classname = messageClassName.substring(0, i).replaceAll(\"_\", \".\") + \".\" + messageClassName.substring(i + 2);\n").append("      return Class.forName(classname);\n").append("   }\n\n");
        sb.append("   private static boolean isSuperClass(String fieldName) {\n      return fieldName.endsWith(\"___super\");\n   }\n\n");
    }

    private static void createTranslatorToJavabuf(Class<?> clazz, StringBuilder sb) throws Exception {
        if ("gEmpty".equals(clazz.getSimpleName()) || "gCookie".equals(clazz.getSimpleName()) || "gHeader".equals(clazz.getSimpleName()) || "ServletInfo".equals(clazz.getSimpleName()) || "gNewCookie".equals(clazz.getSimpleName()) || "FormMap".equals(clazz.getSimpleName()) || "FormValues".equals(clazz.getSimpleName())) {
            return;
        }
        sb.append("   static class ").append(JavabufTranslatorGenerator.fqnify(clazz.getSimpleName())).append("_ToJavabuf implements TranslateToJavabuf {\n").append("      private static Descriptor descriptor = ").append(clazz.getCanonicalName()).append(".getDescriptor();\n").append("      private static DynamicMessage.Builder builder = DynamicMessage.newBuilder(descriptor);\n");
        if (PRIMITIVE_WRAPPER_TYPES.containsKey(clazz.getSimpleName())) {
            String simpleJavabufName = clazz.getSimpleName();
            String simpleJavaName = simpleJavabufName.substring(1);
            sb.append("\n").append("      public Message assignToJavabuf(Object x) {\n").append("         ").append(simpleJavaName).append(" p = (").append(simpleJavaName).append(") x;\n").append("         ").append(clazz.getCanonicalName()).append(".Builder builder = ").append(clazz.getCanonicalName()).append(".newBuilder();\n").append("         return builder.setValue(p").append(GET_METHODS.get(simpleJavaName)).append(").build();\n").append("      }\n");
        } else {
            sb.append("      private static List<AssignToJavabuf> assignList = new ArrayList<AssignToJavabuf>();\n\n").append("      static {\n").append("         for (FieldDescriptor f : descriptor.getFields()) {\n").append("            String name = f.getName();\n").append("            if (descriptor.findFieldByName(name) == null) {\n").append("               continue;\n").append("            }\n").append("            assignList.add(toJavabuf(").append(JavabufTranslatorGenerator.originalSimpleName(clazz.getSimpleName())).append(".class, descriptor.findFieldByName(name)));\n").append("         }\n").append("      }\n\n").append("      public Message assignToJavabuf(Object c1) {\n").append("         for (AssignToJavabuf assignTo : assignList) {\n").append("            try {\n").append("               assignTo.assign(c1, builder);\n").append("            } catch (Exception e) {\n").append("               throw new RuntimeException(e);\n").append("            }\n").append("         }\n").append("         return builder.build();\n").append("      }\n");
        }
        sb.append("   }\n\n");
    }

    private static void createTranslatorFromJavabuf(Class<?> clazz, StringBuilder sb) {
        String originalName = JavabufTranslatorGenerator.originalSimpleName(clazz.getName());
        if ("gEmpty".equals(originalName)) {
            return;
        }
        if ("AbstractMessage".equals(clazz.getSimpleName()) || "gCookie".equals(clazz.getSimpleName()) || "gNewCookie".equals(clazz.getSimpleName()) || "gHeader".equals(clazz.getSimpleName()) || "ServletInfo".equals(clazz.getSimpleName()) || "FormMap".equals(clazz.getSimpleName()) || "FormValues".equals(clazz.getSimpleName())) {
            return;
        }
        sb.append("   static class ").append(JavabufTranslatorGenerator.fqnify(clazz.getSimpleName())).append("_FromJavabuf implements TranslateFromJavabuf {\n").append("      private static Descriptor descriptor = ").append(clazz.getCanonicalName()).append(".getDescriptor();\n");
        if (PRIMITIVE_WRAPPER_TYPES.containsKey(originalName)) {
            String javaName = originalName.substring(1);
            if ("gByte".equals(originalName)) {
                sb.append("      public ").append(javaName).append(" assignFromJavabuf(Message message) {\n").append("         FieldDescriptor fd = descriptor.getFields().get(0);\n").append("         return ((Integer) message.getField(fd)).byteValue();\n").append("      }\n\n").append("      public void assignExistingFromJavabuf(Message message, Object obj) { }\n");
            } else if ("gShort".equals(originalName)) {
                sb.append("      public ").append(javaName).append(" assignFromJavabuf(Message message) {\n").append("         FieldDescriptor fd = descriptor.getFields().get(0);\n").append("         return ((Integer) message.getField(fd)).shortValue();\n").append("      }\n\n").append("      public void assignExistingFromJavabuf(Message message, Object obj) { }\n");
            } else if ("gCharacter".equals(originalName)) {
                sb.append("      public ").append(javaName).append(" assignFromJavabuf(Message message) {\n").append("         FieldDescriptor fd = descriptor.getFields().get(0);\n").append("         return ((String) message.getField(fd)).charAt(0);\n").append("      }\n\n").append("      public void assignExistingFromJavabuf(Message message, Object obj) { }\n");
            } else {
                sb.append("      public ").append(javaName).append(" assignFromJavabuf(Message message) {\n").append("         FieldDescriptor fd = descriptor.getFields().get(0);\n").append("         return (").append(javaName).append(") message.getField(fd);\n").append("      }\n\n").append("      public void assignExistingFromJavabuf(Message message, Object obj) { }\n");
            }
        } else {
            sb.append("      private static List<AssignFromJavabuf> assignList = new ArrayList<AssignFromJavabuf>();\n\n").append("      static {\n").append("         for (FieldDescriptor f : descriptor.getFields()) {\n").append("            String name = f.getName();\n").append("            if (descriptor.findFieldByName(name) == null) {\n").append("               continue;\n").append("            }\n").append("            assignList.add(fromJavabuf(").append(originalName).append(".class, descriptor.findFieldByName(name)));\n").append("         }\n").append("      }\n\n").append("      public ").append(originalName).append(" assignFromJavabuf(Message message) {\n").append("         ").append(originalName).append(" obj = new ").append(originalName).append("();\n").append("         for (AssignFromJavabuf assignFrom : assignList) {\n").append("            try {\n").append("               assignFrom.assign(message, obj);\n").append("            } catch (Exception e) {\n").append("               throw new RuntimeException(e);\n").append("            }\n").append("         }\n").append("         return obj;\n").append("      }\n\n").append("      public void assignExistingFromJavabuf(Message message, Object obj) {\n").append("         for (AssignFromJavabuf assignFrom : assignList) {\n").append("            try {\n").append("               assignFrom.assign(message, obj);\n").append("            } catch (Exception e) {\n").append("               throw new RuntimeException(e);\n").append("            }\n").append("         }\n").append("      }\n");
        }
        sb.append("   }\n\n");
    }

    private static void finishClass(StringBuilder sb) {
        sb.append("}\n");
    }

    private static void writeTranslatorClass(String[] args, String translatorClass, StringBuilder sb) throws IOException {
        StringBuilder root = new StringBuilder("target/generated-sources/protobuf/grpc-java/");
        File dir = new File(root.toString());
        if (!dir.exists()) {
            dir.mkdir();
        }
        String pkg = args[1].lastIndexOf(".") < 0 ? "" : args[1].substring(0, args[1].lastIndexOf("."));
        for (String s : pkg.split("\\.")) {
            dir = new File(root.append("/").append(s).toString());
            if (dir.exists()) continue;
            dir.mkdir();
        }
        File file = new File(root.append("/").append(translatorClass).append(".java").toString());
        if (!file.exists()) {
            file.createNewFile();
        }
        FileWriter fw = new FileWriter(file.getAbsoluteFile());
        BufferedWriter bw = new BufferedWriter(fw);
        bw.write(sb.toString());
        bw.close();
    }

    private static String fqnify(String s) {
        return s.replace(".", "_");
    }

    private static String originalSimpleName(String s) {
        int i = s.lastIndexOf("___");
        if (i >= 0) {
            return s.substring(i + 3).replace('$', '.');
        }
        i = s.lastIndexOf("$");
        if (i >= 0) {
            return s.substring(i + 1);
        }
        if (PRIMITIVE_WRAPPER_TYPES.containsKey(s)) {
            return s.substring(1);
        }
        return s;
    }

    private static String originalClassName(String s) {
        int i = s.indexOf("$");
        int j = s.lastIndexOf("___");
        j = j < 0 ? s.length() : j;
        String pkg = s.substring(i + 1, j).replace('_', '.');
        return pkg + "." + JavabufTranslatorGenerator.originalSimpleName(s);
    }

    static {
        PRIMITIVE_WRAPPER_TYPES.put("gByte", Byte.TYPE);
        PRIMITIVE_WRAPPER_TYPES.put("gShort", Short.TYPE);
        PRIMITIVE_WRAPPER_TYPES.put("gInteger", Integer.TYPE);
        PRIMITIVE_WRAPPER_TYPES.put("gLong", Long.TYPE);
        PRIMITIVE_WRAPPER_TYPES.put("gFloat", Float.TYPE);
        PRIMITIVE_WRAPPER_TYPES.put("gDouble", Double.TYPE);
        PRIMITIVE_WRAPPER_TYPES.put("gBoolean", Boolean.TYPE);
        PRIMITIVE_WRAPPER_TYPES.put("gCharacter", Character.TYPE);
        PRIMITIVE_WRAPPER_TYPES.put("gString", String.class);
        PRIMITIVE_WRAPPER_TYPES.put("gEmpty", Void.TYPE);
        GET_METHODS.put("Byte", ".byteValue()");
        GET_METHODS.put("Short", ".shortValue()");
        GET_METHODS.put("Integer", ".intValue()");
        GET_METHODS.put("Long", ".longValue()");
        GET_METHODS.put("Float", ".floatValue()");
        GET_METHODS.put("Double", ".doubleValue()");
        GET_METHODS.put("Boolean", ".booleanValue()");
        GET_METHODS.put("Character", ".toString()");
        GET_METHODS.put("String", "");
    }

    public static interface AssignFrom {
        public void assign(Message var1, Object var2);
    }

    public static interface AssignTo {
        public void assign(Object var1, DynamicMessage.Builder var2);
    }
}

