/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.jose.jwe.crypto;

import java.nio.charset.Charset;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.SecretKey;
import org.jboss.resteasy.jose.Base64Url;
import org.jboss.resteasy.jose.jwe.CompressionAlgorithm;
import org.jboss.resteasy.jose.jwe.EncryptionMethod;
import org.jboss.resteasy.jose.jwe.crypto.AESCBC;
import org.jboss.resteasy.jose.jwe.crypto.AESGCM;
import org.jboss.resteasy.jose.jwe.crypto.AuthenticatedCipherText;
import org.jboss.resteasy.jose.jwe.crypto.DeflateHelper;

public class DirectEncrypter {
    private static SecureRandom randomGen;

    private static void initSecureRandom() {
        try {
            randomGen = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static String encrypt(EncryptionMethod enc, CompressionAlgorithm compressionAlgorithm, String encodedJWEHeader, SecretKey key, byte[] bytes) {
        AuthenticatedCipherText authCipherText;
        byte[] iv;
        if (randomGen == null) {
            DirectEncrypter.initSecureRandom();
        }
        if (enc.getCekBitLength() != key.getEncoded().length * 8) {
            throw new RuntimeException("The Content Encryption Key (CEK) length must be " + enc.getCekBitLength() + " bits for " + (Object)((Object)enc) + " encryption");
        }
        byte[] plainText = DeflateHelper.applyCompression(compressionAlgorithm, bytes);
        byte[] aad = encodedJWEHeader.getBytes(Charset.forName("UTF-8"));
        if (enc.equals((Object)EncryptionMethod.A128CBC_HS256) || enc.equals((Object)EncryptionMethod.A256CBC_HS512)) {
            iv = AESCBC.generateIV(randomGen);
            authCipherText = AESCBC.encryptAuthenticated(key, iv, plainText, aad);
        } else if (enc.equals((Object)EncryptionMethod.A128GCM) || enc.equals((Object)EncryptionMethod.A256GCM)) {
            iv = AESGCM.generateIV(randomGen);
            authCipherText = AESGCM.encrypt(key, iv, plainText, aad);
        } else {
            throw new RuntimeException("Unsupported encryption method, must be A128CBC_HS256, A256CBC_HS512, A128GCM or A128GCM");
        }
        StringBuilder builder = new StringBuilder(encodedJWEHeader).append('.').append('.').append(Base64Url.encode(iv)).append('.').append(Base64Url.encode(authCipherText.getCipherText())).append('.').append(Base64Url.encode(authCipherText.getAuthenticationTag()));
        return builder.toString();
    }
}

