/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.microprofile.client;

import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientResponseContext;
import javax.ws.rs.client.ClientResponseFilter;
import javax.ws.rs.client.ResponseProcessingException;
import javax.ws.rs.core.Response;
import org.eclipse.microprofile.rest.client.ext.ResponseExceptionMapper;
import org.jboss.logging.Logger;
import org.jboss.resteasy.client.jaxrs.internal.ClientResponse;
import org.jboss.resteasy.client.jaxrs.internal.ClientResponseContextImpl;
import org.jboss.resteasy.microprofile.client.PartialResponse;

public class ExceptionMapping
implements ClientResponseFilter {
    private final Set<Object> instances;

    public ExceptionMapping(Set<Object> instances) {
        this.instances = instances;
    }

    public void filter(ClientRequestContext requestContext, ClientResponseContext responseContext) {
        PartialResponse response = new PartialResponse(responseContext);
        LinkedList<ResponseExceptionMapper> candidates = new LinkedList<ResponseExceptionMapper>();
        for (Object o : this.instances) {
            ResponseExceptionMapper candidate;
            if (!(o instanceof ResponseExceptionMapper) || !(candidate = (ResponseExceptionMapper)o).handles(response.getStatus(), response.getHeaders())) continue;
            candidates.add(candidate);
        }
        if (candidates.isEmpty()) {
            return;
        }
        candidates.sort((m1, m2) -> Integer.compare(m1.getPriority(), m2.getPriority()));
        throw new HandlerException(responseContext, candidates);
    }

    public static class HandlerException
    extends ResponseProcessingException {
        private static final Logger LOGGER = Logger.getLogger(HandlerException.class);
        protected ClientResponse handled;
        protected List<ResponseExceptionMapper> candidates;

        public HandlerException(ClientResponseContext context, List<ResponseExceptionMapper> candidates) {
            super(null, "Handled Internally");
            this.handled = ((ClientResponseContextImpl)context).getClientResponse();
            this.candidates = candidates;
        }

        public void mapException(Method method) throws Exception {
            this.handled.bufferEntity();
            for (ResponseExceptionMapper mapper : this.candidates) {
                Throwable exception = mapper.toThrowable((Response)this.handled);
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                if (exception instanceof Error) {
                    throw (Error)exception;
                }
                for (Class<?> exc : method.getExceptionTypes()) {
                    if (exception == null || !exc.isAssignableFrom(exception.getClass())) continue;
                    throw (Exception)exception;
                }
            }
            LOGGER.warnf("No default ResponseExceptionMapper found or user's ResponseExceptionMapper returned null.  Response status: %s  messge: %s", (Object)this.handled.getStatus(), (Object)this.handled.getReasonPhrase());
        }
    }
}

