/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.microprofile.client;

import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.enterprise.inject.spi.PassivationCapable;
import jakarta.enterprise.util.AnnotationLiteral;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import javax.net.ssl.HostnameVerifier;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.rest.client.RestClientBuilder;
import org.eclipse.microprofile.rest.client.inject.RestClient;
import org.jboss.logging.Logger;

public class RestClientDelegateBean
implements Bean<Object>,
PassivationCapable {
    private static final Logger LOGGER = Logger.getLogger(RestClientDelegateBean.class);
    public static final String REST_URL_FORMAT = "%s/mp-rest/url";
    public static final String REST_URI_FORMAT = "%s/mp-rest/uri";
    public static final String REST_SCOPE_FORMAT = "%s/mp-rest/scope";
    public static final String REST_CONNECT_TIMEOUT_FORMAT = "%s/mp-rest/connectTimeout";
    public static final String REST_READ_TIMEOUT_FORMAT = "%s/mp-rest/readTimeout";
    public static final String REST_PROVIDERS = "%s/mp-rest/providers";
    public static final String TRUST_STORE = "%s/mp-rest/trustStore";
    public static final String TRUST_STORE_PASSWORD = "%s/mp-rest/trustStorePassword";
    public static final String TRUST_STORE_TYPE = "%s/mp-rest/trustStoreType";
    public static final String KEY_STORE = "%s/mp-rest/keyStore";
    public static final String KEY_STORE_PASSWORD = "%s/mp-rest/keyStorePassword";
    public static final String KEY_STORE_TYPE = "%s/mp-rest/keyStoreType";
    public static final String HOSTNAME_VERIFIER = "%s/mp-rest/hostnameVerifier";
    private static final String PROPERTY_PREFIX = "%s/property/";
    private final Class<?> proxyType;
    private final Class<? extends Annotation> scope;
    private final BeanManager beanManager;
    private final Config config;
    private final Optional<String> baseUri;
    private final Optional<String> configKey;

    RestClientDelegateBean(Class<?> proxyType, BeanManager beanManager, Optional<String> baseUri, Optional<String> configKey) {
        this.proxyType = proxyType;
        this.beanManager = beanManager;
        this.baseUri = baseUri;
        this.configKey = configKey;
        this.config = ConfigProvider.getConfig();
        this.scope = this.resolveScope();
    }

    public String getId() {
        return this.proxyType.getName();
    }

    public Class<?> getBeanClass() {
        return this.proxyType;
    }

    public Set<InjectionPoint> getInjectionPoints() {
        return Collections.emptySet();
    }

    public Object create(CreationalContext<Object> creationalContext) {
        RestClientBuilder builder = RestClientBuilder.newBuilder();
        this.configureUri(builder);
        this.configureTimeouts(builder);
        this.configureProviders(builder);
        this.configureSsl(builder);
        this.getConfigProperties().forEach((arg_0, arg_1) -> ((RestClientBuilder)builder).property(arg_0, arg_1));
        return builder.build(this.proxyType);
    }

    private void configureSsl(RestClientBuilder builder) {
        Optional<String> maybeTrustStore = this.getOptionalProperty(TRUST_STORE, String.class);
        maybeTrustStore.ifPresent(trustStore -> this.registerTrustStore((String)trustStore, builder));
        Optional<String> maybeKeyStore = this.getOptionalProperty(KEY_STORE, String.class);
        maybeKeyStore.ifPresent(keyStore -> this.registerKeyStore((String)keyStore, builder));
        Optional<String> maybeHostnameVerifier = this.getOptionalProperty(HOSTNAME_VERIFIER, String.class);
        maybeHostnameVerifier.ifPresent(verifier -> this.registerHostnameVerifier((String)verifier, builder));
    }

    private void registerHostnameVerifier(String verifier, RestClientBuilder builder) {
        try {
            Class<?> verifierClass = Class.forName(verifier, true, Thread.currentThread().getContextClassLoader());
            builder.hostnameVerifier((HostnameVerifier)verifierClass.newInstance());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Could not find hostname verifier class" + verifier, e);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("Failed to instantiate hostname verifier class. Make sure it has a public, no-argument constructor", e);
        }
        catch (ClassCastException e) {
            throw new RuntimeException("The provided hostname verifier " + verifier + " is not an instance of HostnameVerifier", e);
        }
    }

    private void registerKeyStore(String keyStorePath, RestClientBuilder builder) {
        Optional<String> keyStorePassword = this.getOptionalProperty(KEY_STORE_PASSWORD, String.class);
        Optional<String> keyStoreType = this.getOptionalProperty(KEY_STORE_TYPE, String.class);
        try {
            KeyStore keyStore = KeyStore.getInstance(keyStoreType.orElse("JKS"));
            String password = keyStorePassword.orElseThrow(() -> new IllegalArgumentException("No password provided for keystore"));
            try (InputStream input = this.locateStream(keyStorePath);){
                keyStore.load(input, password.toCharArray());
            }
            catch (IOException | NoSuchAlgorithmException | CertificateException e) {
                throw new IllegalArgumentException("Failed to initialize trust store from classpath resource " + keyStorePath, e);
            }
            builder.keyStore(keyStore, password);
        }
        catch (KeyStoreException e) {
            throw new IllegalArgumentException("Failed to initialize trust store from " + keyStorePath, e);
        }
    }

    private void registerTrustStore(String trustStorePath, RestClientBuilder builder) {
        Optional<String> maybeTrustStorePassword = this.getOptionalProperty(TRUST_STORE_PASSWORD, String.class);
        Optional<String> maybeTrustStoreType = this.getOptionalProperty(TRUST_STORE_TYPE, String.class);
        try {
            KeyStore trustStore = KeyStore.getInstance(maybeTrustStoreType.orElse("JKS"));
            String password = maybeTrustStorePassword.orElseThrow(() -> new IllegalArgumentException("No password provided for truststore"));
            try (InputStream input = this.locateStream(trustStorePath);){
                trustStore.load(input, password.toCharArray());
            }
            catch (IOException | NoSuchAlgorithmException | CertificateException e) {
                throw new IllegalArgumentException("Failed to initialize trust store from classpath resource " + trustStorePath, e);
            }
            builder.trustStore(trustStore);
        }
        catch (KeyStoreException e) {
            throw new IllegalArgumentException("Failed to initialize trust store from " + trustStorePath, e);
        }
    }

    private InputStream locateStream(String path) throws FileNotFoundException {
        File certificateFile;
        if (path.startsWith("classpath:")) {
            path = path.replaceFirst("classpath:", "");
            InputStream resultStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(path);
            if (resultStream == null) {
                resultStream = this.getClass().getResourceAsStream(path);
            }
            if (resultStream == null) {
                throw new IllegalArgumentException("Classpath resource " + path + " not found for MicroProfile Rest Client SSL configuration");
            }
            return resultStream;
        }
        if (path.startsWith("file:")) {
            path = path.replaceFirst("file:", "");
        }
        if (!(certificateFile = new File(path)).isFile()) {
            throw new IllegalArgumentException("Certificate file: " + path + " not found for MicroProfile Rest Client SSL configuration");
        }
        return new FileInputStream(certificateFile);
    }

    private void configureProviders(RestClientBuilder builder) {
        Optional<String> maybeProviders = this.getOptionalProperty(REST_PROVIDERS, String.class);
        maybeProviders.ifPresent(providers -> this.registerProviders(builder, (String)providers));
    }

    private void registerProviders(RestClientBuilder builder, String providersAsString) {
        Stream.of(providersAsString.split(",")).map(String::trim).map(this::providerClassForName).forEach(arg_0 -> ((RestClientBuilder)builder).register(arg_0));
    }

    private Class<?> providerClassForName(String name) {
        try {
            return Class.forName(name, true, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Could not find provider class: " + name);
        }
    }

    private void configureTimeouts(RestClientBuilder builder) {
        Optional<Long> connectTimeout = this.getOptionalProperty(REST_CONNECT_TIMEOUT_FORMAT, Long.class);
        connectTimeout.ifPresent(timeout -> builder.connectTimeout(timeout.longValue(), TimeUnit.MILLISECONDS));
        Optional<Long> readTimeout = this.getOptionalProperty(REST_READ_TIMEOUT_FORMAT, Long.class);
        readTimeout.ifPresent(timeout -> builder.readTimeout(timeout.longValue(), TimeUnit.MILLISECONDS));
    }

    private void configureUri(RestClientBuilder builder) {
        Optional<String> baseUriFromConfig = this.getOptionalProperty(REST_URI_FORMAT, String.class);
        Optional<String> baseUrlFromConfig = this.getOptionalProperty(REST_URL_FORMAT, String.class);
        if (baseUriFromConfig.isPresent()) {
            builder.baseUri(RestClientDelegateBean.uriFromString(baseUriFromConfig.get()));
        } else if (baseUrlFromConfig.isPresent()) {
            builder.baseUrl(this.urlFromString(baseUrlFromConfig, baseUrlFromConfig.get()));
        } else {
            this.baseUri.ifPresent(uri -> builder.baseUri(RestClientDelegateBean.uriFromString(uri)));
        }
    }

    private <T> Optional<T> getOptionalProperty(String propertyFormat, Class<T> type) {
        Optional value = this.config.getOptionalValue(String.format(propertyFormat, this.proxyType.getName()), type);
        if (value.isPresent() || !this.configKey.isPresent()) {
            return value;
        }
        return this.config.getOptionalValue(String.format(propertyFormat, this.configKey.get()), type);
    }

    private URL urlFromString(Optional<String> baseUrlFromConfig, String urlString) {
        try {
            return new URL(urlString);
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("The value of URL was invalid " + baseUrlFromConfig);
        }
    }

    private static URI uriFromString(String uriString) {
        try {
            return new URI(uriString);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("The value of URI was invalid " + uriString);
        }
    }

    public void destroy(Object instance, CreationalContext<Object> creationalContext) {
        if (instance instanceof AutoCloseable) {
            try {
                ((AutoCloseable)instance).close();
            }
            catch (Exception e) {
                LOGGER.debugf((Throwable)e, "Failed to close client %s", instance);
            }
        }
    }

    public Set<Type> getTypes() {
        return Collections.singleton(this.proxyType);
    }

    public Set<Annotation> getQualifiers() {
        HashSet<Annotation> qualifiers = new HashSet<Annotation>();
        qualifiers.add((Annotation)new AnnotationLiteral<Default>(){});
        qualifiers.add((Annotation)new AnnotationLiteral<Any>(){});
        qualifiers.add((Annotation)RestClient.LITERAL);
        return qualifiers;
    }

    public Class<? extends Annotation> getScope() {
        return this.scope;
    }

    public String getName() {
        return this.proxyType.getName();
    }

    public Set<Class<? extends Annotation>> getStereotypes() {
        return Collections.emptySet();
    }

    public boolean isAlternative() {
        return false;
    }

    private Map<String, Integer> getConfigProperties() {
        HashMap<String, Integer> configProperties = new HashMap<String, Integer>();
        if (this.configKey.isPresent()) {
            String configKeyProperty = String.format(PROPERTY_PREFIX, this.configKey.get());
            this.getConfigProperties(configKeyProperty, configProperties);
        }
        String property = String.format(PROPERTY_PREFIX, this.proxyType.getName());
        this.getConfigProperties(property, configProperties);
        return configProperties;
    }

    private void getConfigProperties(String property, Map<String, Integer> configProperties) {
        for (String propertyName : this.config.getPropertyNames()) {
            if (!propertyName.startsWith(property)) continue;
            Integer value = (Integer)this.config.getValue(propertyName, Integer.class);
            String strippedProperty = propertyName.replace(property, "");
            configProperties.put(strippedProperty, value);
        }
    }

    private Class<? extends Annotation> resolveScope() {
        Annotation[] annotations;
        String configuredScope = this.getOptionalProperty(REST_SCOPE_FORMAT, String.class).orElse(null);
        if (configuredScope != null) {
            try {
                return Class.forName(configuredScope);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Invalid scope: " + configuredScope, e);
            }
        }
        ArrayList<Annotation> possibleScopes = new ArrayList<Annotation>();
        for (Annotation annotation : annotations = this.proxyType.getDeclaredAnnotations()) {
            if (!this.beanManager.isScope(annotation.annotationType())) continue;
            possibleScopes.add(annotation);
        }
        if (possibleScopes.isEmpty()) {
            return Dependent.class;
        }
        if (possibleScopes.size() == 1) {
            return ((Annotation)possibleScopes.get(0)).annotationType();
        }
        throw new IllegalArgumentException("Ambiguous scope definition on " + this.proxyType + ": " + possibleScopes);
    }
}

