/*
 * Decompiled with CFR 0.152.
 */
package dev.resteasy.microprofile.rest.client.tck;

import java.io.FilePermission;
import java.lang.reflect.ReflectPermission;
import java.net.SocketPermission;
import java.security.Permission;
import java.util.ArrayList;
import java.util.List;
import java.util.PropertyPermission;
import org.jboss.arquillian.container.test.spi.client.deployment.ApplicationArchiveProcessor;
import org.jboss.arquillian.test.spi.TestClass;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.container.ManifestContainer;
import org.wildfly.testing.tools.deployments.DeploymentDescriptors;

public class RestClientTckApplicationArchiveProcessor
implements ApplicationArchiveProcessor {
    private static final List<String> ALL_FILE_TESTS = List.of("org.eclipse.microprofile.rest.client.tck.ssl.SslContextTest", "org.eclipse.microprofile.rest.client.tck.ssl.SslHostnameVerifierTest", "org.eclipse.microprofile.rest.client.tck.ssl.SslMutualTest", "org.eclipse.microprofile.rest.client.tck.ssl.SslTrustStoreTest");
    private static final List<String> GET_CLASS_LOADER_TESTS = List.of("org.eclipse.microprofile.rest.client.tck.cditests.CDIProxyServerTest", "org.eclipse.microprofile.rest.client.tck.ssl.SslHostnameVerifierTest", "org.eclipse.microprofile.rest.client.tck.ssl.SslMutualTest", "org.eclipse.microprofile.rest.client.tck.ssl.SslTrustStoreTest", "org.eclipse.microprofile.rest.client.tck.ProxyServerTest");
    private static final List<String> JETTY_SERVER_TESTS = List.of("org.eclipse.microprofile.rest.client.tck.ProxyServerTest", "org.eclipse.microprofile.rest.client.tck.cditests.CDIProxyServerTest");

    public void process(Archive<?> applicationArchive, TestClass testClass) {
        if (applicationArchive instanceof ManifestContainer) {
            Node currentPermissionsXml;
            ManifestContainer container = (ManifestContainer)applicationArchive;
            ArrayList<Permission> permissions = new ArrayList<Permission>(List.of(new ReflectPermission("suppressAccessChecks"), new PropertyPermission("arquillian.*", "read"), new PropertyPermission("jetty.*", "read,write"), new PropertyPermission("org.eclipse.microprofile.rest.client.*", "read"), new RuntimePermission("getenv.JETTY_AVAILABLE_PROCESSORS"), new RuntimePermission("getenv.OTEL_JAVAAGENT_DEBUG"), new RuntimePermission("getenv.OTEL_INSTRUMENTATION_EXPERIMENTAL_SPAN_SUPPRESSION_STRATEGY"), new PropertyPermission("testng.*", "read"), new PropertyPermission("user.dir", "read"), new RuntimePermission("accessDeclaredMembers"), new PropertyPermission("wiremock.*", "read"), new SocketPermission("localhost", "resolve"), new SocketPermission("localhost:*", "connect,listen,resolve"), new SocketPermission("127.0.0.1:*", "connect,resolve")));
            if (ALL_FILE_TESTS.contains(testClass.getName())) {
                permissions.add(new FilePermission("<<ALL FILES>>", "read"));
            }
            if (GET_CLASS_LOADER_TESTS.contains(testClass.getName())) {
                permissions.add(new RuntimePermission("getClassLoader"));
            }
            if (JETTY_SERVER_TESTS.contains(testClass.getName())) {
                permissions.add(new RuntimePermission("modifyThread"));
            }
            if ((currentPermissionsXml = applicationArchive.delete("META-INF/permissions.xml")) == null) {
                currentPermissionsXml = applicationArchive.delete("WEB-INF/classes/META-INF/permissions.yaml");
            }
            if (currentPermissionsXml != null) {
                container.addAsManifestResource(DeploymentDescriptors.appendPermissions((Asset)currentPermissionsXml.getAsset(), permissions), "permissions.xml");
            } else {
                container.addAsManifestResource(DeploymentDescriptors.createPermissionsXmlAsset(permissions), "permissions.xml");
            }
        }
    }
}

