/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.cdi.decorators;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.cdi.decorators.Book;
import org.jboss.resteasy.cdi.decorators.FilterBinding;
import org.jboss.resteasy.cdi.decorators.ResourceBinding;
import org.jboss.resteasy.cdi.decorators.TestResourceIntf;
import org.jboss.resteasy.cdi.decorators.VisitList;

@Path(value="/")
@RequestScoped
public class TestResource
implements TestResourceIntf {
    private static Map<Integer, Book> collection = new HashMap<Integer, Book>();
    private static AtomicInteger counter = new AtomicInteger();
    @Inject
    private Logger log;

    @Override
    @POST
    @Path(value="create")
    @Consumes(value={"application/test+xml"})
    @Produces(value={"text/plain"})
    @FilterBinding
    @ResourceBinding
    public Response createBook(Book book) {
        this.log.info("entering TestResource.createBook()");
        VisitList.add("resourceEnter");
        int id = counter.getAndIncrement();
        book.setId(id);
        collection.put(id, book);
        this.log.info("stored: " + id + "->" + book);
        VisitList.add("resourceLeave");
        this.log.info("leaving TestResource.createBook()");
        return Response.ok((Object)id).build();
    }

    @Override
    @GET
    @Path(value="book/{id:[0-9][0-9]*}")
    @Produces(value={"application/test+xml"})
    @FilterBinding
    @ResourceBinding
    public Book lookupBookById(@PathParam(value="id") int id) {
        this.log.info("entering TestResource.lookupBookById(" + id + ")");
        VisitList.add("resourceEnter");
        this.log.info("books: " + collection);
        Book book = collection.get(id);
        if (book == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        VisitList.add("resourceLeave");
        this.log.info("leaving TestResource.lookupBookById(" + id + ")");
        return book;
    }

    @Override
    @POST
    @Path(value="test")
    @Produces(value={"text/plain"})
    public Response test() {
        int i;
        boolean status;
        this.log.info("entering TestResource.test()");
        ArrayList<String> expectedList = new ArrayList<String>();
        expectedList.add("requestFilterDecoratorEnter");
        expectedList.add("requestFilterDecoratorLeave");
        expectedList.add("readerInterceptorDecoratorEnter");
        expectedList.add("readerInterceptorEnter");
        expectedList.add("readerDecoratorEnter");
        expectedList.add("readerDecoratorLeave");
        expectedList.add("readerInterceptorLeave");
        expectedList.add("readerInterceptorDecoratorLeave");
        expectedList.add("resourceInterceptorEnter");
        expectedList.add("resourceDecoratorEnter");
        expectedList.add("resourceEnter");
        expectedList.add("resourceLeave");
        expectedList.add("resourceDecoratorLeave");
        expectedList.add("resourceInterceptorLeave");
        expectedList.add("responseFilterDecoratorEnter");
        expectedList.add("responseFilterDecoratorLeave");
        expectedList.add("writerInterceptorDecoratorEnter");
        expectedList.add("writerInterceptorEnter");
        expectedList.add("writerInterceptorLeave");
        expectedList.add("writerInterceptorDecoratorLeave");
        expectedList.add("requestFilterDecoratorEnter");
        expectedList.add("requestFilterDecoratorLeave");
        expectedList.add("resourceInterceptorEnter");
        expectedList.add("resourceDecoratorEnter");
        expectedList.add("resourceEnter");
        expectedList.add("resourceLeave");
        expectedList.add("resourceDecoratorLeave");
        expectedList.add("resourceInterceptorLeave");
        expectedList.add("responseFilterDecoratorEnter");
        expectedList.add("responseFilterDecoratorLeave");
        expectedList.add("writerInterceptorDecoratorEnter");
        expectedList.add("writerInterceptorEnter");
        expectedList.add("writerDecoratorEnter");
        expectedList.add("writerDecoratorLeave");
        expectedList.add("writerInterceptorLeave");
        expectedList.add("writerInterceptorDecoratorLeave");
        expectedList.add("readerInterceptorDecoratorEnter");
        expectedList.add("readerInterceptorEnter");
        expectedList.add("readerDecoratorEnter");
        expectedList.add("readerDecoratorLeave");
        expectedList.add("readerInterceptorLeave");
        expectedList.add("readerInterceptorDecoratorLeave");
        ArrayList<String> visitList = VisitList.getList();
        boolean bl = status = expectedList.size() == visitList.size();
        if (!status) {
            this.log.info("expectedList.size() [" + expectedList.size() + "] != visitList.size() [" + visitList.size() + "]");
        } else {
            for (i = 0; i < expectedList.size(); ++i) {
                if (((String)expectedList.get(i)).equals(visitList.get(i))) continue;
                status = false;
                this.log.info("visitList.get(" + i + ") incorrect: should be: " + (String)expectedList.get(i) + ", is: " + visitList.get(i));
                break;
            }
        }
        if (!status) {
            this.log.info("\rexpectedList: ");
            for (i = 0; i < expectedList.size(); ++i) {
                this.log.info(i + ": " + ((String)expectedList.get(i)).toString());
            }
            this.log.info("\rvisitList:");
            for (i = 0; i < visitList.size(); ++i) {
                this.log.info(i + ": " + visitList.get(i).toString());
            }
        }
        this.log.info("leaving TestResource.test()");
        return status ? Response.ok().build() : Response.serverError().build();
    }
}

