/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.cdi.events;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Provider;
import org.jboss.resteasy.cdi.events.Book;
import org.jboss.resteasy.cdi.events.Process;
import org.jboss.resteasy.cdi.events.Read;
import org.jboss.resteasy.cdi.events.ReadIntercept;
import org.jboss.resteasy.cdi.events.Unused;
import org.jboss.resteasy.cdi.events.Write;
import org.jboss.resteasy.cdi.events.WriteIntercept;
import org.jboss.resteasy.cdi.util.Constants;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

@Provider
@Consumes(value={"application/test+xml"})
public class BookReader
implements MessageBodyReader<Book> {
    private static MessageBodyReader<Book> delegate;
    @Inject
    @Read(context="reader")
    Event<String> readEvent;
    @Inject
    private Logger log;
    private ArrayList<Object> eventList = new ArrayList();

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        System.out.println("entering BookReader.isReadable()");
        boolean b = Book.class.equals(type);
        System.out.println("leaving BookReader.isReadable()");
        return b;
    }

    public Book readFrom(Class<Book> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        this.log.info("entering BookReader.readFrom()");
        Book book = (Book)Book.class.cast(delegate.readFrom(Book.class, genericType, annotations, mediaType, httpHeaders, entityStream));
        this.log.info("BookReader firing readEvent");
        this.readEvent.fire((Object)"readEvent");
        this.log.info("BookReader.readFrom() read " + book);
        this.log.info("leaving BookReader.readFrom()");
        return book;
    }

    public void readIntercept(@Observes @ReadIntercept String event) {
        this.eventList.add(event);
        this.log.info("BookReader.readIntercept() got " + event);
    }

    public void read(@Observes @Read(context="reader") String event) {
        this.eventList.add(event);
        this.log.info("BookReader.read() got " + event);
    }

    public void writeIntercept(@Observes @WriteIntercept String event) {
        this.eventList.add(event);
        this.log.info("BookReader.writeIntercept() got " + event);
    }

    public void write(@Observes @Write(context="writer") String event) {
        this.eventList.add(event);
        this.log.info("BookReader.write() got " + event);
    }

    public void process(@Observes @Process String event) {
        this.eventList.add(event);
        this.log.info("BookReader.process() got " + event);
    }

    public void processRead(@Observes @Process @Read(context="resource") String event) {
        this.eventList.add(event);
        this.log.info("BookReader.processRead() got " + event);
    }

    public void processWrite(@Observes @Process @Write(context="resource") String event) {
        this.eventList.add(event);
        this.log.info("BookReader.processWrite() got " + event);
    }

    public void unused(@Observes @Read(context="unused") @Write(context="unused") Unused event) {
        this.eventList.add(event);
        this.log.info("BookReader.unused() got " + event);
        throw new RuntimeException("BookReader.unused() got " + event);
    }

    public ArrayList<Object> getEventList() {
        return new ArrayList<Object>(this.eventList);
    }

    static {
        System.out.println("In BookReader static {}");
        ResteasyProviderFactory factory = ResteasyProviderFactory.getInstance();
        delegate = factory.getMessageBodyReader(Book.class, null, null, Constants.MEDIA_TYPE_TEST_XML_TYPE);
        System.out.println("In BookReader static {}");
    }
}

