/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.cdi.injection;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.EJB;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.New;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.cdi.injection.Book;
import org.jboss.resteasy.cdi.injection.BookBagLocal;
import org.jboss.resteasy.cdi.injection.BookCollection;
import org.jboss.resteasy.cdi.injection.BookReader;
import org.jboss.resteasy.cdi.injection.BookWriter;
import org.jboss.resteasy.cdi.injection.DependentScoped;
import org.jboss.resteasy.cdi.injection.JaxRsActivator;
import org.jboss.resteasy.cdi.injection.NewBean;
import org.jboss.resteasy.cdi.injection.ResourceBinding;
import org.jboss.resteasy.cdi.injection.ResourceProducer;
import org.jboss.resteasy.cdi.injection.StatefulEJB;
import org.jboss.resteasy.cdi.injection.StereotypedApplicationScope;
import org.jboss.resteasy.cdi.injection.StereotypedDependentScope;
import org.jboss.resteasy.cdi.injection.UnscopedResource;
import org.jboss.resteasy.cdi.util.Constants;
import org.jboss.resteasy.cdi.util.Counter;
import org.jboss.resteasy.cdi.util.CounterBinding;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

@Path(value="/")
@RequestScoped
public class BookResource {
    public static final String BOOK_READER = "BookReader";
    public static final String BOOK_WRITER = "BookWriter";
    public static final String BOOK_RESOURCE = "BookResource";
    public static final String BOOK_READER_DEPENDENT = "BookReaderDependent";
    public static final String BOOK_WRITER_DEPENDENT = "BookWriterDependent";
    public static final String BOOK_RESOURCE_DEPENDENT = "BookResourceDependent";
    public static final String BOOK_READER_STATEFUL = "BookReaderStateless";
    public static final String BOOK_WRITER_STATEFUL = "BookWriterStateless";
    public static final String BOOK_RESOURCE_STATEFUL = "BookResourceStateless";
    public static final String BOOK_RESOURCE_STATEFUL2 = "BookResourceStateless2";
    public static final String COUNTER = "counter";
    public static final String COLLECTION = "collection";
    public static final String BOOK_BAG = "bookBag";
    public static final String NEW_BEAN_APPLICATION_SCOPED = "newBeanApplicationScoped";
    public static final String NEW_BEAN_DEPENDENT_SCOPED = "newBeanDependentScoped";
    public static final String STEREOTYPED_APPLICATION_SCOPED = "stereotypedApplicationScoped";
    public static final String STEREOTYPED_DEPENDENT_SCOPED = "stereotypedDependentScoped";
    private static HashMap<String, Object> store;
    private HashSet<Book> set = new HashSet();
    private static AtomicInteger constructCounter;
    private static AtomicInteger destroyCounter;
    private static CountDownLatch latch;
    @Inject
    private BeanManager beanManager;
    @Inject
    private int secret;
    @Inject
    private DependentScoped dependent;
    @Inject
    @CounterBinding
    private Counter counter;
    @EJB
    private BookCollection collection;
    @EJB
    private StatefulEJB stateful;
    @Inject
    private StatefulEJB stateful2;
    @Inject
    private BookBagLocal bookBag;
    @Inject
    @ResourceBinding
    @PersistenceContext(unitName="test")
    EntityManager em;
    @Inject
    @ResourceBinding
    private Session session;
    @Inject
    @ResourceBinding
    private Queue bookQueue;
    @Inject
    private NewBean newBean1;
    @Inject
    @New
    private NewBean newBean2;
    @Inject
    private StereotypedApplicationScope stereotypeApplicationScoped;
    @Inject
    private StereotypedDependentScope stereotypedRequestScoped;
    private Logger log;

    public static HashMap<String, Object> getStore() {
        return store;
    }

    public static void setStore(HashMap<String, Object> store) {
        BookResource.store = store;
    }

    public HashSet<Book> getSet() {
        return this.set;
    }

    public void setSet(HashSet<Book> set) {
        this.set = set;
    }

    @PreDestroy
    public void preDestroy() {
        destroyCounter.incrementAndGet();
        this.log.info("preDestroy(): destroyCounter: " + destroyCounter.get());
    }

    @PostConstruct
    public void postConstruct() {
        constructCounter.incrementAndGet();
        this.log.info("postConstruct(): constructCounter: " + constructCounter.get());
    }

    public CountDownLatch getCountDownLatch() {
        this.log.info("latch.getCount(): " + latch.getCount());
        return latch;
    }

    @Inject
    public void init(Instance<Logger> logInstance) {
        this.log = (Logger)logInstance.get();
    }

    @GET
    @Path(value="verifyScopes")
    @Produces(value={"text/plain"})
    public Response verifyScopes() {
        this.log.info("entering verifyScopes()");
        ResteasyProviderFactory factory = ResteasyProviderFactory.getInstance();
        BookReader reader = (BookReader)BookReader.class.cast(factory.getMessageBodyReader(Book.class, null, null, Constants.MEDIA_TYPE_TEST_XML_TYPE));
        BookWriter writer = (BookWriter)BookWriter.class.cast(factory.getMessageBodyWriter(Book.class, null, null, Constants.MEDIA_TYPE_TEST_XML_TYPE));
        if (store == null) {
            this.log.info("Counter scope:          " + this.getScope(Counter.class));
            this.log.info("BookCollection scope:   " + this.getScope(BookCollection.class));
            this.log.info("BookResource scope:     " + this.getScope(BookResource.class));
            this.log.info("BookReader scope:       " + this.getScope(BookReader.class));
            this.log.info("BookWriter scope:       " + this.getScope(BookWriter.class));
            this.log.info("UnscopedResource scope: " + this.getScope(UnscopedResource.class));
            this.log.info("DependentScoped scope:  " + this.getScope(DependentScoped.class));
            this.log.info("StatelessEJB scope:     " + this.getScope(StatefulEJB.class));
            this.log.info("BookBagLocal scope:     " + this.getScope(BookBagLocal.class));
            this.log.info("NewBean scope:          " + this.getScope(NewBean.class));
            this.log.info("stereotypeApplicationScoped: " + this.getScope(StereotypedApplicationScope.class));
            this.log.info("stereotypeRequestScoped:     " + this.getScope(StereotypedDependentScope.class));
            store = new HashMap();
            store.put(BOOK_READER, reader);
            store.put(BOOK_WRITER, writer);
            store.put(BOOK_RESOURCE, this);
            store.put(BOOK_READER_DEPENDENT, reader.getDependent());
            store.put(BOOK_WRITER_DEPENDENT, writer.getDependent());
            store.put(BOOK_RESOURCE_DEPENDENT, this.dependent);
            store.put(BOOK_READER_STATEFUL, reader.getStateful());
            store.put(BOOK_WRITER_STATEFUL, writer.getStateful());
            store.put(BOOK_RESOURCE_STATEFUL, this.stateful);
            store.put(BOOK_RESOURCE_STATEFUL2, this.stateful2);
            store.put(COUNTER, this.counter);
            store.put(COLLECTION, this.collection);
            store.put(BOOK_BAG, this.bookBag);
            store.put(NEW_BEAN_APPLICATION_SCOPED, this.newBean1);
            store.put(NEW_BEAN_DEPENDENT_SCOPED, this.newBean2);
            store.put(STEREOTYPED_APPLICATION_SCOPED, this.stereotypeApplicationScoped);
            store.put(STEREOTYPED_DEPENDENT_SCOPED, this.stereotypedRequestScoped);
            return Response.ok().build();
        }
        if (this.isApplicationScoped(Counter.class) && this.isApplicationScoped(BookCollection.class) && this.isApplicationScoped(BookReader.class) && this.isApplicationScoped(BookWriter.class) && this.isRequestScoped(BookResource.class) && this.isDependentScoped(DependentScoped.class) && this.isDependentScoped(StatefulEJB.class) && this.isRequestScoped(UnscopedResource.class) && this.isApplicationScoped(JaxRsActivator.class) && this.isSessionScoped(BookBagLocal.class) && this.isApplicationScoped(NewBean.class) && this.isApplicationScoped(StereotypedApplicationScope.class) && this.isDependentScoped(StereotypedDependentScope.class) && store.get(BOOK_READER) == reader && store.get(BOOK_WRITER) == writer && store.get(BOOK_RESOURCE) != this && store.get(BOOK_READER_DEPENDENT) == reader.getDependent() && store.get(BOOK_WRITER_DEPENDENT) == writer.getDependent() && store.get(BOOK_RESOURCE_DEPENDENT) != this.dependent && store.get(BOOK_READER_STATEFUL).equals(reader.getStateful()) && store.get(BOOK_WRITER_STATEFUL).equals(writer.getStateful()) && !store.get(BOOK_RESOURCE_STATEFUL).equals(this.stateful) && !store.get(BOOK_RESOURCE_STATEFUL2).equals(this.stateful2) && store.get(COUNTER).equals(this.counter) && store.get(COLLECTION).equals(this.collection) && store.get(BOOK_BAG).equals(this.bookBag) && store.get(NEW_BEAN_APPLICATION_SCOPED).equals(this.newBean1) && !store.get(NEW_BEAN_DEPENDENT_SCOPED).equals(this.newBean2) && !this.newBean1.equals(this.newBean2) && store.get(STEREOTYPED_APPLICATION_SCOPED).equals(this.stereotypeApplicationScoped) && !store.get(STEREOTYPED_DEPENDENT_SCOPED).equals(this.stereotypedRequestScoped)) {
            return Response.ok().build();
        }
        return Response.serverError().build();
    }

    @POST
    @Path(value="empty")
    public void empty() {
        this.collection.empty();
    }

    @POST
    @Path(value="create")
    @Consumes(value={"application/test+xml"})
    @Produces(value={"text/plain"})
    public Response createBook(Book book) {
        this.log.info("entering createBook()");
        int id = this.counter.getNext();
        book.setId(id);
        this.collection.addBook(book);
        this.log.info("stored: " + id + "->" + book);
        return Response.ok((Object)id).build();
    }

    @GET
    @Produces(value={"application/xml"})
    @Path(value="books")
    public Collection<Book> listAllMembers() {
        this.log.info("entering listAllMembers()");
        this.log.info("this.theSecret(): " + this.theSecret());
        Collection<Book> books = this.collection.getBooks();
        this.log.info("listAllMembers(): " + books);
        return books;
    }

    @GET
    @Path(value="book/{id:[0-9][0-9]*}")
    @Produces(value={"application/test+xml"})
    public Book lookupBookById(@PathParam(value="id") int id) {
        this.log.info("entering lookupBookById(" + id + ")");
        this.log.info("books: " + this.collection.getBooks());
        Book book = this.collection.getBook(id);
        if (book == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        return book;
    }

    @POST
    @Path(value="entityManager")
    public Response testEntityManager() {
        this.log.info("entering testEntityManager()");
        Book book1 = this.collection.getBook(17);
        Book book2 = (Book)this.em.find(Book.class, (Object)17);
        return book1.equals(book2) ? Response.ok().build() : Response.serverError().build();
    }

    @POST
    @Path(value="session/add")
    public Response sessionAdd(@Context HttpServletRequest request, Book book) {
        this.log.info("entering sessionAdd()");
        this.log.info("new session: " + request.getSession().isNew());
        this.bookBag.addBook(book);
        return Response.ok().build();
    }

    @GET
    @Path(value="session/get")
    @Produces(value={"application/xml"})
    public Collection<Book> sessionGetBag(@Context HttpServletRequest request) {
        this.log.info("entering sessionGetBag()");
        this.log.info("new session: " + request.getSession().isNew());
        Collection<Book> books = this.bookBag.getContents();
        this.log.info("sessionGetBag(): " + books);
        request.getSession().invalidate();
        return books;
    }

    @POST
    @Path(value="session/test")
    public Response sessionTest(@Context HttpServletRequest request) {
        this.log.info("entering sessionTest()");
        this.log.info("new session: " + request.getSession().isNew());
        Collection<Book> contents = this.bookBag.getContents();
        this.log.info("bookBag: " + contents);
        if (request.getSession().isNew() && contents.isEmpty()) {
            return Response.ok().build();
        }
        return Response.serverError().build();
    }

    @GET
    @Path(value="mdb/get")
    @Produces(value={"application/xml"})
    public GenericEntity<Collection<Book>> mdbGetBag() {
        this.log.info("entering mdbGetBag()");
        Collection<Book> books = this.bookBag.getContents();
        this.log.info("sessionGetBag(): " + books);
        return new GenericEntity<Collection<Book>>(books){};
    }

    @GET
    @Path(value="getCounters")
    public String getCounters() {
        return Integer.toString(constructCounter.get()) + ":" + Integer.toString(destroyCounter.get()) + ":";
    }

    @GET
    @Path(value="disposer")
    public Response testDisposer() {
        this.log.info("entering testDisposer()");
        return ResourceProducer.isDisposed() ? Response.ok().build() : Response.serverError().build();
    }

    @POST
    @Path(value="produceMessage")
    @Consumes(value={"application/test+xml"})
    @Produces(value={"text/plain"})
    public Response produceBookMessage(Book book) {
        this.log.info("entering produceBookMessage()");
        try {
            this.log.info("queue: " + this.bookQueue);
            this.log.info("ResourceProducer scope: " + this.getScope(ResourceProducer.class));
            this.log.info("queue scope: " + this.getScope(Queue.class));
            MessageProducer producer = this.session.createProducer((Destination)this.bookQueue);
            TextMessage message = this.session.createTextMessage(book.getName());
            producer.setDeliveryMode(1);
            producer.send((Message)message);
            this.log.info("sent: " + message.getText());
            return Response.ok().build();
        }
        catch (JMSException e) {
            e.printStackTrace();
            return Response.serverError().entity((Object)("JMS error: " + e.getMessage())).build();
        }
    }

    @GET
    @Path(value="queue/consumeMessage")
    @Produces(value={"text/plain"})
    public Response consumeBookMessageFromQueue() {
        this.log.info("entering consumeBookMessageFromQueue() xxx");
        this.log.info("getting consumer");
        try {
            MessageConsumer consumer = this.session.createConsumer((Destination)this.bookQueue);
            this.log.info("got consumer");
            TextMessage message = (TextMessage)consumer.receiveNoWait();
            this.log.info("message: " + message);
            if (message == null) {
                return Response.serverError().build();
            }
            this.log.info("message text: " + message.getText());
            return Response.ok((Object)message.getText()).build();
        }
        catch (JMSException e) {
            return Response.serverError().entity((Object)("JMS error: " + e.getMessage())).build();
        }
    }

    @GET
    @Path(value="mdb/consumeMessage")
    @Produces(value={"text/plain"})
    public Response consumeBookMessageFromMDB() throws InterruptedException {
        this.log.info("entering consumeBookMessageFromMDB()");
        this.getCountDownLatch().await(5000L, TimeUnit.MILLISECONDS);
        BookCollection collection = this.getBookCollection();
        this.log.info("consumeBookMessageFromMDB(): collection.size(): " + collection.getBooks().size());
        if (collection.getBooks().size() == 1) {
            String name = collection.getBooks().iterator().next().getName();
            this.log.info("got book name: " + name);
            return Response.ok((Object)name).build();
        }
        return Response.serverError().entity((Object)("Collection size: " + collection.getBooks().size())).build();
    }

    @GET
    @Produces(value={"application/xml"})
    @Path(value="mdb/books")
    public Collection<Book> getBooksMDB() throws InterruptedException {
        this.log.info("entering getBooksMDB()");
        this.log.info("getBooksMDB(): waiting on latch");
        latch.await();
        this.log.info("this.theSecret(): " + this.theSecret());
        Collection<Book> books = this.collection.getBooks();
        this.log.info("getBooksMDB(): " + books);
        return books;
    }

    BookCollection getBookCollection() {
        this.log.info("entering getBookCollection()");
        return this.collection;
    }

    Counter getCounter() {
        this.log.info("returning: " + this.counter);
        return this.counter;
    }

    boolean isApplicationScoped(Class<?> c) {
        return this.testScope(c, ApplicationScoped.class);
    }

    boolean isDependentScoped(Class<?> c) {
        return this.testScope(c, Dependent.class);
    }

    boolean isRequestScoped(Class<?> c) {
        return this.testScope(c, RequestScoped.class);
    }

    boolean isSessionScoped(Class<?> c) {
        return this.testScope(c, SessionScoped.class);
    }

    boolean testScope(Class<?> c, Class<?> scopeClass) {
        Class<? extends Annotation> annotation = this.getScope(c);
        if (annotation == null) {
            return false;
        }
        return annotation.isAssignableFrom(scopeClass);
    }

    Class<? extends Annotation> getScope(Class<?> c) {
        Set beans = this.beanManager.getBeans(c, new Annotation[0]);
        Iterator it = beans.iterator();
        if (it.hasNext()) {
            Bean bean = (Bean)beans.iterator().next();
            return bean.getScope();
        }
        return null;
    }

    public boolean theSame(BookResource that) {
        return this.secret == that.secret;
    }

    public int theSecret() {
        return this.secret;
    }

    static {
        constructCounter = new AtomicInteger();
        destroyCounter = new AtomicInteger();
        latch = new CountDownLatch(2);
    }
}

