/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.cdi.interceptors;

import java.io.Serializable;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Logger;
import javax.annotation.Resource;
import javax.ejb.SessionContext;
import javax.ejb.Stateless;
import javax.ejb.Timeout;
import javax.ejb.Timer;
import javax.ejb.TimerService;
import javax.inject.Inject;
import javax.interceptor.AroundTimeout;
import javax.interceptor.InvocationContext;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.cdi.interceptors.TimerInterceptorResourceIntf;

@Path(value="timer")
@Stateless
public class TimerInterceptorResource
implements TimerInterceptorResourceIntf {
    private static final String TIMER_INFO = "timerInfo";
    private static CountDownLatch latch = new CountDownLatch(1);
    private static boolean timerExpired;
    private static boolean timerInterceptorInvoked;
    @Inject
    private Logger log;
    @Resource
    private SessionContext ctx;
    private TimerService timerService;

    @Override
    @GET
    @Path(value="schedule")
    public Response scheduleTimer() {
        this.log.info("entering scheduleTimer()");
        this.timerService = this.ctx.getTimerService();
        if (this.timerService != null) {
            this.timerService.createTimer(1000L, (Serializable)((Object)TIMER_INFO));
            this.log.info("timer scheduled");
            return Response.ok().build();
        }
        return Response.serverError().build();
    }

    @Override
    @GET
    @Path(value="test")
    public Response testTimer() throws InterruptedException {
        this.log.info("entering testTimer()");
        latch.await();
        if (!timerInterceptorInvoked) {
            return Response.serverError().entity((Object)"timerInterceptorInvoked == false").build();
        }
        if (!timerExpired) {
            return Response.serverError().entity((Object)"timerExpired == false").build();
        }
        return Response.ok().build();
    }

    @Override
    @Timeout
    public void timeout(Timer timer) {
        this.log.info("entering timeout()");
        if (TIMER_INFO.equals(timer.getInfo())) {
            timerExpired = true;
            latch.countDown();
        }
    }

    @AroundTimeout
    public Object aroundTimeout(InvocationContext ctx) throws Exception {
        timerInterceptorInvoked = true;
        this.log.info("aroundTimeout() invoked");
        return ctx.proceed();
    }
}

