/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.cdi.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.ejb.Singleton;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.NormalScope;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import javax.inject.Qualifier;
import org.jboss.resteasy.cdi.extension.bean.Boston;

@Singleton
public class Utilities {
    @Inject
    private BeanManager beanManager;

    public boolean isApplicationScoped(Class<?> c) {
        return this.testScope(c, ApplicationScoped.class);
    }

    public boolean isDependentScoped(Class<?> c) {
        return this.testScope(c, Dependent.class);
    }

    public boolean isRequestScoped(Class<?> c) {
        return this.testScope(c, RequestScoped.class);
    }

    public boolean isSessionScoped(Class<?> c) {
        return this.testScope(c, SessionScoped.class);
    }

    public boolean testScope(Class<?> c, Class<?> scopeClass) {
        Class<? extends Annotation> annotation = this.getScope(c);
        if (annotation == null) {
            return false;
        }
        return annotation.isAssignableFrom(scopeClass);
    }

    public Class<? extends Annotation> getScope(Class<?> c) {
        Iterator it;
        Set beans = this.beanManager.getBeans(c, new Annotation[0]);
        if (beans != null && !beans.isEmpty() && (it = beans.iterator()).hasNext()) {
            Bean bean = (Bean)beans.iterator().next();
            return bean.getScope();
        }
        return null;
    }

    public static Class<? extends Annotation> getScopeAnnotation(Class<?> c) {
        return Utilities.getScopeAnnotation(c.getAnnotations());
    }

    public static Class<? extends Annotation> getScopeAnnotation(Annotation[] annotations) {
        for (int i = 0; i < annotations.length; ++i) {
            Class<? extends Annotation> annotationType = annotations[i].annotationType();
            Annotation[] typeAnnotations = annotationType.getAnnotations();
            for (int j = 0; j < typeAnnotations.length; ++j) {
                if (!NormalScope.class.equals(typeAnnotations[j].annotationType())) continue;
                return annotationType;
            }
        }
        return null;
    }

    public static Class<? extends Annotation> getScopeAnnotation(Set<Annotation> annotations) {
        for (Annotation annotation : annotations) {
            Class<? extends Annotation> annotationType = annotation.annotationType();
            Annotation[] typeAnnotations = annotationType.getAnnotations();
            for (int j = 0; j < typeAnnotations.length; ++j) {
                if (!NormalScope.class.equals(typeAnnotations[j].annotationType())) continue;
                return annotationType;
            }
        }
        return null;
    }

    public static Set<Annotation> getQualifiers(Class<?> clazz) {
        return Utilities.getQualifiers(clazz.getAnnotations());
    }

    public static Set<Annotation> getQualifiers(Annotation[] annotations) {
        HashSet<Annotation> result = new HashSet<Annotation>();
        block0: for (int i = 0; i < annotations.length; ++i) {
            Class<? extends Annotation> annotationType = annotations[i].annotationType();
            Annotation[] typeAnnotations = annotationType.getAnnotations();
            for (int j = 0; j < typeAnnotations.length; ++j) {
                if (!Qualifier.class.equals(typeAnnotations[j].annotationType())) continue;
                result.add(annotations[i]);
                continue block0;
            }
        }
        return result;
    }

    public static boolean hasQualifier(Class<?> clazz, Class<?> qualifier) {
        Annotation[] annotations = clazz.getAnnotations();
        for (int i = 0; i < annotations.length; ++i) {
            if (!qualifier.equals(annotations[i].annotationType())) continue;
            return true;
        }
        return false;
    }

    public static boolean hasQualifier(Set<Annotation> annotations, Class<?> qualifier) {
        for (Annotation annotation : annotations) {
            if (!qualifier.equals(annotation.annotationType())) continue;
            return true;
        }
        return false;
    }

    public static boolean isBoston(Class<?> clazz) {
        return Utilities.hasQualifier(clazz, Boston.class);
    }

    public static Set<Type> getTypeClosure(Class<?> clazz) {
        HashSet<Type> set = new HashSet<Type>();
        Utilities.accumulateTypes(set, clazz);
        return set;
    }

    static void accumulateTypes(Set<Type> set, Class<?> clazz) {
        set.add(clazz);
        if (clazz.getSuperclass() != null) {
            Utilities.accumulateTypes(set, clazz.getSuperclass());
        }
        for (Class<?> c : clazz.getInterfaces()) {
            Utilities.accumulateTypes(set, c);
        }
    }

    public static Set<Annotation> getAnnotationSet(Class<?> clazz) {
        return new HashSet<Annotation>(Arrays.asList(clazz.getAnnotations()));
    }

    public static boolean isAnnotationPresent(Class<?> clazz, Class<? extends Annotation> annotationType) {
        for (Annotation annotation : clazz.getAnnotations()) {
            if (!annotation.annotationType().equals(annotationType)) continue;
            return true;
        }
        return false;
    }

    public static <T extends Annotation> T getAnnotation(Class<?> clazz, Class<T> annotationType) {
        for (Annotation annotation : clazz.getAnnotations()) {
            if (!annotation.annotationType().equals(annotationType)) continue;
            return (T)annotation;
        }
        return null;
    }
}

