/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.security.doseta;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Priority;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Provider;
import javax.ws.rs.ext.WriterInterceptor;
import javax.ws.rs.ext.WriterInterceptorContext;
import org.jboss.resteasy.annotations.interception.DecoderPrecedence;
import org.jboss.resteasy.client.ClientResponse;
import org.jboss.resteasy.security.doseta.DKIMSignature;
import org.jboss.resteasy.security.doseta.KeyRepository;
import org.jboss.resteasy.security.doseta.i18n.LogMessages;
import org.jboss.resteasy.security.doseta.i18n.Messages;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.spi.interception.ClientExecutionContext;
import org.jboss.resteasy.spi.interception.ClientExecutionInterceptor;

@Provider
@DecoderPrecedence
@Priority(value=4000)
public class DigitalSigningInterceptor
implements WriterInterceptor,
ClientExecutionInterceptor,
ContainerResponseFilter,
ClientRequestFilter {
    protected List<DKIMSignature> getHeaders(MultivaluedMap<String, Object> headers) {
        ArrayList<DKIMSignature> list = new ArrayList<DKIMSignature>();
        List signatures = (List)headers.get((Object)"DKIM-Signature");
        if (signatures == null || signatures.isEmpty()) {
            return list;
        }
        for (Object obj : signatures) {
            if (!(obj instanceof DKIMSignature)) continue;
            list.add((DKIMSignature)obj);
        }
        return list;
    }

    public void filter(ClientRequestContext requestContext) throws IOException {
        if (requestContext.hasEntity()) {
            return;
        }
        MultivaluedMap headers = requestContext.getHeaders();
        List<DKIMSignature> list = this.getHeaders((MultivaluedMap<String, Object>)headers);
        for (DKIMSignature dosetaSignature : list) {
            KeyRepository repository = (KeyRepository)requestContext.getProperty(KeyRepository.class.getName());
            try {
                this.sign(repository, (MultivaluedMap<String, Object>)headers, null, dosetaSignature);
            }
            catch (Exception e) {
                throw new ProcessingException((Throwable)e);
            }
        }
    }

    public ClientResponse execute(ClientExecutionContext context) throws Exception {
        if (context.getRequest().getBody() != null) {
            return context.proceed();
        }
        MultivaluedMap headers = context.getRequest().getHeadersAsObjects();
        List<DKIMSignature> list = this.getHeaders((MultivaluedMap<String, Object>)headers);
        for (DKIMSignature dosetaSignature : list) {
            KeyRepository repository = (KeyRepository)context.getRequest().getAttributes().get(KeyRepository.class.getName());
            this.sign(repository, (MultivaluedMap<String, Object>)headers, null, dosetaSignature);
        }
        return context.proceed();
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        if (responseContext.getEntity() != null) {
            return;
        }
        MultivaluedMap headers = responseContext.getHeaders();
        List<DKIMSignature> list = this.getHeaders((MultivaluedMap<String, Object>)headers);
        for (DKIMSignature dosetaSignature : list) {
            try {
                this.sign(null, (MultivaluedMap<String, Object>)headers, null, dosetaSignature);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void aroundWriteTo(WriterInterceptorContext context) throws IOException, WebApplicationException {
        LogMessages.LOGGER.debugf("Interceptor : %s,  Method : aroundWriteTo", this.getClass().getName());
        MultivaluedMap headers = context.getHeaders();
        List<DKIMSignature> list = this.getHeaders((MultivaluedMap<String, Object>)headers);
        if (list.isEmpty()) {
            context.proceed();
            return;
        }
        OutputStream old = context.getOutputStream();
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            context.setOutputStream((OutputStream)baos);
            context.proceed();
            byte[] body = baos.toByteArray();
            for (DKIMSignature dosetaSignature : list) {
                KeyRepository repository = (KeyRepository)context.getProperty(KeyRepository.class.getName());
                this.sign(repository, (MultivaluedMap<String, Object>)headers, body, dosetaSignature);
            }
            old.write(body);
        }
        catch (Exception e) {
            throw new RuntimeException(Messages.MESSAGES.failedToSign(), e);
        }
        finally {
            context.setOutputStream(old);
        }
    }

    protected void sign(KeyRepository repository, MultivaluedMap<String, Object> headers, byte[] body, DKIMSignature dosetaSignature) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException, UnsupportedEncodingException {
        if (dosetaSignature.getBased64Signature() != null) {
            return;
        }
        PrivateKey privateKey = dosetaSignature.getPrivateKey();
        if (privateKey == null) {
            if (repository == null) {
                repository = (KeyRepository)ResteasyProviderFactory.getContextData(KeyRepository.class);
            }
            if (repository == null) {
                throw new InvalidKeyException(Messages.MESSAGES.unableToLocatePrivateKey());
            }
            privateKey = repository.findPrivateKey(dosetaSignature);
            if (privateKey == null) {
                throw new InvalidKeyException(Messages.MESSAGES.unableToFindKey());
            }
        }
        dosetaSignature.sign((Map)headers, body, privateKey);
    }
}

