/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.standardutils.collections;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import se.unlogic.standardutils.collections.KeyAlreadyCachedException;
import se.unlogic.standardutils.collections.KeyNotCachedException;
import se.unlogic.standardutils.collections.StrictMap;

public class StrictHashMap<Key, Value>
implements StrictMap<Key, Value> {
    HashMap<Key, Value> hashMap = new HashMap();

    @Override
    public Value put(Key key, Value value) throws KeyAlreadyCachedException {
        if (this.hashMap.containsKey(key)) {
            throw new KeyAlreadyCachedException(key);
        }
        return this.hashMap.put(key, value);
    }

    @Override
    public Value update(Key key, Value value) throws KeyNotCachedException {
        if (this.hashMap.containsKey(key)) {
            this.hashMap.remove(key);
            return this.hashMap.put(key, value);
        }
        throw new KeyNotCachedException(key);
    }

    @Override
    public Value remove(Object key) throws KeyNotCachedException {
        if (this.hashMap.containsKey(key)) {
            return this.hashMap.remove(key);
        }
        throw new KeyNotCachedException(key);
    }

    @Override
    public void clear() {
        this.hashMap.clear();
    }

    public Object clone() {
        return this.hashMap.clone();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.hashMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.hashMap.containsValue(value);
    }

    @Override
    public Set<Map.Entry<Key, Value>> entrySet() {
        return this.hashMap.entrySet();
    }

    @Override
    public boolean equals(Object o) {
        return this.hashMap.equals(o);
    }

    @Override
    public Value get(Object key) {
        return this.hashMap.get(key);
    }

    @Override
    public int hashCode() {
        return this.hashMap.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.hashMap.isEmpty();
    }

    @Override
    public Set<Key> keySet() {
        return this.hashMap.keySet();
    }

    @Override
    public int size() {
        return this.hashMap.size();
    }

    public String toString() {
        return this.hashMap.toString();
    }

    @Override
    public Collection<Value> values() {
        return this.hashMap.values();
    }

    @Override
    public void putAll(Map<? extends Key, ? extends Value> map) throws KeyAlreadyCachedException {
        for (Map.Entry<Key, Value> entry : map.entrySet()) {
            if (!this.hashMap.containsKey(entry.getKey())) continue;
            throw new KeyAlreadyCachedException(entry.getKey());
        }
        this.hashMap.putAll(map);
    }
}

