/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.standardutils.json;

import se.unlogic.standardutils.json.JsonNode;
import se.unlogic.standardutils.numbers.NumberUtils;

public class JsonLeaf
implements JsonNode {
    private static final long serialVersionUID = 1198871458505471824L;
    private String value;

    public JsonLeaf(String value) {
        this.value = value;
    }

    @Override
    public String toJson() {
        return this.toJson(new StringBuilder());
    }

    @Override
    public String toJson(StringBuilder stringBuilder) {
        if (this.value == null) {
            return stringBuilder.append("null").toString();
        }
        if (NumberUtils.isNumber(this.value)) {
            stringBuilder.append(this.value);
        } else if (this.value.equals("false")) {
            stringBuilder.append(false);
        } else if (this.value.equals("true")) {
            stringBuilder.append(true);
        } else {
            stringBuilder.append("\"");
            stringBuilder.append(this.value);
            stringBuilder.append("\"");
        }
        return stringBuilder.toString();
    }
}

