/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.standardutils.populators;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.SQLException;
import se.unlogic.standardutils.dao.BeanResultSetPopulator;
import se.unlogic.standardutils.dao.querys.PreparedStatementQuery;
import se.unlogic.standardutils.enums.EnumUtils;
import se.unlogic.standardutils.populators.BaseStringPopulator;
import se.unlogic.standardutils.populators.BeanStringPopulator;
import se.unlogic.standardutils.populators.QueryParameterPopulator;
import se.unlogic.standardutils.reflection.ReflectionUtils;
import se.unlogic.standardutils.string.StringUtils;

public class EnumPopulator<EnumType extends Enum<EnumType>>
extends BaseStringPopulator<EnumType>
implements BeanResultSetPopulator<EnumType>,
BeanStringPopulator<EnumType>,
QueryParameterPopulator<EnumType> {
    protected Class<EnumType> classType;
    protected String fieldName;

    public EnumPopulator(Class<EnumType> classType) {
        this.checkClass(classType);
        this.fieldName = classType.getSimpleName();
    }

    public EnumPopulator(Class<EnumType> classType, String fieldName) {
        this.checkClass(classType);
        if (StringUtils.isEmpty(fieldName)) {
            throw new NullPointerException("fieldName can not be null or empty!");
        }
        this.fieldName = fieldName;
    }

    private void checkClass(Class<EnumType> classType) {
        if (classType == null) {
            throw new NullPointerException("Classtype can not be null!");
        }
        this.classType = classType;
    }

    @Override
    public EnumType populate(ResultSet rs) throws SQLException {
        return EnumUtils.toEnum(this.classType, rs.getString(1));
    }

    @Override
    public EnumType getValue(String value) {
        return EnumUtils.toEnum(this.classType, value);
    }

    @Override
    public boolean validateDefaultFormat(String value) {
        return EnumUtils.isEnum(this.classType, value);
    }

    @Override
    public Class<? extends EnumType> getType() {
        return this.classType;
    }

    @Override
    public void populate(PreparedStatementQuery query, int paramIndex, Object bean) throws SQLException {
        if (bean != null) {
            query.setString(paramIndex, bean.toString());
        } else {
            query.setString(paramIndex, null);
        }
    }

    public static <Type extends Enum<Type>> EnumPopulator<Type> getGenericInstance(Class<Type> type) {
        return new EnumPopulator<Type>(type);
    }

    public static EnumPopulator<?> getInstanceFromField(Field field) {
        Enum<?> enumInstance = EnumUtils.getInstanceFromField(field);
        return EnumPopulator.getGenericInstance(enumInstance.getClass());
    }

    public static EnumPopulator<?> getInstanceFromListField(Field field) {
        T[] enumValues = ((Class)ReflectionUtils.getGenericType(field)).getEnumConstants();
        Enum enumInstance = (Enum)enumValues[0];
        return EnumPopulator.getGenericInstance(enumInstance.getClass());
    }

    public static EnumPopulator<?> getInstanceFromMethod(Method method) {
        ?[] enumValues = method.getParameterTypes()[0].getEnumConstants();
        Enum enumInstance = (Enum)enumValues[0];
        return EnumPopulator.getGenericInstance(enumInstance.getClass());
    }

    public static BeanStringPopulator<?> getInstanceFromListMethod(Method method) {
        T[] enumValues = ((Class)ReflectionUtils.getGenericType(method)).getEnumConstants();
        Enum enumInstance = (Enum)enumValues[0];
        return EnumPopulator.getGenericInstance(enumInstance.getClass());
    }
}

