/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.eagledns.zoneproviders.db.beans;

import java.io.IOException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xbill.DNS.DClass;
import org.xbill.DNS.Name;
import org.xbill.DNS.RRset;
import org.xbill.DNS.Record;
import org.xbill.DNS.SOARecord;
import org.xbill.DNS.Zone;
import se.unlogic.eagledns.zoneproviders.db.beans.DBRecord;
import se.unlogic.standardutils.dao.annotations.DAOManaged;
import se.unlogic.standardutils.dao.annotations.Key;
import se.unlogic.standardutils.dao.annotations.OneToMany;
import se.unlogic.standardutils.dao.annotations.Table;
import se.unlogic.standardutils.xml.Elementable;
import se.unlogic.standardutils.xml.XMLElement;
import se.unlogic.standardutils.xml.XMLGenerator;

@XMLElement
@Table(name="zones")
public class DBZone
implements Elementable {
    @DAOManaged(autoGenerated=true)
    @Key
    @XMLElement
    private Integer zoneID;
    @DAOManaged
    @XMLElement
    private String name;
    @DAOManaged
    @XMLElement
    private String dclass;
    @DAOManaged
    @XMLElement
    private Long ttl;
    @DAOManaged
    @XMLElement
    private String primaryDNS;
    @DAOManaged
    @XMLElement
    private String adminEmail;
    @DAOManaged
    @XMLElement
    private Long serial;
    @DAOManaged
    @XMLElement
    private Long refresh;
    @DAOManaged
    @XMLElement
    private Long retry;
    @DAOManaged
    @XMLElement
    private Long expire;
    @DAOManaged
    @XMLElement
    private Long minimum;
    @DAOManaged
    @OneToMany
    @XMLElement
    private List<DBRecord> records;
    @DAOManaged
    @XMLElement
    private boolean secondary;
    @DAOManaged
    @XMLElement
    private Timestamp downloaded;

    public DBZone() {
    }

    public DBZone(Zone zone, boolean secondary) {
        this.parse(zone, secondary);
    }

    public void parse(Zone zone, boolean secondary) {
        if (zone == null) {
            this.ttl = null;
            this.adminEmail = null;
            this.serial = null;
            this.refresh = null;
            this.retry = null;
            this.expire = null;
            this.minimum = null;
            this.records = null;
            this.downloaded = null;
        } else {
            SOARecord soaRecord = zone.getSOA();
            this.name = soaRecord.getName().toString();
            this.dclass = DClass.string((int)soaRecord.getDClass());
            this.ttl = soaRecord.getTTL();
            this.primaryDNS = soaRecord.getHost().toString();
            this.adminEmail = soaRecord.getAdmin().toString();
            this.serial = soaRecord.getSerial();
            this.refresh = soaRecord.getRefresh();
            this.retry = soaRecord.getRetry();
            this.expire = soaRecord.getExpire();
            this.minimum = soaRecord.getMinimum();
            this.secondary = secondary;
            if (secondary) {
                this.downloaded = new Timestamp(System.currentTimeMillis());
            }
            this.records = new ArrayList<DBRecord>();
            for (RRset rRset : zone) {
                Iterator rrSetIterator = rRset.rrs();
                while (rrSetIterator.hasNext()) {
                    Record record = (Record)rrSetIterator.next();
                    if (record.getType() == 6) continue;
                    this.records.add(new DBRecord(record, zone.getSOA().getName(), this.ttl));
                }
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDclass() {
        return this.dclass;
    }

    public void setDclass(String dclass) {
        this.dclass = dclass;
    }

    public Long getTtl() {
        return this.ttl;
    }

    public void setTtl(Long ttl) {
        this.ttl = ttl;
    }

    public String getPrimaryDNS() {
        return this.primaryDNS;
    }

    public void setPrimaryDNS(String primaryDns) {
        this.primaryDNS = primaryDns;
    }

    public String getAdminEmail() {
        return this.adminEmail;
    }

    public void setAdminEmail(String adminEmail) {
        this.adminEmail = adminEmail;
    }

    public Long getSerial() {
        return this.serial;
    }

    public void setSerial(Long serial) {
        this.serial = serial;
    }

    public Long getRefresh() {
        return this.refresh;
    }

    public void setRefresh(Long refresh) {
        this.refresh = refresh;
    }

    public Long getRetry() {
        return this.retry;
    }

    public void setRetry(Long retry) {
        this.retry = retry;
    }

    public Long getExpire() {
        return this.expire;
    }

    public void setExpire(Long expire) {
        this.expire = expire;
    }

    public Long getMinimum() {
        return this.minimum;
    }

    public void setMinimum(Long minimum) {
        this.minimum = minimum;
    }

    public List<DBRecord> getRecords() {
        return this.records;
    }

    public void setRecords(List<DBRecord> records) {
        this.records = records;
    }

    public Integer getZoneID() {
        return this.zoneID;
    }

    public void setZoneID(Integer zoneID) {
        this.zoneID = zoneID;
    }

    @Override
    public Element toXML(Document doc) {
        return XMLGenerator.toXML(this, doc);
    }

    public Zone toZone() throws IOException {
        Name zoneName = Name.fromString((String)this.name);
        Name primaryNS = Name.fromString((String)this.primaryDNS);
        SOARecord soaRecord = new SOARecord(zoneName, DClass.value((String)this.dclass), this.ttl.longValue(), primaryNS, Name.fromString((String)this.adminEmail), this.serial.longValue(), this.refresh.longValue(), this.retry.longValue(), this.expire.longValue(), this.minimum.longValue());
        int recordCount = this.records != null ? 1 + this.records.size() : 1;
        Record[] recordArray = new Record[recordCount];
        recordArray[0] = soaRecord;
        if (this.records != null) {
            int pos = 1;
            for (DBRecord record : this.records) {
                recordArray[pos] = record.getRecord(this.ttl, zoneName);
                ++pos;
            }
        }
        return new Zone(zoneName, recordArray);
    }

    public boolean isSecondary() {
        return this.secondary;
    }

    public void setSecondary(boolean secondary) {
        this.secondary = secondary;
    }

    public String toString() {
        return this.name + " (ID: " + this.zoneID + ")";
    }

    public Timestamp getDownloaded() {
        return this.downloaded;
    }

    public void setDownloaded(Timestamp zoneDownloaded) {
        this.downloaded = zoneDownloaded;
    }
}

