/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.embedded.test.core.basic;

import dev.resteasy.junit.extension.annotations.RequestPath;
import dev.resteasy.junit.extension.annotations.RestBootstrap;
import jakarta.inject.Inject;
import jakarta.ws.rs.ApplicationPath;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Application;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import java.util.Set;
import org.jboss.resteasy.embedded.test.core.basic.resource.ApplicationTestResourceB;
import org.jboss.resteasy.embedded.test.core.basic.resource.ApplicationTestSingletonB;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@RestBootstrap(value=ApplicationTestBExplicitApplication.class)
public class ApplicationExplicitBTest {
    private static final String CONTENT_ERROR_MESSAGE = "Wrong content of response";
    @Inject
    private Client client;

    @Test
    @Inject
    public void testExplicitB(@RequestPath(value="/b/explicit") URI uri) {
        WebTarget base = this.client.target(uri);
        String value = (String)base.path("resources/b").request().get(String.class);
        Assertions.assertEquals((Object)"b", (Object)value, (String)CONTENT_ERROR_MESSAGE);
        Response response = base.path("resources/a").request().get();
        Assertions.assertEquals((int)404, (int)response.getStatus());
        value = (String)base.path("singletons/b").request().get(String.class);
        Assertions.assertEquals((Object)"b", (Object)value, (String)CONTENT_ERROR_MESSAGE);
        response = base.path("singletons/a").request().get();
        Assertions.assertEquals((int)404, (int)response.getStatus());
    }

    @ApplicationPath(value="b/explicit")
    public static class ApplicationTestBExplicitApplication
    extends Application {
        public Set<Class<?>> getClasses() {
            return Set.of(ApplicationTestResourceB.class);
        }

        public Set<Object> getSingletons() {
            return Set.of(new ApplicationTestSingletonB());
        }
    }
}

