/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.guice;

import com.google.inject.Provider;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.InjectorFactory;
import org.jboss.resteasy.spi.PropertyInjector;
import org.jboss.resteasy.spi.ResourceFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GuiceResourceFactory
implements ResourceFactory {
    private final Provider provider;
    private final Class<?> scannableClass;
    private PropertyInjector propertyInjector;

    public GuiceResourceFactory(Provider provider, Class<?> scannableClass) {
        this.provider = provider;
        this.scannableClass = scannableClass;
    }

    public Class<?> getScannableClass() {
        return this.scannableClass;
    }

    public void registered(InjectorFactory factory) {
        this.propertyInjector = factory.createPropertyInjector(this.scannableClass);
    }

    public Object createResource(HttpRequest request, HttpResponse response, InjectorFactory factory) {
        Object resource = this.provider.get();
        this.propertyInjector.inject(request, response, resource);
        return resource;
    }

    public void requestFinished(HttpRequest request, HttpResponse response, Object resource) {
    }

    public void unregistered() {
    }
}

