/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.guice;

import com.google.inject.Binding;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Stage;
import java.lang.reflect.Type;
import javax.ws.rs.ext.Provider;
import org.jboss.resteasy.plugins.guice.GuiceResourceFactory;
import org.jboss.resteasy.spi.Registry;
import org.jboss.resteasy.spi.ResourceFactory;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.util.GetRestful;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleProcessor {
    private static final Logger logger = LoggerFactory.getLogger(ModuleProcessor.class);
    private final Registry registry;
    private final ResteasyProviderFactory providerFactory;

    public ModuleProcessor(Registry registry, ResteasyProviderFactory providerFactory) {
        this.registry = registry;
        this.providerFactory = providerFactory;
    }

    public void process(Module ... modules) {
        Injector injector = Guice.createInjector((Module[])modules);
        this.processInjector(injector);
    }

    public void process(Stage stage, Module ... modules) {
        Injector injector = Guice.createInjector((Stage)stage, (Module[])modules);
        this.processInjector(injector);
    }

    public void process(Iterable<Module> modules) {
        Injector injector = Guice.createInjector(modules);
        this.processInjector(injector);
    }

    public void process(Stage stage, Iterable<Module> modules) {
        Injector injector = Guice.createInjector((Stage)stage, modules);
        this.processInjector(injector);
    }

    private void processInjector(Injector injector) {
        for (Binding binding : injector.getBindings().values()) {
            Type type = binding.getKey().getTypeLiteral().getType();
            if (!(type instanceof Class)) continue;
            Class beanClass = (Class)type;
            if (GetRestful.isRootResource((Class)beanClass)) {
                GuiceResourceFactory resourceFactory = new GuiceResourceFactory(binding.getProvider(), beanClass);
                logger.info("registering factory for {}", (Object)beanClass);
                this.registry.addResourceFactory((ResourceFactory)resourceFactory);
            }
            if (!beanClass.isAnnotationPresent(Provider.class)) continue;
            logger.info("registering provider instance for {}", (Object)beanClass);
            this.providerFactory.registerProviderInstance(binding.getProvider().get());
        }
    }
}

