/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.guice.ext;

import com.google.inject.AbstractModule;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.Scope;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.jboss.resteasy.plugins.guice.RequestScoped;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

public class RequestScopeModule
extends AbstractModule {
    protected void configure() {
        this.bindScope(RequestScoped.class, new Scope(){

            public <T> Provider<T> scope(final Key<T> key, final Provider<T> creator) {
                return new Provider<T>(){

                    public T get() {
                        Class instanceClass = (Class)key.getTypeLiteral().getType();
                        Object instance = ResteasyProviderFactory.getContextData((Class)instanceClass);
                        if (instance == null) {
                            instance = creator.get();
                            ResteasyProviderFactory.pushContext((Class)instanceClass, (Object)instance);
                        }
                        return instance;
                    }

                    public String toString() {
                        return String.format("%s[%s]", creator, super.toString());
                    }
                };
            }
        });
        this.bind(HttpServletRequest.class).toProvider(new ResteasyContextProvider<HttpServletRequest>(HttpServletRequest.class)).in(RequestScoped.class);
        this.bind(HttpServletResponse.class).toProvider(new ResteasyContextProvider<HttpServletResponse>(HttpServletResponse.class)).in(RequestScoped.class);
        this.bind(Request.class).toProvider(new ResteasyContextProvider<Request>(Request.class)).in(RequestScoped.class);
        this.bind(HttpHeaders.class).toProvider(new ResteasyContextProvider<HttpHeaders>(HttpHeaders.class)).in(RequestScoped.class);
        this.bind(UriInfo.class).toProvider(new ResteasyContextProvider<UriInfo>(UriInfo.class)).in(RequestScoped.class);
        this.bind(SecurityContext.class).toProvider(new ResteasyContextProvider<SecurityContext>(SecurityContext.class)).in(RequestScoped.class);
    }

    private static class ResteasyContextProvider<T>
    implements Provider<T> {
        private final Class<T> instanceClass;

        public ResteasyContextProvider(Class<T> instanceClass) {
            this.instanceClass = instanceClass;
        }

        public T get() {
            return (T)ResteasyProviderFactory.getContextData(this.instanceClass);
        }
    }
}

