/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.validation.hibernate;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.ejb.Local;
import javax.ejb.Remote;
import javax.ejb.Stateful;
import javax.ejb.Stateless;
import javax.enterprise.util.AnnotationLiteral;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.Validator;
import org.hibernate.validator.method.MethodValidator;
import org.jboss.resteasy.api.validation.ConstraintType;
import org.jboss.resteasy.api.validation.ResteasyConstraintViolation;
import org.jboss.resteasy.api.validation.ResteasyViolationException;
import org.jboss.resteasy.cdi.CdiInjectorFactory;
import org.jboss.resteasy.cdi.ResteasyCdiExtension;
import org.jboss.resteasy.plugins.providers.validation.ConstraintTypeUtil;
import org.jboss.resteasy.plugins.providers.validation.ViolationsContainer;
import org.jboss.resteasy.plugins.validation.hibernate.ConstraintTypeUtil10;
import org.jboss.resteasy.plugins.validation.hibernate.DoNotValidateRequest;
import org.jboss.resteasy.plugins.validation.hibernate.ValidateRequest;
import org.jboss.resteasy.plugins.validation.hibernate.i18n.LogMessages;
import org.jboss.resteasy.plugins.validation.hibernate.i18n.Messages;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.InjectorFactory;
import org.jboss.resteasy.spi.ResteasyConfiguration;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.spi.validation.GeneralValidatorCDI;
import org.jboss.resteasy.util.FindAnnotation;

public class GeneralValidatorImpl
implements GeneralValidatorCDI {
    private Validator validator;
    private MethodValidator methodValidator;
    private ConstraintTypeUtil util = new ConstraintTypeUtil10();
    private boolean suppressPath;
    private boolean cdiActive;
    public static final String SUPPRESS_VIOLATION_PATH = "resteasy.validation.suppress.path";
    public static final Annotation STATELESS = new S1(){

        public String name() {
            return null;
        }

        public String mappedName() {
            return null;
        }

        public String description() {
            return null;
        }
    };
    public static final Annotation STATEFUL = new S2(){

        public String name() {
            return null;
        }

        public String mappedName() {
            return null;
        }

        public String description() {
            return null;
        }
    };
    public static final Annotation SINGLETON = new S3(){

        public String name() {
            return null;
        }

        public String mappedName() {
            return null;
        }

        public String description() {
            return null;
        }
    };
    public static final Annotation LOCAL = new S4(){

        public Class<?>[] value() {
            return null;
        }
    };
    public static final Annotation REMOTE = new S5(){

        public Class<?>[] value() {
            return null;
        }
    };
    private static final String PROXY_OBJECT_INTERFACE_NAME = "javassist.util.proxy.ProxyObject";
    private static final String TARGET_INSTANCE_INTERFACE_NAME = "org.jboss.interceptor.util.proxy.TargetInstanceProxy";

    public GeneralValidatorImpl(Validator validator, MethodValidator methodValidator) {
        String s;
        this.validator = validator;
        this.methodValidator = methodValidator;
        try {
            this.cdiActive = ResteasyCdiExtension.isCDIActive();
        }
        catch (Throwable t) {
            LogMessages.LOGGER.debug(Messages.MESSAGES.cdiExtensionNotOnClasspath());
        }
        ResteasyConfiguration context = (ResteasyConfiguration)ResteasyProviderFactory.getContextData(ResteasyConfiguration.class);
        if (context != null && (s = context.getParameter(SUPPRESS_VIOLATION_PATH)) != null) {
            this.suppressPath = Boolean.parseBoolean(s);
        }
    }

    public void checkViolations(HttpRequest request) {
        ViolationsContainer<Object> violationsContainer = this.getViolationsContainer(request, null);
        Object target = violationsContainer.getTarget();
        if (target != null && !GeneralValidatorImpl.isWeldProxy(target.getClass()) && violationsContainer != null && violationsContainer.size() > 0) {
            throw new ResteasyViolationException(violationsContainer, request.getHttpHeaders().getAcceptableMediaTypes());
        }
    }

    public void checkViolationsfromCDI(HttpRequest request) {
        if (request == null) {
            return;
        }
        ViolationsContainer violationsContainer = (ViolationsContainer)ViolationsContainer.class.cast(request.getAttribute(ViolationsContainer.class.getName()));
        if (violationsContainer != null && violationsContainer.size() > 0) {
            throw new ResteasyViolationException(violationsContainer, request.getHttpHeaders().getAcceptableMediaTypes());
        }
    }

    public void validate(HttpRequest request, Object object, Class<?> ... groups) {
        HashSet<ResteasyConstraintViolation> rcvs = new HashSet<ResteasyConstraintViolation>();
        try {
            Set cvs = this.validator.validate(object, (Class[])groups);
            for (ConstraintViolation cv : cvs) {
                ConstraintType.Type ct = this.util.getConstraintType((Object)cv);
                String path = this.suppressPath ? "*" : cv.getPropertyPath().toString();
                rcvs.add(new ResteasyConstraintViolation(ct, path, cv.getMessage(), cv.getInvalidValue() == null ? "null" : cv.getInvalidValue().toString()));
            }
        }
        catch (Exception e) {
            ViolationsContainer<Object> violationsContainer = this.getViolationsContainer(request, object);
            violationsContainer.setException(e);
            throw new ResteasyViolationException(violationsContainer);
        }
        ViolationsContainer<Object> violationsContainer = this.getViolationsContainer(request, object);
        violationsContainer.addViolations(rcvs);
    }

    public void validateAllParameters(HttpRequest request, Object object, Method method, Object[] parameterValues, Class<?> ... groups) {
        if (this.isSessionBean(method.getDeclaringClass()) || this.isSessionBean(object.getClass())) {
            Class<?>[] interfaces;
            try {
                method = object.getClass().getMethod(method.getName(), method.getParameterTypes());
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            if (!GeneralValidatorImpl.isWeldProxy(object.getClass()) && (interfaces = this.getInterfaces(method.getDeclaringClass())).length > 0) {
                object = this.getProxy(object.getClass(), interfaces, object);
            }
        }
        HashSet<ResteasyConstraintViolation> rcvs = new HashSet<ResteasyConstraintViolation>();
        ViolationsContainer<Object> violationsContainer = this.getViolationsContainer(request, object);
        try {
            Set cvs = this.methodValidator.validateAllParameters(object, method, parameterValues, (Class[])groups);
            for (ConstraintViolation cv : cvs) {
                ConstraintType.Type ct = this.util.getConstraintType((Object)cv);
                Object o = cv.getInvalidValue();
                String value = o == null ? "" : o.toString();
                String path = this.suppressPath ? "*" : cv.getPropertyPath().toString();
                rcvs.add(new ResteasyConstraintViolation(ct, path, cv.getMessage(), value));
            }
        }
        catch (Exception e) {
            violationsContainer.setException(e);
            throw new ResteasyViolationException(violationsContainer);
        }
        violationsContainer.addViolations(rcvs);
        if (!GeneralValidatorImpl.isWeldProxy(object.getClass()) && violationsContainer.size() > 0) {
            throw new ResteasyViolationException(violationsContainer, request.getHttpHeaders().getAcceptableMediaTypes());
        }
    }

    public void validateReturnValue(HttpRequest request, Object object, Method method, Object returnValue, Class<?> ... groups) {
        if (this.isSessionBean(method.getDeclaringClass())) {
            try {
                method = object.getClass().getMethod(method.getName(), method.getParameterTypes());
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        HashSet<ResteasyConstraintViolation> rcvs = new HashSet<ResteasyConstraintViolation>();
        ViolationsContainer<Object> violationsContainer = this.getViolationsContainer(request, object);
        try {
            Set cvs = this.methodValidator.validateReturnValue(object, method, returnValue, (Class[])groups);
            for (ConstraintViolation cv : cvs) {
                ConstraintType.Type ct = this.util.getConstraintType((Object)cv);
                Object o = cv.getInvalidValue();
                String value = o == null ? "" : o.toString();
                String path = this.suppressPath ? "*" : cv.getPropertyPath().toString();
                rcvs.add(new ResteasyConstraintViolation(ct, path, cv.getMessage(), value));
            }
        }
        catch (Exception e) {
            violationsContainer.setException(e);
            throw new ResteasyViolationException(violationsContainer);
        }
        violationsContainer.addViolations(rcvs);
        if (violationsContainer.size() > 0) {
            throw new ResteasyViolationException(violationsContainer, request.getHttpHeaders().getAcceptableMediaTypes());
        }
    }

    public boolean isValidatable(Class<?> clazz) {
        if (this.cdiActive) {
            return false;
        }
        return this.checkIsValidatable(clazz);
    }

    public boolean isValidatable(Class<?> clazz, InjectorFactory injectorFactory) {
        try {
            if (this.cdiActive && injectorFactory instanceof CdiInjectorFactory) {
                return false;
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        return this.checkIsValidatable(clazz);
    }

    public boolean isValidatableFromCDI(Class<?> clazz) {
        return this.checkIsValidatable(clazz);
    }

    protected boolean checkIsValidatable(Class<?> clazz) {
        ValidateRequest resourceValidateRequest = (ValidateRequest)FindAnnotation.findAnnotation((Annotation[])clazz.getAnnotations(), ValidateRequest.class);
        DoNotValidateRequest doNotValidateRequest = (DoNotValidateRequest)FindAnnotation.findAnnotation((Annotation[])clazz.getAnnotations(), DoNotValidateRequest.class);
        return resourceValidateRequest != null && doNotValidateRequest == null;
    }

    public boolean isMethodValidatable(Method m) {
        return this.checkIsMethodValidatable(m);
    }

    protected boolean checkIsMethodValidatable(Method m) {
        ValidateRequest resourceValidateRequest = (ValidateRequest)FindAnnotation.findAnnotation((Annotation[])m.getDeclaringClass().getAnnotations(), ValidateRequest.class);
        ValidateRequest methodValidateRequest = (ValidateRequest)FindAnnotation.findAnnotation((Annotation[])m.getAnnotations(), ValidateRequest.class);
        DoNotValidateRequest doNotValidateRequest = (DoNotValidateRequest)FindAnnotation.findAnnotation((Annotation[])m.getAnnotations(), DoNotValidateRequest.class);
        return (resourceValidateRequest != null || methodValidateRequest != null) && doNotValidateRequest == null;
    }

    public void checkForConstraintViolations(HttpRequest request, Exception e) {
        Throwable t;
        if (e instanceof ConstraintViolationException) {
            ConstraintViolationException cve = (ConstraintViolationException)ConstraintViolationException.class.cast(e);
            Set cvs = cve.getConstraintViolations();
            HashSet<ResteasyConstraintViolation> rcvs = new HashSet<ResteasyConstraintViolation>();
            try {
                for (ConstraintViolation cv : cvs) {
                    ConstraintType.Type ct = this.util.getConstraintType((Object)cv);
                    String path = this.suppressPath ? "*" : cv.getPropertyPath().toString();
                    rcvs.add(new ResteasyConstraintViolation(ct, path, cv.getMessage(), cv.getInvalidValue() == null ? "null" : cv.getInvalidValue().toString()));
                }
            }
            catch (Exception e1) {
                ViolationsContainer<Object> violationsContainer = this.getViolationsContainer(request, null);
                violationsContainer.setException(e);
                throw new ResteasyViolationException(violationsContainer);
            }
            if (rcvs.size() > 0) {
                ViolationsContainer<Object> violationsContainer = this.getViolationsContainer(request, null);
                violationsContainer.addViolations(rcvs);
                throw new ResteasyViolationException(violationsContainer);
            }
        }
        for (t = e.getCause(); t != null && !(t instanceof ResteasyViolationException); t = t.getCause()) {
        }
        if (t instanceof ResteasyViolationException) {
            throw (ResteasyViolationException)((Object)ResteasyViolationException.class.cast(t));
        }
    }

    protected ViolationsContainer<Object> getViolationsContainer(HttpRequest request, Object target) {
        if (request == null) {
            return new ViolationsContainer(target);
        }
        ViolationsContainer violationsContainer = (ViolationsContainer)ViolationsContainer.class.cast(request.getAttribute(ViolationsContainer.class.getName()));
        if (violationsContainer == null) {
            violationsContainer = new ViolationsContainer(target);
            request.setAttribute(ViolationsContainer.class.getName(), (Object)violationsContainer);
        }
        return violationsContainer;
    }

    private boolean isSessionBean(Class<?> clazz) {
        if (clazz.getName().indexOf("$$$view") >= 0) {
            return true;
        }
        while (clazz != null) {
            if (clazz.getAnnotation(STATELESS.annotationType()) != null || clazz.getAnnotation(STATEFUL.annotationType()) != null || clazz.getAnnotation(SINGLETON.annotationType()) != null || clazz.getAnnotation(LOCAL.annotationType()) != null || clazz.getAnnotation(REMOTE.annotationType()) != null) {
                return true;
            }
            clazz = clazz.getSuperclass();
        }
        return false;
    }

    private Class<?>[] getInterfaces(Class<?> clazz) {
        ArrayList list = new ArrayList();
        this.getInterfaces(list, clazz);
        return list.toArray(new Class[0]);
    }

    private void getInterfaces(ArrayList<Class<?>> list, Class<?> clazz) {
        Class<?>[] interfaces = clazz.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            list.add(interfaces[i]);
            this.getInterfaces(list, interfaces[i]);
        }
    }

    private Object getProxy(Class<?> clazz, Class<?>[] interfaces, final Object delegate) {
        InvocationHandler handler = new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                return method.invoke(delegate, args);
            }
        };
        Object proxy = Proxy.newProxyInstance(clazz.getClassLoader(), interfaces, handler);
        return proxy;
    }

    private static boolean isWeldProxy(Class<?> clazz) {
        boolean foundProxyObject = false;
        boolean foundTargetInstance = false;
        for (Class<?> implementedInterface : clazz.getInterfaces()) {
            if (implementedInterface.getName().equals(PROXY_OBJECT_INTERFACE_NAME)) {
                foundProxyObject = true;
            } else if (implementedInterface.getName().equals(TARGET_INSTANCE_INTERFACE_NAME)) {
                foundTargetInstance = true;
            }
            if (!foundProxyObject || !foundTargetInstance) continue;
            return true;
        }
        return clazz.getName().contains("_$$_Weld");
    }

    public static abstract class S5
    extends AnnotationLiteral<Remote>
    implements Remote {
    }

    public static abstract class S4
    extends AnnotationLiteral<Local>
    implements Local {
    }

    public static abstract class S3
    extends AnnotationLiteral<Stateful>
    implements Stateful {
    }

    public static abstract class S2
    extends AnnotationLiteral<Stateful>
    implements Stateful {
    }

    public static abstract class S1
    extends AnnotationLiteral<Stateless>
    implements Stateless {
    }
}

