/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.validation.hibernate;

import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Provider;
import org.hibernate.validator.HibernateValidator;
import org.hibernate.validator.HibernateValidatorConfiguration;
import org.hibernate.validator.method.MethodValidator;
import org.jboss.resteasy.logging.Logger;
import org.jboss.resteasy.plugins.validation.hibernate.GeneralValidatorImpl;
import org.jboss.resteasy.spi.validation.GeneralValidator;

@Provider
public class ValidatorContextResolver
implements ContextResolver<GeneralValidator> {
    private static final Logger logger = Logger.getLogger(ValidatorContextResolver.class);
    final Object RD_LOCK = new Object();
    private volatile ValidatorFactory validatorFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected GeneralValidator getGeneralValidator() {
        ValidatorFactory tmpValidatorFactory = this.validatorFactory;
        if (tmpValidatorFactory == null) {
            Object object = this.RD_LOCK;
            synchronized (object) {
                tmpValidatorFactory = this.validatorFactory;
                if (this.validatorFactory == null) {
                    HibernateValidatorConfiguration config = (HibernateValidatorConfiguration)Validation.byProvider(HibernateValidator.class).configure();
                    tmpValidatorFactory = this.validatorFactory = config.buildValidatorFactory();
                }
            }
        }
        Validator validator = this.validatorFactory.getValidator();
        MethodValidator methodValidator = (MethodValidator)validator.unwrap(MethodValidator.class);
        return new GeneralValidatorImpl(validator, methodValidator);
    }

    public GeneralValidator getContext(Class<?> type) {
        try {
            return this.getGeneralValidator();
        }
        catch (Exception e) {
            logger.warn("Unable to load Validation support", (Throwable)e);
            return null;
        }
    }
}

