/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.validation.hibernate;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import javax.ejb.Stateful;
import javax.ejb.Stateless;
import javax.enterprise.util.AnnotationLiteral;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.Validator;
import org.hibernate.validator.method.MethodValidator;
import org.jboss.resteasy.api.validation.ConstraintType;
import org.jboss.resteasy.api.validation.ResteasyConstraintViolation;
import org.jboss.resteasy.api.validation.ResteasyViolationException;
import org.jboss.resteasy.cdi.ResteasyCdiExtension;
import org.jboss.resteasy.plugins.providers.validation.ConstraintTypeUtil;
import org.jboss.resteasy.plugins.providers.validation.ViolationsContainer;
import org.jboss.resteasy.plugins.validation.hibernate.ConstraintTypeUtil10;
import org.jboss.resteasy.plugins.validation.hibernate.DoNotValidateRequest;
import org.jboss.resteasy.plugins.validation.hibernate.ValidateRequest;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.validation.GeneralValidatorCDI;
import org.jboss.resteasy.util.FindAnnotation;
import org.jboss.resteasy.util.GetRestful;

public class GeneralValidatorImpl
implements GeneralValidatorCDI {
    private Validator validator;
    private MethodValidator methodValidator;
    private ConstraintTypeUtil util = new ConstraintTypeUtil10();
    private boolean cdiActive;
    public static final Annotation STATELESS = new S1(){

        public String name() {
            return null;
        }

        public String mappedName() {
            return null;
        }

        public String description() {
            return null;
        }
    };
    public static final Annotation STATEFUL = new S2(){

        public String name() {
            return null;
        }

        public String mappedName() {
            return null;
        }

        public String description() {
            return null;
        }
    };
    public static final Annotation SINGLETON = new S3(){

        public String name() {
            return null;
        }

        public String mappedName() {
            return null;
        }

        public String description() {
            return null;
        }
    };

    public GeneralValidatorImpl(Validator validator, MethodValidator methodValidator) {
        this.validator = validator;
        this.methodValidator = methodValidator;
        try {
            this.cdiActive = ResteasyCdiExtension.isCDIActive();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected ViolationsContainer<Object> getViolationsContainer(HttpRequest request) {
        ViolationsContainer violationsContainer = (ViolationsContainer)ViolationsContainer.class.cast(request.getAttribute(ViolationsContainer.class.getName()));
        if (violationsContainer == null) {
            violationsContainer = new ViolationsContainer();
            request.setAttribute(ViolationsContainer.class.getName(), (Object)violationsContainer);
        }
        return violationsContainer;
    }

    public void checkViolations(HttpRequest request) {
        if (this.cdiActive) {
            return;
        }
        this.doCheckViolations(request);
    }

    public void checkViolationsfromCDI(HttpRequest request) {
        assert (this.cdiActive);
        this.doCheckViolations(request);
    }

    protected void doCheckViolations(HttpRequest request) {
        ViolationsContainer violationsContainer = (ViolationsContainer)ViolationsContainer.class.cast(request.getAttribute(ViolationsContainer.class.getName()));
        if (violationsContainer != null && violationsContainer.size() > 0) {
            throw new ResteasyViolationException(violationsContainer, request.getHttpHeaders().getAcceptableMediaTypes());
        }
    }

    public void validate(HttpRequest request, Object object, Class<?> ... groups) {
        HashSet<ResteasyConstraintViolation> rcvs = new HashSet<ResteasyConstraintViolation>();
        try {
            Set cvs = this.validator.validate(object, (Class[])groups);
            for (ConstraintViolation cv : cvs) {
                ConstraintType.Type ct = this.util.getConstraintType((Object)cv);
                rcvs.add(new ResteasyConstraintViolation(ct, cv.getPropertyPath().toString(), cv.getMessage(), cv.getInvalidValue() == null ? "null" : cv.getInvalidValue().toString()));
            }
        }
        catch (Exception e) {
            ViolationsContainer<Object> violationsContainer = this.getViolationsContainer(request);
            violationsContainer.setException(e);
            throw new ResteasyViolationException(violationsContainer);
        }
        ViolationsContainer<Object> violationsContainer = this.getViolationsContainer(request);
        violationsContainer.addViolations(rcvs);
    }

    public void validateAllParameters(HttpRequest request, Object object, Method method, Object[] parameterValues, Class<?> ... groups) {
        if (this.isSessionBean(method.getDeclaringClass())) {
            try {
                method = object.getClass().getMethod(method.getName(), method.getParameterTypes());
            }
            catch (NoSuchMethodException e1) {
                // empty catch block
            }
        }
        HashSet<ResteasyConstraintViolation> rcvs = new HashSet<ResteasyConstraintViolation>();
        ViolationsContainer<Object> violationsContainer = this.getViolationsContainer(request);
        try {
            Set cvs = this.methodValidator.validateAllParameters(object, method, parameterValues, (Class[])groups);
            for (ConstraintViolation cv : cvs) {
                ConstraintType.Type ct = this.util.getConstraintType((Object)cv);
                Object o = cv.getInvalidValue();
                String value = o == null ? "" : o.toString();
                rcvs.add(new ResteasyConstraintViolation(ct, cv.getPropertyPath().toString(), cv.getMessage(), value));
            }
        }
        catch (Exception e) {
            violationsContainer.setException(e);
            throw new ResteasyViolationException(violationsContainer);
        }
        violationsContainer.addViolations(rcvs);
        if (!this.cdiActive && violationsContainer.size() > 0) {
            throw new ResteasyViolationException(violationsContainer, request.getHttpHeaders().getAcceptableMediaTypes());
        }
    }

    public void validateReturnValue(HttpRequest request, Object object, Method method, Object returnValue, Class<?> ... groups) {
        System.out.println("declaring class: " + method.getDeclaringClass());
        if (this.isSessionBean(method.getDeclaringClass())) {
            try {
                method = object.getClass().getMethod(method.getName(), method.getParameterTypes());
            }
            catch (NoSuchMethodException e1) {
                // empty catch block
            }
        }
        HashSet<ResteasyConstraintViolation> rcvs = new HashSet<ResteasyConstraintViolation>();
        ViolationsContainer<Object> violationsContainer = this.getViolationsContainer(request);
        try {
            Set cvs = this.methodValidator.validateReturnValue(object, method, returnValue, (Class[])groups);
            for (ConstraintViolation cv : cvs) {
                ConstraintType.Type ct = this.util.getConstraintType((Object)cv);
                Object o = cv.getInvalidValue();
                String value = o == null ? "" : o.toString();
                rcvs.add(new ResteasyConstraintViolation(ct, cv.getPropertyPath().toString(), cv.getMessage(), value));
            }
        }
        catch (Exception e) {
            violationsContainer.setException(e);
            throw new ResteasyViolationException(violationsContainer);
        }
        violationsContainer.addViolations(rcvs);
        if (violationsContainer.size() > 0) {
            throw new ResteasyViolationException(violationsContainer, request.getHttpHeaders().getAcceptableMediaTypes());
        }
    }

    public boolean isValidatable(Class<?> clazz) {
        if (this.cdiActive) {
            return !GetRestful.isRootResource(clazz) && GetRestful.isSubResourceClass(clazz);
        }
        return this.checkIsValidatable(clazz);
    }

    public boolean isValidatableFromCDI(Class<?> clazz) {
        assert (this.cdiActive);
        return this.checkIsValidatable(clazz);
    }

    protected boolean checkIsValidatable(Class<?> clazz) {
        ValidateRequest resourceValidateRequest = (ValidateRequest)FindAnnotation.findAnnotation((Annotation[])clazz.getAnnotations(), ValidateRequest.class);
        DoNotValidateRequest doNotValidateRequest = (DoNotValidateRequest)FindAnnotation.findAnnotation((Annotation[])clazz.getAnnotations(), DoNotValidateRequest.class);
        return resourceValidateRequest != null && doNotValidateRequest == null;
    }

    public boolean isMethodValidatable(Method m) {
        return this.checkIsMethodValidatable(m);
    }

    public boolean isMethodValidatableFromCDI(Method m) {
        assert (this.cdiActive);
        return this.checkIsMethodValidatable(m);
    }

    protected boolean checkIsMethodValidatable(Method m) {
        ValidateRequest resourceValidateRequest = (ValidateRequest)FindAnnotation.findAnnotation((Annotation[])m.getDeclaringClass().getAnnotations(), ValidateRequest.class);
        ValidateRequest methodValidateRequest = (ValidateRequest)FindAnnotation.findAnnotation((Annotation[])m.getAnnotations(), ValidateRequest.class);
        DoNotValidateRequest doNotValidateRequest = (DoNotValidateRequest)FindAnnotation.findAnnotation((Annotation[])m.getAnnotations(), DoNotValidateRequest.class);
        return (resourceValidateRequest != null || methodValidateRequest != null) && doNotValidateRequest == null;
    }

    public void checkForConstraintViolations(HttpRequest request, Exception e) {
        Throwable t;
        if (e instanceof ConstraintViolationException) {
            ConstraintViolationException cve = (ConstraintViolationException)ConstraintViolationException.class.cast(e);
            Set cvs = cve.getConstraintViolations();
            HashSet<ResteasyConstraintViolation> rcvs = new HashSet<ResteasyConstraintViolation>();
            try {
                for (ConstraintViolation cv : cvs) {
                    ConstraintType.Type ct = this.util.getConstraintType((Object)cv);
                    rcvs.add(new ResteasyConstraintViolation(ct, cv.getPropertyPath().toString(), cv.getMessage(), cv.getInvalidValue() == null ? "null" : cv.getInvalidValue().toString()));
                }
            }
            catch (Exception e1) {
                ViolationsContainer<Object> violationsContainer = this.getViolationsContainer(request);
                violationsContainer.setException(e);
                throw new ResteasyViolationException(violationsContainer);
            }
            if (rcvs.size() > 0) {
                ViolationsContainer<Object> violationsContainer = this.getViolationsContainer(request);
                violationsContainer.addViolations(rcvs);
                throw new ResteasyViolationException(violationsContainer);
            }
        }
        for (t = e.getCause(); t != null && !(t instanceof ResteasyViolationException); t = t.getCause()) {
        }
        if (t instanceof ResteasyViolationException) {
            throw (ResteasyViolationException)((Object)ResteasyViolationException.class.cast(t));
        }
    }

    private boolean isSessionBean(Class<?> clazz) {
        while (clazz != null) {
            Annotation[] as = clazz.getAnnotations();
            for (int i = 0; i < as.length; ++i) {
                System.out.println("annotation[" + i + "]: " + as[i]);
            }
            if (clazz.getAnnotation(STATELESS.annotationType()) != null || clazz.getAnnotation(STATEFUL.annotationType()) != null || clazz.getAnnotation(SINGLETON.annotationType()) != null) {
                return true;
            }
            clazz = clazz.getSuperclass();
        }
        return false;
    }

    public static abstract class S3
    extends AnnotationLiteral<Stateful>
    implements Stateful {
    }

    public static abstract class S2
    extends AnnotationLiteral<Stateful>
    implements Stateful {
    }

    public static abstract class S1
    extends AnnotationLiteral<Stateless>
    implements Stateless {
    }
}

