package org.jboss.resteasy.test.rx.rxjava2.resource;

import java.util.List;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HEAD;
import jakarta.ws.rs.OPTIONS;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.MediaType;

import org.jboss.resteasy.test.rx.resource.TRACE;
import org.jboss.resteasy.test.rx.resource.Thing;

import io.reactivex.Single;

@Path("")
public interface Rx2SingleResource {

    @GET
    @Path("get/string")
    @Produces(MediaType.TEXT_PLAIN)
    Single<String> get();

    @GET
    @Path("get/thing")
    @Produces(MediaType.APPLICATION_JSON)
    Single<Thing> getThing();

    @GET
    @Path("get/thing/list")
    @Produces(MediaType.APPLICATION_JSON)
    Single<List<Thing>> getThingList();

    @PUT
    @Path("put/string")
    @Consumes(MediaType.TEXT_PLAIN)
    @Produces(MediaType.TEXT_PLAIN)
    Single<String> put(String s);

    @PUT
    @Path("put/thing")
    @Consumes(MediaType.TEXT_PLAIN)
    @Produces(MediaType.APPLICATION_JSON)
    Single<Thing> putThing(String s);

    @PUT
    @Path("put/thing/list")
    @Consumes(MediaType.TEXT_PLAIN)
    @Produces(MediaType.APPLICATION_JSON)
    Single<List<Thing>> putThingList(String s);

    @POST
    @Path("post/string")
    @Consumes(MediaType.TEXT_PLAIN)
    @Produces(MediaType.TEXT_PLAIN)
    Single<String> post(String s);

    @POST
    @Path("post/thing")
    @Consumes(MediaType.TEXT_PLAIN)
    @Produces(MediaType.APPLICATION_JSON)
    Single<Thing> postThing(String s);

    @POST
    @Path("post/thing/list")
    @Consumes(MediaType.TEXT_PLAIN)
    @Produces(MediaType.APPLICATION_JSON)
    Single<List<Thing>> postThingList(String s);

    @DELETE
    @Path("delete/string")
    @Produces(MediaType.TEXT_PLAIN)
    Single<String> delete();

    @DELETE
    @Path("delete/thing")
    @Produces(MediaType.APPLICATION_JSON)
    Single<Thing> deleteThing();

    @DELETE
    @Path("delete/thing/list")
    @Produces(MediaType.APPLICATION_JSON)
    Single<List<Thing>> deleteThingList();

    @HEAD
    @Path("head/string")
    @Produces(MediaType.TEXT_PLAIN)
    Single<String> head();

    @OPTIONS
    @Path("options/string")
    @Produces(MediaType.TEXT_PLAIN)
    Single<String> options();

    @OPTIONS
    @Path("options/thing")
    @Produces(MediaType.APPLICATION_JSON)
    Single<Thing> optionsThing();

    @OPTIONS
    @Path("options/thing/list")
    @Produces(MediaType.APPLICATION_JSON)
    Single<List<Thing>> optionsThingList();

    @TRACE
    @Path("trace/string")
    @Produces(MediaType.TEXT_PLAIN)
    Single<String> trace();

    @TRACE
    @Path("trace/thing")
    @Produces(MediaType.APPLICATION_JSON)
    Single<Thing> traceThing();

    @TRACE
    @Path("trace/thing/list")
    @Produces(MediaType.APPLICATION_JSON)
    Single<List<Thing>> traceThingList();

    @GET
    @Path("exception/unhandled")
    Single<Thing> exceptionUnhandled() throws Exception;

    @GET
    @Path("exception/handled")
    Single<Thing> exceptionHandled() throws Exception;
}
