/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers.jaxb;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Providers;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.jboss.resteasy.plugins.providers.AbstractEntityProvider;
import org.jboss.resteasy.plugins.providers.jaxb.JAXBContextFinder;
import org.jboss.resteasy.spi.LoggableFailure;
import org.jboss.resteasy.util.TypeConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJAXBProvider<T>
extends AbstractEntityProvider<T> {
    @Context
    protected Providers providers;

    public JAXBContext findJAXBContext(Class<?> type, Annotation[] annotations, MediaType mediaType) throws JAXBException {
        ContextResolver resolver = this.providers.getContextResolver(JAXBContextFinder.class, mediaType);
        JAXBContextFinder finder = (JAXBContextFinder)resolver.getContext(type);
        if (finder == null) {
            throw new LoggableFailure("Could not find JAXBContextFinder for media type: " + mediaType);
        }
        return finder.findCachedContext(type, mediaType, annotations);
    }

    public T readFrom(Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException {
        try {
            JAXBContext jaxb = this.findJAXBContext(type, annotations, mediaType);
            Unmarshaller unmarshaller = jaxb.createUnmarshaller();
            return (T)unmarshaller.unmarshal((Source)new StreamSource(entityStream));
        }
        catch (JAXBException e) {
            Response response = Response.serverError().build();
            throw new WebApplicationException((Throwable)e, response);
        }
    }

    public void writeTo(T t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream outputStream) throws IOException {
        try {
            Marshaller marshaller = this.getMarshaller(type, annotations, mediaType);
            marshaller.marshal(t, outputStream);
        }
        catch (JAXBException e) {
            Response response = Response.serverError().build();
            throw new WebApplicationException((Throwable)e, response);
        }
    }

    protected Marshaller getMarshaller(Class<?> type, Annotation[] annotations, MediaType mediaType) {
        try {
            Object formatted;
            JAXBContext jaxb = this.findJAXBContext(type, annotations, mediaType);
            Marshaller marshaller = jaxb.createMarshaller();
            String charset = this.getCharset(mediaType);
            if (charset != null) {
                marshaller.setProperty("jaxb.encoding", (Object)charset);
            }
            if ((formatted = mediaType.getParameters().get("formatted")) != null) {
                Boolean value = TypeConverter.getBooleanValue((String)formatted.toString());
                marshaller.setProperty("jaxb.formatted.output", (Object)value);
            }
            return marshaller;
        }
        catch (JAXBException e) {
            Response response = Response.serverError().build();
            throw new WebApplicationException((Throwable)e, response);
        }
    }

    protected abstract boolean isReadWritable(Class<?> var1, Type var2, Annotation[] var3, MediaType var4);

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return this.isReadWritable(type, genericType, annotations, mediaType);
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return this.isReadWritable(type, genericType, annotations, mediaType);
    }

    public final String getCharset(MediaType mediaType) {
        if (mediaType != null) {
            return (String)mediaType.getParameters().get("charset");
        }
        return null;
    }
}

