/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers.jaxb;

import java.util.concurrent.ConcurrentHashMap;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import org.jboss.resteasy.core.ExceptionAdapter;
import org.jboss.resteasy.core.LoggerCategories;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JAXBCache {
    private static final Logger logger = LoggerCategories.getProviderLogger();
    private static JAXBCache instance = new JAXBCache();
    private ConcurrentHashMap<Object, JAXBContext> contextCache = new ConcurrentHashMap();

    private JAXBCache() {
    }

    public static JAXBCache instance() {
        return instance;
    }

    public JAXBContext getJAXBContext(Class<?> ... classes) {
        JAXBContext context = this.contextCache.get(classes);
        if (context == null) {
            try {
                context = JAXBContext.newInstance((Class[])classes);
            }
            catch (JAXBException e) {
                throw new ExceptionAdapter((Exception)((Object)e));
            }
            this.contextCache.putIfAbsent(classes, context);
        }
        logger.debug("Locating JAXBContext for package: {}", (Object[])classes);
        return context;
    }

    public JAXBContext getJAXBContext(String ... packageNames) {
        String contextPath = this.buildContextPath(packageNames);
        logger.debug("Locating JAXBContext for packages: {}", (Object)contextPath);
        return null;
    }

    private String buildContextPath(String[] packageNames) {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < packageNames.length; ++i) {
            b.append(packageNames[i]);
            if (i == packageNames.length - 1) continue;
            b.append(":");
        }
        return b.toString();
    }
}

