/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers.jaxb.hacks;

import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.PropertyException;
import jakarta.xml.bind.ValidationEventHandler;
import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import jakarta.xml.bind.attachment.AttachmentMarshaller;
import java.io.File;
import java.io.OutputStream;
import java.io.Writer;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.validation.Schema;
import org.jboss.resteasy.plugins.providers.jaxb.hacks.PropertyResolver;
import org.jboss.resteasy.plugins.providers.jaxb.i18n.LogMessages;
import org.jboss.resteasy.plugins.providers.jaxb.i18n.Messages;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;

class DelegatingMarshaller
implements Marshaller {
    private final Marshaller delegate;

    DelegatingMarshaller(Marshaller delegate) {
        this.delegate = delegate;
    }

    public void marshal(Object jaxbElement, Result result) throws JAXBException {
        this.delegate.marshal(jaxbElement, result);
    }

    public void marshal(Object jaxbElement, OutputStream os) throws JAXBException {
        this.delegate.marshal(jaxbElement, os);
    }

    public void marshal(Object jaxbElement, File output) throws JAXBException {
        this.delegate.marshal(jaxbElement, output);
    }

    public void marshal(Object jaxbElement, Writer writer) throws JAXBException {
        this.delegate.marshal(jaxbElement, writer);
    }

    public void marshal(Object jaxbElement, ContentHandler handler) throws JAXBException {
        this.delegate.marshal(jaxbElement, handler);
    }

    public void marshal(Object jaxbElement, Node node) throws JAXBException {
        this.delegate.marshal(jaxbElement, node);
    }

    public void marshal(Object jaxbElement, XMLStreamWriter writer) throws JAXBException {
        this.delegate.marshal(jaxbElement, writer);
    }

    public void marshal(Object jaxbElement, XMLEventWriter writer) throws JAXBException {
        this.delegate.marshal(jaxbElement, writer);
    }

    public Node getNode(Object contentTree) throws JAXBException {
        return this.delegate.getNode(contentTree);
    }

    public void setProperty(String name, Object value) throws PropertyException {
        try {
            this.delegate.setProperty(name, value);
            return;
        }
        catch (PropertyException e) {
            LogMessages.LOGGER.debugf(e, "Failed to set %s with value %s", name, value);
            String newName = PropertyResolver.resolveProperty(name);
            if (newName != null) {
                try {
                    this.delegate.setProperty(newName, value);
                    return;
                }
                catch (PropertyException e2) {
                    LogMessages.LOGGER.debugf(e2, "Failed to set %s with value %s", newName, value);
                }
            } else {
                throw Messages.MESSAGES.couldNotAddProperty(name, value);
            }
            throw Messages.MESSAGES.couldNotAddProperty(name, newName, value);
        }
    }

    public Object getProperty(String name) throws PropertyException {
        try {
            return this.delegate.getProperty(name);
        }
        catch (PropertyException e) {
            LogMessages.LOGGER.debugf(e, "Failed to get property %s.", name);
            String newName = PropertyResolver.resolveProperty(name);
            if (newName != null) {
                try {
                    return this.delegate.getProperty(newName);
                }
                catch (PropertyException e2) {
                    LogMessages.LOGGER.debugf(e2, "Failed to get property %s.", name);
                }
            } else {
                throw Messages.MESSAGES.couldNotGetProperty(name);
            }
            throw Messages.MESSAGES.couldNotGetProperty(name, newName);
        }
    }

    public void setEventHandler(ValidationEventHandler handler) throws JAXBException {
        this.delegate.setEventHandler(handler);
    }

    public ValidationEventHandler getEventHandler() throws JAXBException {
        return this.delegate.getEventHandler();
    }

    public void setAdapter(XmlAdapter adapter) {
        this.delegate.setAdapter(adapter);
    }

    public <A extends XmlAdapter> void setAdapter(Class<A> type, A adapter) {
        this.delegate.setAdapter(type, adapter);
    }

    public <A extends XmlAdapter> A getAdapter(Class<A> type) {
        return (A)this.delegate.getAdapter(type);
    }

    public void setAttachmentMarshaller(AttachmentMarshaller am) {
        this.delegate.setAttachmentMarshaller(am);
    }

    public AttachmentMarshaller getAttachmentMarshaller() {
        return this.delegate.getAttachmentMarshaller();
    }

    public void setSchema(Schema schema) {
        this.delegate.setSchema(schema);
    }

    public Schema getSchema() {
        return this.delegate.getSchema();
    }

    public void setListener(Marshaller.Listener listener) {
        this.delegate.setListener(listener);
    }

    public Marshaller.Listener getListener() {
        return this.delegate.getListener();
    }
}

