/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.test.resteasy_jaxrs.i18n;

import java.io.InputStream;
import java.util.Locale;
import java.util.Properties;
import org.junit.AfterClass;
import org.junit.BeforeClass;

public abstract class TestMessagesParent {
    protected static Locale savedLocale;
    protected Properties properties = new Properties();

    @BeforeClass
    public static void beforeClass() {
        savedLocale = Locale.getDefault();
    }

    @AfterClass
    public static void afterClass() {
        Locale.setDefault(savedLocale);
        System.out.println("Reset default locale to: " + savedLocale);
    }

    public boolean before(Locale locale, String filename) throws Exception {
        System.out.println("default locale: " + Locale.getDefault());
        Locale.setDefault(locale);
        System.out.println("Set default locale to: " + locale);
        System.out.println("Messages file: " + filename);
        InputStream is = this.getClass().getClassLoader().getResourceAsStream(filename);
        if (is == null) {
            return false;
        }
        this.properties.load(is);
        return this.getExpectedNumberOfMethods() == this.properties.size();
    }

    protected String getExpected(String id, String message, Object ... args) {
        String expected = "RESTEASY" + id + ": " + String.format(this.replacePositionalSpecifiers((String)String.class.cast(this.properties.get(message))), args);
        System.out.println("expected: " + expected);
        return expected;
    }

    protected String replacePositionalSpecifiers(String s) {
        int pos2;
        int pos1;
        int pos0 = s.indexOf("{0}");
        if (pos0 > -1) {
            s = s.substring(0, pos0) + "%1$s" + (pos0 + 3 >= s.length() ? "" : s.substring(pos0 + 3));
        }
        if ((pos1 = s.indexOf("{1}")) > -1) {
            s = s.substring(0, pos1) + "%2$s" + (pos1 + 3 >= s.length() ? "" : s.substring(pos1 + 3));
        }
        if ((pos2 = s.indexOf("{2}")) > -1) {
            s = s.substring(0, pos2) + "%3$s" + (pos2 + 3 >= s.length() ? "" : s.substring(pos2 + 3));
        }
        return s;
    }

    protected abstract int getExpectedNumberOfMethods();

    protected abstract Locale getLocale();
}

