/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.client.core;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.MessageBodyReader;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.jboss.resteasy.client.ClientResponse;
import org.jboss.resteasy.client.ClientResponseFailure;
import org.jboss.resteasy.client.core.ClientInterceptor;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.util.CaseInsensitiveMap;
import org.jboss.resteasy.util.GenericType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientResponseImpl<T>
extends ClientResponse<T> {
    protected ResteasyProviderFactory providerFactory;
    protected String attributeExceptionsTo;
    protected Iterable<ClientInterceptor> interceptors = Collections.emptyList();
    protected String restVerb;
    protected String url;
    protected HttpMethodBase baseMethod;
    protected CaseInsensitiveMap<String> headers;
    protected String alternateMediaType;
    protected Class<?> returnType;
    protected Type genericReturnType;
    protected Annotation[] annotations;
    protected int status;
    protected boolean wasReleased = false;
    protected boolean streamWasRead = false;
    protected byte[] rawResults;
    protected Object unmarshaledEntity;
    protected Exception exception;
    protected boolean allowRereads = false;
    protected boolean performExecute = true;
    protected boolean cacheInputStream;

    public void setProviderFactory(ResteasyProviderFactory providerFactory) {
        this.providerFactory = providerFactory;
    }

    public void setReturnType(Class<T> returnType) {
        this.returnType = returnType;
    }

    public Class<?> getReturnType() {
        return this.returnType;
    }

    public void setGenericReturnType(Type genericReturnType) {
        this.genericReturnType = genericReturnType;
    }

    public void setAnnotations(Annotation[] annotations) {
        this.annotations = annotations;
    }

    public String getAttributeExceptionsTo() {
        return this.attributeExceptionsTo;
    }

    public void setAttributeExceptionsTo(String attributeExceptionsTo) {
        this.attributeExceptionsTo = attributeExceptionsTo;
    }

    public Exception getException() {
        return this.exception;
    }

    public void setException(Exception exception) {
        this.exception = exception;
    }

    public void setInterceptors(Iterable<ClientInterceptor> interceptors) {
        this.interceptors = interceptors;
    }

    public Header getContentTypeHeader() {
        return this.baseMethod.getResponseHeader("Content-Type");
    }

    public String getContentType() {
        Header contentTypeHeader = this.getContentTypeHeader();
        return contentTypeHeader == null ? null : contentTypeHeader.getValue();
    }

    public Annotation[] getAnnotations() {
        return this.annotations;
    }

    public String getResponseHeader(String headerKey) {
        if (this.headers == null) {
            return null;
        }
        return this.headers.getFirst(headerKey);
    }

    public void setAlternateMediaType(String alternateMediaType) {
        this.alternateMediaType = alternateMediaType;
    }

    public HttpMethodBase getHttpBaseMethod() {
        return this.baseMethod;
    }

    public boolean isAllowRereads() {
        return this.allowRereads;
    }

    public void setAllowRereads(boolean allowRereads) {
        this.allowRereads = allowRereads;
    }

    public boolean isPerformExecute() {
        return this.performExecute;
    }

    public void setPerformExecute(boolean performExecute) {
        this.performExecute = performExecute;
    }

    @Override
    public T getEntity() {
        if (this.exception != null) {
            throw new RuntimeException("Unable to unmarshall response for " + this.attributeExceptionsTo, this.exception);
        }
        if (this.returnType == null) {
            throw new RuntimeException("No type information to extract entity with, use other getEntity() methods");
        }
        return (T)this.getEntity(this.returnType, this.genericReturnType);
    }

    @Override
    public <T2> T2 getEntity(Class<T2> type, Type genericType) {
        if (this.streamWasRead) {
            if (this.unmarshaledEntity != null) {
                if (type.isInstance(this.unmarshaledEntity)) {
                    return (T2)this.unmarshaledEntity;
                }
                throw new RuntimeException("The entity was already read, and it was of type " + this.unmarshaledEntity.getClass());
            }
            throw new RuntimeException("Stream was already read");
        }
        try {
            Object i$;
            MessageBodyReader<T2> reader;
            if (this.status == 204) {
                T2 T2 = null;
                return T2;
            }
            String mediaType = this.headers.getFirst("Content-Type");
            if (mediaType == null) {
                mediaType = this.alternateMediaType;
            }
            MediaType media = mediaType == null ? MediaType.WILDCARD_TYPE : MediaType.valueOf((String)mediaType);
            Annotation[] annotations = null;
            if (this.returnType == type && this.genericReturnType == genericType) {
                annotations = this.annotations;
            }
            if ((reader = this.providerFactory.getMessageBodyReader(type, genericType, annotations, media)) == null) {
                throw this.createResponseFailure("Unable to find a MessageBodyReader of content-type " + mediaType + " and type " + type.getName());
            }
            try {
                this.streamWasRead = true;
                this.unmarshaledEntity = reader.readFrom(type, genericType, annotations, media, this.headers, this.getInputStream());
                for (ClientInterceptor clientInterceptor : this.interceptors) {
                    clientInterceptor.postUnMarshalling(this);
                }
                i$ = this.unmarshaledEntity;
            }
            catch (Exception e) {
                this.exception = e;
                throw this.createResponseFailure("Failure reading from MessageBodyReader: " + reader.getClass().getName(), e);
            }
            return (T2)i$;
        }
        finally {
            this.releaseConnection();
        }
    }

    private InputStream getInputStream() throws IOException {
        return this.baseMethod.getResponseBodyAsStream();
    }

    @Override
    public <T2> T2 getEntity(GenericType<T2> genericType) {
        return this.getEntity(genericType.getType(), genericType.getGenericType());
    }

    @Override
    public MultivaluedMap<String, String> getHeaders() {
        return this.headers;
    }

    public MultivaluedMap<String, Object> getMetadata() {
        CaseInsensitiveMap<Object> map = this.headers;
        return map;
    }

    public int getStatus() {
        return this.status;
    }

    protected void finalize() throws Throwable {
        this.releaseConnection();
    }

    public String getRestVerb() {
        return this.restVerb;
    }

    public void setRestVerb(String restVerb) {
        this.restVerb = restVerb;
    }

    public void setUrl(String url) {
        this.url = url;
        for (ClientInterceptor clientInterceptor : this.interceptors) {
            clientInterceptor.preBaseMethodConstruction(this);
        }
        this.baseMethod = this.createBaseMethodHelper(url);
    }

    public int execute(HttpClient client) {
        try {
            for (ClientInterceptor clientInterceptor : this.interceptors) {
                clientInterceptor.preExecute(this);
            }
            if (this.performExecute) {
                this.status = client.executeMethod((HttpMethod)this.baseMethod);
                this.headers = ClientResponseImpl.extractHeaders(this.baseMethod);
                for (ClientInterceptor clientInterceptor : this.interceptors) {
                    clientInterceptor.postExecute(this);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to execute GET request: " + this.url, e);
        }
        return this.status;
    }

    public static CaseInsensitiveMap<String> extractHeaders(HttpMethodBase baseMethod) {
        CaseInsensitiveMap<String> headers = new CaseInsensitiveMap<String>();
        for (Header header : baseMethod.getResponseHeaders()) {
            headers.add(header.getName(), header.getValue());
        }
        return headers;
    }

    private HttpMethodBase createBaseMethodHelper(String url) {
        if ("GET".equals(this.restVerb)) {
            return new GetMethod(url);
        }
        if ("POST".equals(this.restVerb)) {
            return new PostMethod(url);
        }
        if ("PUT".equals(this.restVerb)) {
            return new PutMethod(url);
        }
        if ("DELETE".equals(this.restVerb)) {
            return new DeleteMethod(url);
        }
        return null;
    }

    public void checkFailureStatus() {
        if (this.status > 399 && this.status < 599) {
            throw this.createResponseFailure("Error status " + this.status + " " + Response.Status.fromStatusCode((int)this.status) + " returned");
        }
    }

    public ClientResponseFailure createResponseFailure(String message) {
        return this.createResponseFailure(message, null);
    }

    public ClientResponseFailure createResponseFailure(String message, Exception e) {
        this.setException(e);
        this.returnType = byte[].class;
        this.genericReturnType = null;
        return new ClientResponseFailure(message, e, this);
    }

    public void releaseConnection() {
        if (!this.wasReleased) {
            this.baseMethod.releaseConnection();
            this.wasReleased = true;
        }
    }

    @Override
    public Response.Status getResponseStatus() {
        return Response.Status.fromStatusCode((int)this.getStatus());
    }

    public boolean wasReleased() {
        return this.wasReleased;
    }
}

