/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.client.core;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.EntityEnclosingMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.jboss.resteasy.client.core.HttpClientHeaderWrapper;
import org.jboss.resteasy.client.core.Marshaller;
import org.jboss.resteasy.specimpl.UriBuilderImpl;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

public class MessageBodyParameterMarshaller
implements Marshaller {
    private Class type;
    private ResteasyProviderFactory factory;
    private MediaType mediaType;
    private Type genericType;
    private Annotation[] annotations;

    public MessageBodyParameterMarshaller(MediaType mediaType, Class type, Type genericType, Annotation[] annotations, ResteasyProviderFactory factory) {
        this.type = type;
        this.factory = factory;
        this.mediaType = mediaType;
        this.genericType = genericType;
        this.annotations = annotations;
    }

    public void buildUri(Object object, UriBuilderImpl uri) {
    }

    public void setHeaders(Object object, HttpMethodBase httpMethod) {
    }

    public void buildRequest(Object object, HttpMethodBase httpMethod) {
        MessageBodyWriter writer = this.getMessageBodyWriter();
        Object target = object;
        HttpClientHeaderWrapper wrapper = new HttpClientHeaderWrapper(httpMethod, this.factory);
        ClientRequestEntity body = new ClientRequestEntity(wrapper, writer, target);
        ((EntityEnclosingMethod)httpMethod).setRequestEntity((RequestEntity)body);
    }

    public MessageBodyWriter getMessageBodyWriter() {
        MessageBodyWriter writer = this.factory.getMessageBodyWriter(this.type, this.genericType, this.annotations, this.mediaType);
        if (writer == null) {
            throw new RuntimeException("Could not find MessageBodyWriter for class " + this.type.getName() + " and mediaType " + this.mediaType.toString());
        }
        return writer;
    }

    public Class getType() {
        return this.type;
    }

    public MediaType getMediaType() {
        return this.mediaType;
    }

    private class ClientRequestEntity
    implements RequestEntity {
        private final HttpClientHeaderWrapper wrapper;
        private final MessageBodyWriter writer;
        private final Object target;
        private byte[] bytes;

        public ClientRequestEntity(HttpClientHeaderWrapper wrapper, MessageBodyWriter writer, Object target) {
            this.wrapper = wrapper;
            this.writer = writer;
            this.target = target;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                writer.writeTo(target, MessageBodyParameterMarshaller.this.type, MessageBodyParameterMarshaller.this.genericType, MessageBodyParameterMarshaller.this.annotations, MessageBodyParameterMarshaller.this.mediaType, (MultivaluedMap)wrapper, (OutputStream)baos);
                this.bytes = baos.toByteArray();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public boolean isRepeatable() {
            return true;
        }

        public void writeRequest(OutputStream outputStream) throws IOException {
            outputStream.write(this.bytes);
        }

        public long getContentLength() {
            return this.bytes.length;
        }

        public String getContentType() {
            return MessageBodyParameterMarshaller.this.mediaType.toString();
        }
    }
}

