/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core;

import javax.annotation.security.DenyAll;
import javax.annotation.security.PermitAll;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.jboss.resteasy.core.ResourceMethod;
import org.jboss.resteasy.core.interception.ResourceMethodContext;
import org.jboss.resteasy.core.interception.ResourceMethodInterceptor;
import org.jboss.resteasy.spi.ApplicationException;
import org.jboss.resteasy.spi.Failure;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

public class ResourceMethodSecurityInterceptor
implements ResourceMethodInterceptor {
    protected String[] rolesAllowed;
    protected boolean denyAll;

    public boolean accepted(ResourceMethod resourceMethod) {
        RolesAllowed allowed = resourceMethod.getResourceClass().getAnnotation(RolesAllowed.class);
        RolesAllowed methodAllowed = resourceMethod.getMethod().getAnnotation(RolesAllowed.class);
        if (methodAllowed != null) {
            allowed = methodAllowed;
        }
        if (allowed != null) {
            this.rolesAllowed = allowed.value();
        }
        this.denyAll = resourceMethod.getResourceClass().isAnnotationPresent(DenyAll.class) && !resourceMethod.getMethod().isAnnotationPresent(RolesAllowed.class) && !resourceMethod.getMethod().isAnnotationPresent(PermitAll.class) || resourceMethod.getMethod().isAnnotationPresent(DenyAll.class);
        return this.rolesAllowed != null || this.denyAll;
    }

    public Response invoke(ResourceMethodContext ctx) throws Failure, ApplicationException, WebApplicationException {
        SecurityContext context;
        if (this.denyAll) {
            throw new Failure(401);
        }
        if (this.rolesAllowed != null && (context = ResteasyProviderFactory.getContextData(SecurityContext.class)) != null) {
            for (String role : this.rolesAllowed) {
                if (!context.isUserInRole(role)) continue;
                return ctx.proceed();
            }
            throw new Failure(401);
        }
        return ctx.proceed();
    }
}

