/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import org.jboss.resteasy.core.Dispatcher;
import org.jboss.resteasy.core.DispatcherUtilities;
import org.jboss.resteasy.core.ResourceInvoker;
import org.jboss.resteasy.core.ResourceMethodRegistry;
import org.jboss.resteasy.core.ResponseInvoker;
import org.jboss.resteasy.specimpl.PathSegmentImpl;
import org.jboss.resteasy.spi.ApplicationException;
import org.jboss.resteasy.spi.Failure;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.Registry;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.spi.UnhandledException;
import org.jboss.resteasy.util.LocaleHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynchronousDispatcher
implements Dispatcher {
    protected ResteasyProviderFactory providerFactory;
    protected Registry registry;
    protected Map<String, MediaType> mediaTypeMappings;
    protected Map<String, String> languageMappings;
    protected DispatcherUtilities dispatcherUtilities;
    private static final Logger logger = LoggerFactory.getLogger(SynchronousDispatcher.class);

    public SynchronousDispatcher(ResteasyProviderFactory providerFactory) {
        this.providerFactory = providerFactory;
        this.registry = new ResourceMethodRegistry(providerFactory);
        this.dispatcherUtilities = new DispatcherUtilities(providerFactory, this.registry);
    }

    @Override
    public ResteasyProviderFactory getProviderFactory() {
        return this.providerFactory;
    }

    @Override
    public Registry getRegistry() {
        return this.registry;
    }

    @Override
    public void setMediaTypeMappings(Map<String, MediaType> mediaTypeMappings) {
        this.mediaTypeMappings = mediaTypeMappings;
    }

    @Override
    public void setLanguageMappings(Map<String, String> languageMappings) {
        this.languageMappings = languageMappings;
    }

    @Override
    public Map<String, MediaType> getMediaTypeMappings() {
        return this.mediaTypeMappings;
    }

    @Override
    public Map<String, String> getLanguageMappings() {
        return this.languageMappings;
    }

    protected void preprocess(HttpRequest in) {
        this.preprocessExtensions(in);
    }

    protected void preprocessExtensions(HttpRequest in) {
        List segments = null;
        if (this.mediaTypeMappings != null || this.languageMappings != null) {
            int index;
            String path = in.getUri().getPath(false);
            int lastSegment = path.lastIndexOf(47);
            if (lastSegment < 0) {
                lastSegment = 0;
            }
            if ((index = path.indexOf(46, lastSegment)) < 0) {
                return;
            }
            boolean preprocessed = false;
            String extension = path.substring(index + 1);
            String[] extensions = extension.split("\\.");
            String rebuilt = path.substring(0, index);
            for (String ext : extensions) {
                Object match;
                if (this.mediaTypeMappings != null && (match = this.mediaTypeMappings.get(ext)) != null) {
                    in.getHttpHeaders().getAcceptableMediaTypes().add(0, match);
                    preprocessed = true;
                    continue;
                }
                if (this.languageMappings != null && (match = this.languageMappings.get(ext)) != null) {
                    in.getHttpHeaders().getAcceptableLanguages().add(LocaleHelper.extractLocale((String)match));
                    preprocessed = true;
                    continue;
                }
                rebuilt = rebuilt + "." + ext;
            }
            segments = preprocessed ? PathSegmentImpl.parseSegments(rebuilt) : in.getUri().getPathSegments(false);
        } else {
            segments = in.getUri().getPathSegments(false);
        }
        StringBuffer preprocessedPath = new StringBuffer();
        for (PathSegment pathSegment : segments) {
            preprocessedPath.append("/").append(pathSegment.getPath());
        }
        in.setPreprocessedPath(preprocessedPath.toString());
    }

    @Override
    public void invoke(HttpRequest request, HttpResponse response) {
        ResourceInvoker invoker = null;
        try {
            invoker = this.getInvoker(request, response);
        }
        catch (Failure e) {
            this.handleFailure(request, response, e);
            logger.info(e.getMessage());
            return;
        }
        if (invoker == null) {
            try {
                if (response.getStatus() != 500) {
                    response.sendError(404);
                }
            }
            catch (Exception e) {
                throw new UnhandledException(e);
            }
            logger.info("Could not match path: " + request.getUri().getPath());
            return;
        }
        this.invoke(request, response, invoker);
    }

    public ResourceInvoker getInvoker(HttpRequest request, HttpResponse response) throws Failure {
        logger.debug("PathInfo: " + request.getUri().getPath());
        if (!request.isInitial()) {
            try {
                logger.error(request.getUri().getPath() + " is not initial request.  Its suspended and retried.  Aborting.");
                response.sendError(500, request.getUri().getPath() + " is not initial request.  Its suspended and retried.  Aborting.");
            }
            catch (IOException e) {
                throw new UnhandledException(e);
            }
            return null;
        }
        this.preprocess(request);
        return this.registry.getResourceInvoker(request, response);
    }

    public void handleInvokerException(HttpRequest request, HttpResponse response, Exception e) {
        this.handleException(request, response, e);
    }

    public void handleWriteResponseException(HttpRequest request, HttpResponse response, Exception e) {
        this.handleException(request, response, e);
    }

    public void handleException(HttpRequest request, HttpResponse response, Exception e) {
        if (e instanceof WebApplicationException) {
            this.handleWebApplicationException(response, (WebApplicationException)((Object)e));
        } else if (e instanceof ApplicationException) {
            this.handleApplicationException(response, (ApplicationException)e);
        } else if (e instanceof Failure) {
            this.handleFailure(request, response, e);
        } else {
            logger.error("Unknown exception while executing " + request.getHttpMethod() + " " + request.getUri().getPath(), (Throwable)e);
            throw new UnhandledException(e);
        }
    }

    public void handleFailure(HttpRequest request, HttpResponse response, Exception e) {
        Failure failure = (Failure)e;
        if (failure.getResponse() != null) {
            try {
                this.writeJaxrsResponse(response, failure.getResponse());
            }
            catch (Exception e1) {
                throw new UnhandledException(e1);
            }
        }
        try {
            if (failure.getMessage() != null) {
                response.sendError(failure.getErrorCode(), failure.getMessage());
            } else {
                response.sendError(failure.getErrorCode());
            }
        }
        catch (IOException e1) {
            throw new UnhandledException(e1);
        }
        if (((Failure)e).isLoggable()) {
            logger.error("Failed executing " + request.getHttpMethod() + " " + request.getUri().getPath(), (Throwable)e);
        } else {
            logger.debug("Failed executing " + request.getHttpMethod() + " " + request.getUri().getPath(), (Throwable)e);
        }
    }

    public void handleApplicationException(HttpResponse response, ApplicationException e) {
        if (e.getCause() instanceof WebApplicationException) {
            this.handleWebApplicationException(response, (WebApplicationException)e.getCause());
            return;
        }
        ExceptionMapper<?> mapper = null;
        Class<?> causeClass = e.getCause().getClass();
        while (mapper == null && causeClass != null) {
            mapper = this.providerFactory.getExceptionMapper(causeClass);
            if (mapper != null) continue;
            causeClass = causeClass.getSuperclass();
        }
        if (mapper != null) {
            try {
                this.writeJaxrsResponse(response, mapper.toResponse(e.getCause()));
            }
            catch (WebApplicationException ex) {
                if (response.isCommitted()) {
                    throw new UnhandledException("Request was committed couldn't handle exception", ex);
                }
                response.reset();
                response.setStatus(ex.getResponse().getStatus());
                logger.error("Failed to write exception response", (Throwable)ex);
            }
            catch (Exception e1) {
                throw new UnhandledException(e1);
            }
        } else {
            throw new UnhandledException(e.getCause());
        }
    }

    public void handleWebApplicationException(HttpResponse response, WebApplicationException wae) {
        logger.error("failed to execute", (Throwable)wae);
        if (response.isCommitted()) {
            throw new UnhandledException("Request was committed couldn't handle exception", wae);
        }
        response.reset();
        try {
            this.writeJaxrsResponse(response, wae.getResponse());
        }
        catch (WebApplicationException ex) {
            if (response.isCommitted()) {
                throw new UnhandledException("Request was committed couldn't handle exception", ex);
            }
            response.reset();
            response.setStatus(ex.getResponse().getStatus());
        }
        catch (Exception e1) {
            throw new UnhandledException(e1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(HttpRequest request, HttpResponse response, ResourceInvoker invoker) {
        try {
            this.getDispatcherUtilities().pushContextObjects(request, response);
            Response jaxrsResponse = null;
            try {
                jaxrsResponse = this.getDispatcherUtilities().getJaxrsResponse(request, response, invoker);
            }
            catch (Exception e) {
                this.handleInvokerException(request, response, e);
            }
            try {
                if (jaxrsResponse != null) {
                    this.writeJaxrsResponse(response, jaxrsResponse);
                }
            }
            catch (Exception e) {
                this.handleWriteResponseException(request, response, e);
            }
        }
        finally {
            this.getDispatcherUtilities().clearContextData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void asynchronousDelivery(HttpRequest request, HttpResponse response, Response jaxrsResponse) {
        try {
            this.getDispatcherUtilities().pushContextObjects(request, response);
            try {
                if (jaxrsResponse != null) {
                    this.writeJaxrsResponse(response, jaxrsResponse);
                }
            }
            catch (Exception e) {
                this.handleWriteResponseException(request, response, e);
            }
        }
        finally {
            this.getDispatcherUtilities().clearContextData();
        }
    }

    protected void writeJaxrsResponse(HttpResponse response, Response jaxrsResponse) throws IOException, WebApplicationException {
        ResponseInvoker responseInvoker = this.dispatcherUtilities.resolveResponseInvoker(response, jaxrsResponse);
        if (responseInvoker != null) {
            responseInvoker.writeTo(response);
        }
    }

    public DispatcherUtilities getDispatcherUtilities() {
        return this.dispatcherUtilities;
    }

    public void setDispatcherUtilities(DispatcherUtilities dispatcherUtilities) {
        this.dispatcherUtilities = dispatcherUtilities;
    }
}

