/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.client;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.MediaType;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethodBase;
import org.jboss.resteasy.client.ClientResponse;
import org.jboss.resteasy.client.core.ClientInterceptor;
import org.jboss.resteasy.client.core.ClientResponseImpl;
import org.jboss.resteasy.client.core.CookieParamMarshaller;
import org.jboss.resteasy.client.core.FormParamMarshaller;
import org.jboss.resteasy.client.core.HeaderParamMarshaller;
import org.jboss.resteasy.client.core.Marshaller;
import org.jboss.resteasy.client.core.MessageBodyParameterMarshaller;
import org.jboss.resteasy.client.core.PathParamMarshaller;
import org.jboss.resteasy.client.core.QueryParamMarshaller;
import org.jboss.resteasy.client.core.WebRequestIntializer;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientRequest {
    protected ResteasyProviderFactory providerFactory;
    private String uriTemplate;
    private HttpClient httpClient;
    private Collection<ClientInterceptor> interceptors = new ArrayList<ClientInterceptor>();
    private List<Marshaller> marshallers = new ArrayList<Marshaller>();
    private List<Object> args = new ArrayList<Object>();

    public ClientRequest(String uriTemplate) {
        this(uriTemplate, new HttpClient(), ResteasyProviderFactory.getInstance());
    }

    public ClientRequest(String uriTemplate, HttpClient httpClient) {
        this(uriTemplate, httpClient, ResteasyProviderFactory.getInstance());
    }

    public ClientRequest(String uriTemplate, HttpClient httpClient, ResteasyProviderFactory providerFactory) {
        this.uriTemplate = uriTemplate;
        this.httpClient = httpClient;
        this.providerFactory = providerFactory;
    }

    public ClientRequest interceptor(ClientInterceptor clientInterceptor) {
        this.interceptors.add(clientInterceptor);
        return this;
    }

    public ClientRequest interceptors(Collection<ClientInterceptor> clientInterceptors) {
        this.interceptors.addAll(clientInterceptors);
        return this;
    }

    public ClientRequest accept(MediaType accepts) {
        return this.header("Accept", accepts.toString());
    }

    public ClientRequest accept(String accept) {
        return this.header("Accept", accept);
    }

    public ClientRequest formParameter(String parameterName, Object value) {
        return this.marshaller(new FormParamMarshaller(parameterName, this.providerFactory), value);
    }

    public ClientRequest queryParameter(String parameterName, Object value) {
        return this.marshaller(new QueryParamMarshaller(parameterName, this.providerFactory), value);
    }

    public ClientRequest header(String headerName, Object value) {
        return this.marshaller(new HeaderParamMarshaller(headerName, this.providerFactory), value);
    }

    public ClientRequest cookie(String cookieName, Object value) {
        return this.marshaller(new CookieParamMarshaller(cookieName), value);
    }

    public ClientRequest cookie(Cookie cookie) {
        return this.marshaller(new CookieParamMarshaller(null), cookie);
    }

    public ClientRequest pathParameter(String parameterName, Object value) {
        return this.pathParameter(parameterName, value, false);
    }

    public ClientRequest pathParameter(String parameterName, Object value, boolean encoded) {
        return this.marshaller(new PathParamMarshaller(parameterName, encoded, this.providerFactory), value);
    }

    public ClientRequest marshaller(Marshaller marshaller, Object value) {
        this.marshallers.add(marshaller);
        this.args.add(value);
        return this;
    }

    public ClientRequest body(String contentType, Object data) {
        MessageBodyParameterMarshaller marshaller = new MessageBodyParameterMarshaller(MediaType.valueOf((String)contentType), data.getClass(), null, null, this.providerFactory);
        return this.marshaller(marshaller, data);
    }

    public ClientResponse<byte[]> get() throws Exception {
        return this.get(byte[].class);
    }

    public <T> ClientResponse<T> get(Class<T> returnType) throws Exception {
        return (ClientResponse)((Object)this.getResponse(returnType, null, true, "GET"));
    }

    public ClientResponse<Void> post() throws Exception {
        return this.post(Void.class);
    }

    public <T> ClientResponse<T> post(Class<T> returnType) throws Exception {
        return (ClientResponse)((Object)this.getResponse(returnType, null, true, "POST"));
    }

    public ClientResponse<Void> put() throws Exception {
        return this.put(Void.class);
    }

    public <T> ClientResponse<T> put(Class<T> returnType) throws Exception {
        return (ClientResponse)((Object)this.getResponse(returnType, null, true, "PUT"));
    }

    public ClientResponse<Void> delete() throws Exception {
        return this.delete(Void.class);
    }

    public <T> ClientResponse<T> delete(Class<T> returnType) throws Exception {
        return (ClientResponse)((Object)this.getResponse(returnType, null, true, "DELETE"));
    }

    private <T> Object getResponse(Class<T> returnType, Type genericReturnType, boolean isClientResponse, String restVerb) throws Exception {
        ClientResponseImpl<T> clientResponse = this.createResponseImpl(restVerb, returnType, genericReturnType);
        WebRequestIntializer urlRetriever = new WebRequestIntializer(this.marshallers.toArray(new Marshaller[this.marshallers.size()]));
        clientResponse.setUrl(urlRetriever.buildUrl(this.uriTemplate, true, this.args.toArray()));
        HttpMethodBase baseMethod = clientResponse.getHttpBaseMethod();
        if (isClientResponse) {
            baseMethod.setFollowRedirects(false);
        }
        urlRetriever.setHeadersAndRequestBody(baseMethod, this.args.toArray());
        clientResponse.execute(this.httpClient);
        if (isClientResponse) {
            return clientResponse;
        }
        if (returnType == null || returnType.equals(Void.TYPE)) {
            clientResponse.releaseConnection();
            return null;
        }
        return clientResponse.getEntity();
    }

    private <T> ClientResponseImpl<T> createResponseImpl(String restVerb, Class<T> returnType, Type genericReturnType) throws Exception {
        ClientResponseImpl<T> clientResponse = new ClientResponseImpl<T>();
        clientResponse.setReturnType(returnType);
        clientResponse.setGenericReturnType(genericReturnType);
        clientResponse.setProviderFactory(this.providerFactory);
        clientResponse.setRestVerb(restVerb);
        clientResponse.setAttributeExceptionsTo("WebRequest");
        clientResponse.setInterceptors(this.interceptors);
        return clientResponse;
    }
}

