/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.client.core;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URI;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Providers;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethodBase;
import org.jboss.resteasy.annotations.ClientResponseType;
import org.jboss.resteasy.client.ClientResponse;
import org.jboss.resteasy.client.EntityTypeFactory;
import org.jboss.resteasy.client.core.ClientInterceptor;
import org.jboss.resteasy.client.core.ClientMarshallerFactory;
import org.jboss.resteasy.client.core.ClientResponseImpl;
import org.jboss.resteasy.client.core.Marshaller;
import org.jboss.resteasy.client.core.WebRequestIntializer;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.util.MediaTypeHelper;
import org.jboss.resteasy.util.Types;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientInvoker {
    protected ResteasyProviderFactory providerFactory;
    private String restVerb;
    protected WebRequestIntializer urlRetriever;
    protected URI uri;
    private Method method;
    protected Class<?> declaring;
    protected MediaType accepts;
    protected HttpClient client;
    private Iterable<ClientInterceptor> interceptors;

    public ClientInvoker(Class<?> declaring, Method method, ResteasyProviderFactory providerFactory, HttpClient client, Iterable<ClientInterceptor> interceptors) {
        this.declaring = declaring;
        this.method = method;
        Marshaller[] marshallers = ClientMarshallerFactory.createMarshallers(method, providerFactory);
        this.providerFactory = providerFactory;
        this.urlRetriever = new WebRequestIntializer(marshallers);
        this.accepts = MediaTypeHelper.getProduces(declaring, method);
        this.client = client;
        this.interceptors = interceptors;
    }

    public void setBaseUri(URI uri) {
        this.uri = uri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Object[] args) {
        boolean isProvidersSet;
        boolean bl = isProvidersSet = ResteasyProviderFactory.getContextData(Providers.class) != null;
        if (!isProvidersSet) {
            ResteasyProviderFactory.pushContext(Providers.class, this.providerFactory);
        }
        try {
            Object extractedEntity;
            if (this.uri == null) {
                throw new RuntimeException("You have not set a base URI for the client proxy");
            }
            ClientResponseImpl clientResponse = this.createClientResponse(args);
            this.initBaseMethod(args, clientResponse);
            clientResponse.execute(this.client);
            Object object = extractedEntity = this.extractEntity(clientResponse);
            return object;
        }
        finally {
            if (!isProvidersSet) {
                ResteasyProviderFactory.popContextData(Providers.class);
            }
        }
    }

    private ClientResponseImpl createClientResponse(Object[] args) {
        ClientResponseImpl clientResponse = new ClientResponseImpl();
        clientResponse.setProviderFactory(this.providerFactory);
        clientResponse.setRestVerb(this.restVerb);
        clientResponse.setAttributeExceptionsTo(this.method.toString());
        if (this.interceptors != null) {
            clientResponse.setInterceptors(this.interceptors);
        }
        String url = this.urlRetriever.buildUrl(this.uri, false, this.method, args);
        clientResponse.setUrl(url);
        return clientResponse;
    }

    private void initBaseMethod(Object[] args, ClientResponseImpl clientResponse) {
        HttpMethodBase baseMethod = clientResponse.getHttpBaseMethod();
        boolean isClientResponseResult = ClientResponse.class.isAssignableFrom(this.method.getReturnType());
        if (isClientResponseResult) {
            baseMethod.setFollowRedirects(false);
        }
        if (this.accepts != null) {
            baseMethod.setRequestHeader("Accept", this.accepts.toString());
        }
        this.urlRetriever.setHeadersAndRequestBody(baseMethod, args);
    }

    private Object extractEntity(ClientResponseImpl clientResponse) {
        Class<?> returnType = this.method.getReturnType();
        if (ClientResponse.class.isAssignableFrom(returnType)) {
            Type methodGenericReturnType = this.method.getGenericReturnType();
            if (methodGenericReturnType instanceof ParameterizedType) {
                ParameterizedType zType = (ParameterizedType)methodGenericReturnType;
                Type genericReturnType = zType.getActualTypeArguments()[0];
                clientResponse.setReturnType(Types.getRawType(genericReturnType));
                clientResponse.setGenericReturnType(genericReturnType);
            }
            clientResponse.setAnnotations(this.method.getAnnotations());
            return clientResponse;
        }
        if (returnType.equals(Response.Status.class)) {
            clientResponse.releaseConnection();
            return clientResponse.getResponseStatus();
        }
        if (Response.class.isAssignableFrom(returnType)) {
            ClientResponseType responseHint = this.method.getAnnotation(ClientResponseType.class);
            if (responseHint != null) {
                this.handleResponseHint(clientResponse, responseHint);
            } else {
                clientResponse.releaseConnection();
            }
            return clientResponse;
        }
        clientResponse.checkFailureStatus();
        if (returnType == null || this.isVoidReturnType(returnType)) {
            clientResponse.releaseConnection();
            return null;
        }
        clientResponse.setReturnType(returnType);
        clientResponse.setGenericReturnType(this.method.getGenericReturnType());
        if (clientResponse.getContentType() == null) {
            Produces produce = this.method.getAnnotation(Produces.class);
            if (produce == null) {
                produce = this.declaring.getAnnotation(Produces.class);
            }
            if (produce == null) {
                throw clientResponse.createResponseFailure("@Produces on your proxy method, " + this.method.toString() + ", is required");
            }
            clientResponse.setAlternateMediaType(produce.value()[0]);
        }
        return clientResponse.getEntity();
    }

    private boolean isVoidReturnType(Class<?> returnType) {
        return Void.TYPE.equals(returnType) || Void.class.equals(returnType);
    }

    private void handleResponseHint(ClientResponseImpl clientResponse, ClientResponseType responseHint) {
        Class returnType = responseHint.entityType();
        Class<? extends EntityTypeFactory> entityTypeFactory = responseHint.entityTypeFactory();
        if (this.isVoidReturnType(returnType)) {
            EntityTypeFactory factory = null;
            try {
                factory = entityTypeFactory.newInstance();
            }
            catch (InstantiationException e) {
                throw clientResponse.createResponseFailure("Could not create a default entity type factory of type " + entityTypeFactory.getClass().getName());
            }
            catch (IllegalAccessException e) {
                throw clientResponse.createResponseFailure("Could not create a default entity type factory of type " + entityTypeFactory.getClass().getName() + ". " + e.getMessage());
            }
            returnType = factory.getEntityType(clientResponse.getStatus(), clientResponse.getMetadata());
        }
        if (!this.isVoidReturnType(returnType)) {
            clientResponse.setReturnType(returnType);
        }
    }

    public String getRestVerb() {
        return this.restVerb;
    }

    public void setRestVerb(String restVerb) {
        this.restVerb = restVerb;
    }
}

