/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core.interception;

import java.util.ArrayList;
import java.util.List;
import org.jboss.resteasy.core.ResourceMethod;
import org.jboss.resteasy.core.interception.ResourceMethodInterceptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterceptorRegistry {
    private List<Class> perResourceMethodInterceptorClasses = new ArrayList<Class>();
    private List<ResourceMethodInterceptor> resourceMethodIntercptors = new ArrayList<ResourceMethodInterceptor>();

    public List<Class> getPerResourceMethodInterceptorClasses() {
        return this.perResourceMethodInterceptorClasses;
    }

    public List<ResourceMethodInterceptor> getResourceMethodIntercptors() {
        return this.resourceMethodIntercptors;
    }

    public void registerResourceMethodInterceptor(Class clazz) {
        this.perResourceMethodInterceptorClasses.add(clazz);
    }

    public void registerResourceMethodInterceptors(Class[] classes) {
        for (Class clazz : classes) {
            this.registerResourceMethodInterceptor(clazz);
        }
    }

    public void registerResourceMethodInterceptor(ResourceMethodInterceptor interceptor) {
        this.resourceMethodIntercptors.add(interceptor);
    }

    public ResourceMethodInterceptor[] bind(ResourceMethod method) {
        ArrayList<ResourceMethodInterceptor> list = new ArrayList<ResourceMethodInterceptor>();
        for (Class clazz : this.perResourceMethodInterceptorClasses) {
            ResourceMethodInterceptor interceptor = null;
            try {
                interceptor = (ResourceMethodInterceptor)clazz.newInstance();
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            if (!interceptor.accepted(method)) continue;
            list.add(interceptor);
        }
        for (ResourceMethodInterceptor interceptor : this.resourceMethodIntercptors) {
            if (!interceptor.accepted(method)) continue;
            list.add(interceptor);
        }
        return list.toArray(new ResourceMethodInterceptor[0]);
    }
}

