/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PathHelper {
    public static final String URI_PARAM_NAME_REGEX = "\\w[\\w\\.-]*";
    public static final String URI_PARAM_REGEX_REGEX = "[^{}][^{}]*";
    public static final String URI_PARAM_REGEX = "\\{\\s*(\\w[\\w\\.-]*)\\s*(:\\s*([^{}][^{}]*))?\\}";
    public static final String URI_PARAM_WITH_REGEX = "\\{\\s*(\\w[\\w\\.-]*)\\s*(:\\s*([^{}][^{}]*))\\}";
    public static final String URI_PARAM_WITHOUT_REGEX = "\\{(\\w[\\w\\.-]*)\\}";
    public static final Pattern URI_PARAM_PATTERN = Pattern.compile("\\{\\s*(\\w[\\w\\.-]*)\\s*(:\\s*([^{}][^{}]*))?\\}");
    public static final Pattern URI_PARAM_WITH_REGEX_PATTERN = Pattern.compile("\\{\\s*(\\w[\\w\\.-]*)\\s*(:\\s*([^{}][^{}]*))\\}");
    public static final Pattern URI_PARAM_WITHOUT_REGEX_PATTERN = Pattern.compile("\\{(\\w[\\w\\.-]*)\\}");
    public static final Pattern URI_TEMPLATE_PATTERN = Pattern.compile("(\\{([^}]+)\\})");
    public static final String URI_TEMPLATE_REPLACE_PATTERN = "(.*?)";

    public static String createRegularExpressionFromPathExpression(String path) {
        Matcher matcher = URI_TEMPLATE_PATTERN.matcher(path);
        StringBuffer regex = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(regex, Matcher.quoteReplacement(URI_TEMPLATE_REPLACE_PATTERN));
        }
        matcher.appendTail(regex);
        return regex.append("$").toString();
    }

    public static String getEncodedPathInfo(String path, String contextPath) {
        if (contextPath != null && !"".equals(contextPath) && path.startsWith(contextPath)) {
            path = path.substring(contextPath.length());
        }
        return path;
    }

    public static String uriParam(String path, String name, String value) {
        Matcher matcher = URI_PARAM_PATTERN.matcher(path);
        StringBuffer newPath = new StringBuffer();
        while (matcher.find()) {
            String param = matcher.group(1);
            if (param.equals(name)) {
                matcher.appendReplacement(newPath, value);
                matcher.appendTail(newPath);
                path = newPath.toString();
                return path;
            }
            matcher.appendReplacement(newPath, "$0");
        }
        matcher.appendTail(newPath);
        path = newPath.toString();
        return path;
    }

    public static void main(String[] args) throws Exception {
    }
}

