/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.util;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Types {
    public static Type getGenericReturnTypeOfGenericInterfaceMethod(Class clazz, Method method) {
        if (!method.getDeclaringClass().isInterface()) {
            return method.getGenericReturnType();
        }
        try {
            Method tmp = clazz.getMethod(method.getName(), method.getParameterTypes());
            return tmp.getGenericReturnType();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return method.getGenericReturnType();
        }
    }

    public static Type[] getGenericParameterTypesOfGenericInterfaceMethod(Class clazz, Method method) {
        if (!method.getDeclaringClass().isInterface()) {
            return method.getGenericParameterTypes();
        }
        try {
            Method tmp = clazz.getMethod(method.getName(), method.getParameterTypes());
            return tmp.getGenericParameterTypes();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return method.getGenericParameterTypes();
        }
    }

    public static Class<?> getRawType(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type rawType = parameterizedType.getRawType();
            return (Class)rawType;
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType genericArrayType = (GenericArrayType)type;
            Class<?> componentRawType = Types.getRawType(genericArrayType.getGenericComponentType());
            return Array.newInstance(componentRawType, 0).getClass();
        }
        throw new RuntimeException("Unable to determine base class from Type");
    }

    public static Class<?> getTypeArgument(Type genericType) {
        if (!(genericType instanceof ParameterizedType)) {
            return null;
        }
        ParameterizedType parameterizedType = (ParameterizedType)genericType;
        Class typeArg = (Class)parameterizedType.getActualTypeArguments()[0];
        return typeArg;
    }

    public static Class getCollectionBaseType(Class type, Type genericType) {
        if (genericType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)genericType;
            Type componentGenericType = parameterizedType.getActualTypeArguments()[0];
            return Types.getRawType(componentGenericType);
        }
        if (genericType instanceof GenericArrayType) {
            GenericArrayType genericArrayType = (GenericArrayType)genericType;
            Type componentGenericType = genericArrayType.getGenericComponentType();
            return Types.getRawType(componentGenericType);
        }
        if (type.isArray()) {
            return type.getComponentType();
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TypeInfo {
        private Class<?> type;
        private Type genericType;

        public TypeInfo(Class<?> type, Type genericType) {
            this.type = type;
            this.genericType = genericType;
        }

        public Class<?> getType() {
            return this.type;
        }

        public Type getGenericType() {
            return this.genericType;
        }
    }
}

