/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.client;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.RuntimeDelegate;
import org.apache.commons.httpclient.HttpClient;
import org.jboss.resteasy.client.ClientExecutor;
import org.jboss.resteasy.client.ClientResponse;
import org.jboss.resteasy.client.core.ApacheHttpClientExecutor;
import org.jboss.resteasy.client.core.BaseClientResponse;
import org.jboss.resteasy.core.interception.ClientExecutionContextImpl;
import org.jboss.resteasy.core.interception.ClientExecutionInterceptor;
import org.jboss.resteasy.core.interception.MessageBodyReaderInterceptor;
import org.jboss.resteasy.core.interception.MessageBodyWriterContextImpl;
import org.jboss.resteasy.core.interception.MessageBodyWriterInterceptor;
import org.jboss.resteasy.specimpl.MultivaluedMapImpl;
import org.jboss.resteasy.specimpl.UriBuilderImpl;
import org.jboss.resteasy.spi.ProviderFactoryDelegate;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.spi.StringConverter;
import org.jboss.resteasy.util.GenericType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientRequest {
    protected ResteasyProviderFactory providerFactory;
    private UriBuilderImpl uri;
    private ClientExecutor executor;
    private MultivaluedMap<String, String> headers;
    private MultivaluedMap<String, String> queryParameters;
    private MultivaluedMap<String, String> formParameters;
    private MultivaluedMap<String, String> pathParameters;
    private MultivaluedMap<String, String> matrixParameters;
    private Object body;
    private Class bodyType;
    private Type bodyGenericType;
    private Annotation[] bodyAnnotations;
    private MediaType bodyContentType;
    private boolean followRedirects;
    private MessageBodyReaderInterceptor[] readerInterceptors;
    private MessageBodyWriterInterceptor[] writerInterceptors;
    private ClientExecutionInterceptor[] executionInterceptors;
    private MessageBodyWriter writer;
    private String httpMethod;
    private String finalUri;

    public ClientRequest(String uriTemplate) {
        this(uriTemplate, new HttpClient(), ResteasyProviderFactory.getInstance());
    }

    public ClientRequest(String uriTemplate, HttpClient httpClient) {
        this(uriTemplate, httpClient, ResteasyProviderFactory.getInstance());
    }

    public ClientRequest(String uriTemplate, HttpClient httpClient, ResteasyProviderFactory providerFactory) {
        this(new UriBuilderImpl().uriTemplate(uriTemplate), new ApacheHttpClientExecutor(httpClient), providerFactory);
    }

    public ClientRequest(UriBuilder uri, ClientExecutor executor, ResteasyProviderFactory providerFactory) {
        this.uri = (UriBuilderImpl)uri;
        this.executor = executor;
        if (providerFactory instanceof ProviderFactoryDelegate) {
            providerFactory = ((ProviderFactoryDelegate)((Object)providerFactory)).getDelegate();
        }
        this.providerFactory = providerFactory;
    }

    public boolean followRedirects() {
        return this.followRedirects;
    }

    public ClientRequest followRedirects(boolean followRedirects) {
        this.followRedirects = followRedirects;
        return this;
    }

    public MessageBodyReaderInterceptor[] getReaderInterceptors() {
        return this.readerInterceptors;
    }

    public MessageBodyWriterInterceptor[] getWriterInterceptors() {
        return this.writerInterceptors;
    }

    public ClientExecutionInterceptor[] getExecutionInterceptors() {
        return this.executionInterceptors;
    }

    public void setReaderInterceptors(MessageBodyReaderInterceptor[] readerInterceptors) {
        this.readerInterceptors = readerInterceptors;
    }

    public void setWriterInterceptors(MessageBodyWriterInterceptor[] writerInterceptors) {
        this.writerInterceptors = writerInterceptors;
    }

    public void setExecutionInterceptors(ClientExecutionInterceptor[] executionInterceptors) {
        this.executionInterceptors = executionInterceptors;
    }

    public ClientRequest accept(MediaType accepts) {
        return this.header("Accept", accepts.toString());
    }

    public ClientRequest accept(String accept) {
        String curr = (String)this.getHeaders().getFirst((Object)"Accept");
        curr = curr != null ? curr + "," + accept : accept;
        this.getHeaders().putSingle((Object)"Accept", (Object)curr);
        return this;
    }

    protected String toString(Object object) {
        if (object instanceof String) {
            return (String)object;
        }
        StringConverter converter = this.providerFactory.getStringConverter(object.getClass());
        if (converter != null) {
            return converter.toString(object);
        }
        return object.toString();
    }

    protected String toHeaderString(Object object) {
        StringConverter converter = this.providerFactory.getStringConverter(object.getClass());
        if (converter != null) {
            return converter.toString(object);
        }
        RuntimeDelegate.HeaderDelegate<?> delegate = this.providerFactory.createHeaderDelegate(object.getClass());
        if (delegate != null) {
            return delegate.toString(object);
        }
        return object.toString();
    }

    public ClientRequest formParameter(String parameterName, Object value) {
        this.getFormParameters().add((Object)parameterName, (Object)this.toString(value));
        return this;
    }

    public ClientRequest queryParameter(String parameterName, Object value) {
        this.getQueryParameters().add((Object)parameterName, (Object)this.toString(value));
        return this;
    }

    public ClientRequest matrixParameter(String parameterName, Object value) {
        this.getMatrixParameters().add((Object)parameterName, (Object)this.toString(value));
        return this;
    }

    public ClientRequest header(String headerName, Object value) {
        this.getHeaders().add((Object)headerName, (Object)this.toHeaderString(value));
        return this;
    }

    public ClientRequest cookie(String cookieName, Object value) {
        return this.cookie(new Cookie(cookieName, this.toString(value)));
    }

    public ClientRequest cookie(Cookie cookie) {
        return this.header("Cookie", cookie.toString());
    }

    public ClientRequest pathParameter(String parameterName, Object value) {
        this.getPathParameters().add((Object)parameterName, (Object)this.toString(value));
        return this;
    }

    public ClientRequest body(String contentType, Object data) {
        return this.body(MediaType.valueOf((String)contentType), data, data.getClass(), null, null);
    }

    public ClientRequest body(MediaType contentType, Object data) {
        return this.body(contentType, data, data.getClass(), null, null);
    }

    public ClientRequest body(MediaType contentType, Object data, GenericType genericType) {
        return this.body(contentType, data, genericType.getType(), genericType.getGenericType(), null);
    }

    public ClientRequest body(MediaType contentType, Object data, Type genericType) {
        return this.body(contentType, data, data.getClass(), genericType, null);
    }

    public ClientRequest body(MediaType contentType, Object data, Class type, Type genericType, Annotation[] annotations) {
        this.body = data;
        this.bodyContentType = contentType;
        this.bodyGenericType = genericType;
        this.bodyType = type;
        this.bodyAnnotations = annotations;
        return this;
    }

    public ResteasyProviderFactory getProviderFactory() {
        return this.providerFactory;
    }

    public ClientExecutor getExecutor() {
        return this.executor;
    }

    public MultivaluedMap<String, String> getHeaders() {
        if (this.headers == null) {
            this.headers = new MultivaluedMapImpl<String, String>();
        }
        return this.headers;
    }

    public MultivaluedMap<String, String> getQueryParameters() {
        if (this.queryParameters == null) {
            this.queryParameters = new MultivaluedMapImpl<String, String>();
        }
        return this.queryParameters;
    }

    public MultivaluedMap<String, String> getFormParameters() {
        if (this.formParameters == null) {
            this.formParameters = new MultivaluedMapImpl<String, String>();
        }
        return this.formParameters;
    }

    public MultivaluedMap<String, String> getPathParameters() {
        if (this.pathParameters == null) {
            this.pathParameters = new MultivaluedMapImpl<String, String>();
        }
        return this.pathParameters;
    }

    public MultivaluedMap<String, String> getMatrixParameters() {
        if (this.matrixParameters == null) {
            this.matrixParameters = new MultivaluedMapImpl<String, String>();
        }
        return this.matrixParameters;
    }

    public Object getBody() {
        return this.body;
    }

    public Class getBodyType() {
        return this.bodyType;
    }

    public Type getBodyGenericType() {
        return this.bodyGenericType;
    }

    public Annotation[] getBodyAnnotations() {
        return this.bodyAnnotations;
    }

    public MediaType getBodyContentType() {
        return this.bodyContentType;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public void setHttpMethod(String httpMethod) {
        this.httpMethod = httpMethod;
    }

    public ClientResponse execute() throws Exception {
        if (this.readerInterceptors == null) {
            this.readerInterceptors = this.providerFactory.getClientMessageBodyReaderInterceptorRegistry().bind(null, null);
        }
        if (this.executionInterceptors == null) {
            this.executionInterceptors = this.providerFactory.getClientExecutionInterceptorRegistry().bind(null, null);
        }
        BaseClientResponse response = null;
        if (this.executionInterceptors == null || this.executionInterceptors.length == 0) {
            response = (BaseClientResponse)this.executor.execute(this);
        } else {
            ClientExecutionContextImpl ctx = new ClientExecutionContextImpl(this.executionInterceptors, this.executor, this);
            response = (BaseClientResponse)ctx.proceed();
        }
        response.setMessageBodyReaderInterceptors(this.readerInterceptors);
        return response;
    }

    public void writeRequestBody(MultivaluedMap<String, Object> headers, OutputStream outputStream) throws IOException {
        if (this.body == null) {
            return;
        }
        if (this.writerInterceptors == null) {
            this.writerInterceptors = this.providerFactory.getClientMessageBodyWriterInterceptorRegistry().bind(null, null);
        }
        if (this.writer == null) {
            this.writer = this.providerFactory.getMessageBodyWriter(this.getBodyType(), this.getBodyGenericType(), this.getBodyAnnotations(), this.getBodyContentType());
        }
        if (this.writerInterceptors != null && this.writerInterceptors.length > 0) {
            MessageBodyWriterContextImpl ctx = new MessageBodyWriterContextImpl(this.writerInterceptors, this.writer, this.body, this.bodyType, this.bodyGenericType, this.bodyAnnotations, this.bodyContentType, headers, outputStream);
            ctx.proceed();
        } else {
            this.writer.writeTo(this.body, this.bodyType, this.bodyGenericType, this.bodyAnnotations, this.bodyContentType, headers, outputStream);
        }
    }

    public ClientResponse get() throws Exception {
        return this.httpMethod("GET");
    }

    public <T> ClientResponse<T> get(Class<T> returnType) throws Exception {
        BaseClientResponse response = (BaseClientResponse)this.get();
        response.setReturnType(returnType);
        return response;
    }

    public <T> ClientResponse<T> get(Class<T> returnType, Type genericType) throws Exception {
        BaseClientResponse response = (BaseClientResponse)this.get();
        response.setReturnType(returnType);
        response.setGenericReturnType(genericType);
        return response;
    }

    public <T> ClientResponse<T> get(GenericType type) throws Exception {
        BaseClientResponse response = (BaseClientResponse)this.get();
        response.setReturnType(type.getType());
        response.setGenericReturnType(type.getGenericType());
        return response;
    }

    public ClientResponse head() throws Exception {
        return this.httpMethod("HEAD");
    }

    public ClientResponse put() throws Exception {
        return this.httpMethod("PUT");
    }

    public <T> ClientResponse<T> put(Class<T> returnType) throws Exception {
        BaseClientResponse response = (BaseClientResponse)this.put();
        response.setReturnType(returnType);
        return response;
    }

    public <T> ClientResponse<T> put(Class<T> returnType, Type genericType) throws Exception {
        BaseClientResponse response = (BaseClientResponse)this.put();
        response.setReturnType(returnType);
        response.setGenericReturnType(genericType);
        return response;
    }

    public <T> ClientResponse<T> put(GenericType type) throws Exception {
        BaseClientResponse response = (BaseClientResponse)this.put();
        response.setReturnType(type.getType());
        response.setGenericReturnType(type.getGenericType());
        return response;
    }

    public ClientResponse post() throws Exception {
        return this.httpMethod("POST");
    }

    public <T> ClientResponse<T> post(Class<T> returnType) throws Exception {
        BaseClientResponse response = (BaseClientResponse)this.post();
        response.setReturnType(returnType);
        return response;
    }

    public <T> ClientResponse<T> post(Class<T> returnType, Type genericType) throws Exception {
        BaseClientResponse response = (BaseClientResponse)this.post();
        response.setReturnType(returnType);
        response.setGenericReturnType(genericType);
        return response;
    }

    public <T> ClientResponse<T> post(GenericType type) throws Exception {
        BaseClientResponse response = (BaseClientResponse)this.post();
        response.setReturnType(type.getType());
        response.setGenericReturnType(type.getGenericType());
        return response;
    }

    public ClientResponse delete() throws Exception {
        return this.httpMethod("DELETE");
    }

    public <T> ClientResponse<T> delete(Class<T> returnType) throws Exception {
        BaseClientResponse response = (BaseClientResponse)this.delete();
        response.setReturnType(returnType);
        return response;
    }

    public <T> ClientResponse<T> delete(Class<T> returnType, Type genericType) throws Exception {
        BaseClientResponse response = (BaseClientResponse)this.delete();
        response.setReturnType(returnType);
        response.setGenericReturnType(genericType);
        return response;
    }

    public <T> ClientResponse<T> delete(GenericType type) throws Exception {
        BaseClientResponse response = (BaseClientResponse)this.delete();
        response.setReturnType(type.getType());
        response.setGenericReturnType(type.getGenericType());
        return response;
    }

    public ClientResponse options() throws Exception {
        return this.httpMethod("OPTIONS");
    }

    public <T> ClientResponse<T> options(Class<T> returnType) throws Exception {
        BaseClientResponse response = (BaseClientResponse)this.options();
        response.setReturnType(returnType);
        return response;
    }

    public <T> ClientResponse<T> options(Class<T> returnType, Type genericType) throws Exception {
        BaseClientResponse response = (BaseClientResponse)this.options();
        response.setReturnType(returnType);
        response.setGenericReturnType(genericType);
        return response;
    }

    public <T> ClientResponse<T> options(GenericType type) throws Exception {
        BaseClientResponse response = (BaseClientResponse)this.options();
        response.setReturnType(type.getType());
        response.setGenericReturnType(type.getGenericType());
        return response;
    }

    public ClientResponse httpMethod(String httpMethod) throws Exception {
        this.httpMethod = httpMethod;
        return this.execute();
    }

    public <T> ClientResponse<T> httpMethod(String method, Class<T> returnType) throws Exception {
        BaseClientResponse response = (BaseClientResponse)this.httpMethod(method);
        response.setReturnType(returnType);
        return response;
    }

    public <T> ClientResponse<T> httpmethod(String method, Class<T> returnType, Type genericType) throws Exception {
        BaseClientResponse response = (BaseClientResponse)this.httpMethod(method);
        response.setReturnType(returnType);
        response.setGenericReturnType(genericType);
        return response;
    }

    public <T> ClientResponse<T> httpMethod(String method, GenericType type) throws Exception {
        BaseClientResponse response = (BaseClientResponse)this.httpMethod(method);
        response.setReturnType(type.getType());
        response.setGenericReturnType(type.getGenericType());
        return response;
    }

    public String getUri() throws Exception {
        List values;
        if (this.finalUri != null) {
            return this.finalUri;
        }
        UriBuilderImpl builder = (UriBuilderImpl)this.uri.clone();
        if (this.pathParameters != null) {
            for (Map.Entry entry : this.pathParameters.entrySet()) {
                values = (List)entry.getValue();
                for (String value : values) {
                    builder.substitutePathParam((String)entry.getKey(), value, false);
                }
            }
        }
        if (this.matrixParameters != null && this.matrixParameters != null) {
            for (Map.Entry entry : this.matrixParameters.entrySet()) {
                values = (List)entry.getValue();
                for (String value : values) {
                    builder.matrixParam((String)entry.getKey(), value);
                }
            }
        }
        if (this.queryParameters != null) {
            for (Map.Entry entry : this.queryParameters.entrySet()) {
                values = (List)entry.getValue();
                for (String value : values) {
                    builder.queryParam((String)entry.getKey(), value);
                }
            }
        }
        this.finalUri = builder.build(new Object[0]).toString();
        return this.finalUri;
    }
}

